/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.sql.Timestamp;
import org.teiid.translator.ExecutionContext;

public class CommandLogMessage {
    private boolean source;
    private Event event;
    private long timestamp;
    private String transactionID;
    private String sessionID;
    private String applicationName;
    private String principal;
    private String vdbName;
    private int vdbVersion;
    private String requestID;
    private Long sourceCommandID;
    private String sql;
    private Integer rowCount;
    private String modelName;
    private String connectorBindingName;
    private ExecutionContext executionContext;

    public CommandLogMessage(long timestamp, String requestID, String transactionID, String sessionID, String applicationName, String principal, String vdbName, int vdbVersion, String sql) {
        this(timestamp, requestID, transactionID, sessionID, principal, vdbName, vdbVersion, null, Event.NEW);
        this.applicationName = applicationName;
        this.sql = sql;
    }

    public CommandLogMessage(long timestamp, String requestID, String transactionID, String sessionID, String principal, String vdbName, int vdbVersion, Integer finalRowCount, Event event) {
        this.event = event;
        this.timestamp = timestamp;
        this.requestID = requestID;
        this.transactionID = transactionID;
        this.sessionID = sessionID;
        this.principal = principal;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.rowCount = finalRowCount;
    }

    public CommandLogMessage(long timestamp, String requestID, long sourceCommandID, String transactionID, String modelName, String connectorBindingName, String sessionID, String principal, String sql, ExecutionContext context) {
        this(timestamp, requestID, sourceCommandID, transactionID, modelName, connectorBindingName, sessionID, principal, null, Event.NEW, context);
        this.sql = sql;
    }

    public CommandLogMessage(long timestamp, String requestID, long sourceCommandID, String transactionID, String modelName, String connectorBindingName, String sessionID, String principal, Integer finalRowCount, Event event, ExecutionContext context) {
        this.source = true;
        this.event = event;
        this.timestamp = timestamp;
        this.requestID = requestID;
        this.sourceCommandID = sourceCommandID;
        this.transactionID = transactionID;
        this.modelName = modelName;
        this.connectorBindingName = connectorBindingName;
        this.sessionID = sessionID;
        this.principal = principal;
        this.rowCount = finalRowCount;
        this.executionContext = context;
    }

    public String toString() {
        if (!this.source && this.event == Event.NEW) {
            return "\tSTART USER COMMAND:\tstartTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\ttxID=" + this.transactionID + "\tsessionID=" + this.sessionID + "\tapplicationName=" + this.applicationName + "\tprincipal=" + this.principal + "\tvdbName=" + this.vdbName + "\tvdbVersion=" + this.vdbVersion + "\tsql=" + this.sql;
        }
        if (!this.source) {
            return "\t" + (Object)((Object)this.event) + " USER COMMAND:\tendTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\ttxID=" + this.transactionID + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + "\tvdbName=" + this.vdbName + "\tvdbVersion=" + this.vdbVersion + "\tfinalRowCount=" + this.rowCount;
        }
        if (this.event == Event.NEW) {
            return "\tSTART DATA SRC COMMAND:\tstartTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\tsourceCommandID=" + this.sourceCommandID + "\ttxID=" + this.transactionID + "\tmodelName=" + this.modelName + "\tconnectorBindingName=" + this.connectorBindingName + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + "\tsql=" + this.sql;
        }
        return "\t" + (Object)((Object)this.event) + " SRC COMMAND:\tendTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\tsourceCommandID=" + this.sourceCommandID + "\ttxID=" + this.transactionID + "\tmodelName=" + this.modelName + "\tconnectorBindingName=" + this.connectorBindingName + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + "\tfinalRowCount=" + this.rowCount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public int getVdbVersion() {
        return this.vdbVersion;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public Long getSourceCommandID() {
        return this.sourceCommandID;
    }

    public String getSql() {
        return this.sql;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getConnectorBindingName() {
        return this.connectorBindingName;
    }

    public Event getStatus() {
        return this.event;
    }

    public boolean isSource() {
        return this.source;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public static enum Event {
        NEW,
        END,
        CANCEL,
        ERROR;

    }
}

