/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.util.Arrays;
import java.util.List;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.InsertValueSource;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.ScalarSubquery;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.TableReference;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;

public class LanguageFactory {
    public static final LanguageFactory INSTANCE = new LanguageFactory();

    public AggregateFunction createAggregate(String name, boolean isDistinct, Expression expression, Class<?> type) {
        return new AggregateFunction(name, isDistinct, expression, type);
    }

    public Comparison createCompareCriteria(Comparison.Operator operator, Expression leftExpression, Expression rightExpression) {
        return new Comparison(leftExpression, rightExpression, operator);
    }

    public AndOr createAndOr(AndOr.Operator operator, Condition left, Condition right) {
        return new AndOr(left, right, operator);
    }

    public Delete createDelete(NamedTable group, Condition where) {
        return new Delete(group, where);
    }

    public ColumnReference createColumnReference(String name, NamedTable group, Column metadataReference, Class<?> type) {
        return new ColumnReference(group, name, metadataReference, type);
    }

    public Exists createExists(Select query) {
        return new Exists(query);
    }

    public Function createFunction(String functionName, Expression[] args, Class<?> type) {
        return new Function(functionName, Arrays.asList(args), type);
    }

    public Function createFunction(String functionName, List<? extends Expression> args, Class<?> type) {
        return new Function(functionName, args, type);
    }

    public NamedTable createNamedTable(String name, String correlationName, Table metadataReference) {
        return new NamedTable(name, correlationName, metadataReference);
    }

    public GroupBy createGroupBy(List<Expression> items) {
        return new GroupBy(items);
    }

    public In createIn(Expression leftExpression, List<Expression> rightExpressions, boolean isNegated) {
        return new In(leftExpression, rightExpressions, isNegated);
    }

    public Insert createInsert(NamedTable group, List<ColumnReference> columns, InsertValueSource valueSource) {
        return new Insert(group, columns, valueSource);
    }

    public ExpressionValueSource createInsertExpressionValueSource(List<Expression> values) {
        return new ExpressionValueSource(values);
    }

    public IsNull createIsNullCriteria(Expression expression, boolean isNegated) {
        return new IsNull(expression, isNegated);
    }

    public Join createJoin(Join.JoinType joinType, TableReference leftItem, TableReference rightItem, Condition condition) {
        return new Join(leftItem, rightItem, joinType, condition);
    }

    public Like createLikeCriteria(Expression leftExpression, Expression rightExpression, Character escapeCharacter, boolean isNegated) {
        return new Like(leftExpression, rightExpression, escapeCharacter, isNegated);
    }

    public Literal createLiteral(Object value, Class<?> type) {
        return new Literal(value, type);
    }

    public Not createNot(Condition criteria) {
        return new Not(criteria);
    }

    public OrderBy createOrderBy(List<SortSpecification> items) {
        return new OrderBy(items);
    }

    public SortSpecification createOrderByItem(ColumnReference element, SortSpecification.Ordering direction) {
        return new SortSpecification(direction, element);
    }

    public Argument createArgument(Argument.Direction direction, Literal value, Class<?> type, ProcedureParameter metadataReference) {
        return new Argument(direction, value, type, metadataReference);
    }

    public Call createCall(String name, List<Argument> parameters, Procedure metadataReference) {
        return new Call(name, parameters, metadataReference);
    }

    public Select createQuery(List<DerivedColumn> select, boolean isDistinct, List<TableReference> from, Condition where, GroupBy groupBy, Condition having, OrderBy orderBy) {
        return new Select(select, isDistinct, from, where, groupBy, having, orderBy);
    }

    public ScalarSubquery createScalarSubquery(Select query) {
        return new ScalarSubquery(query);
    }

    public SearchedCase createSearchedCaseExpression(List<SearchedWhenClause> cases, Expression elseExpression, Class<?> type) {
        return new SearchedCase(cases, elseExpression, type);
    }

    public SearchedWhenClause createSearchedWhenCondition(Condition condition, Expression result) {
        return new SearchedWhenClause(condition, result);
    }

    public DerivedColumn createSelectSymbol(String name, Expression expression) {
        return new DerivedColumn(name, expression);
    }

    public SubqueryComparison createSubqueryCompareCriteria(Expression leftExpression, Comparison.Operator operator, SubqueryComparison.Quantifier quantifier, Select subquery) {
        return new SubqueryComparison(leftExpression, operator, quantifier, subquery);
    }

    public SubqueryIn createSubqueryInCriteria(Expression expression, Select subquery, boolean isNegated) {
        return new SubqueryIn(expression, isNegated, subquery);
    }

    public Update createUpdate(NamedTable group, List<SetClause> updates, Condition criteria) {
        return new Update(group, updates, criteria);
    }

    public DerivedTable createInlineView(QueryExpression query, String name) {
        return new DerivedTable(query, name);
    }

    public SetQuery createSetOp(SetQuery.Operation operation, boolean all, QueryExpression leftQuery, QueryExpression rightQuery, OrderBy orderBy, Limit limit) {
        SetQuery queryImpl = new SetQuery();
        queryImpl.setOperation(operation);
        queryImpl.setAll(all);
        queryImpl.setLeftQuery(leftQuery);
        queryImpl.setRightQuery(rightQuery);
        queryImpl.setOrderBy(orderBy);
        queryImpl.setLimit(limit);
        return queryImpl;
    }

    public SetClause createSetClause(ColumnReference symbol, Expression value) {
        return new SetClause(symbol, value);
    }
}

