/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.teiid.logging.JavaLogger;
import org.teiid.logging.LogMessage;
import org.teiid.logging.Logger;

public final class LogManager {
    static Logger logListener = new JavaLogger();

    public static void logCritical(String context, String message) {
        LogManager.logMessage(1, context, message);
    }

    public static void logCritical(String context, Throwable e, String message) {
        LogManager.log(1, context, e, message);
    }

    public static void logError(String context, String message) {
        LogManager.logMessage(2, context, message);
    }

    public static void logError(String context, Throwable e, String message) {
        LogManager.log(2, context, e, message);
    }

    public static void logWarning(String context, String message) {
        LogManager.logMessage(3, context, message);
    }

    public static void logWarning(String context, Throwable e, String message) {
        LogManager.log(3, context, e, message);
    }

    public static void logInfo(String context, String message) {
        LogManager.logMessage(4, context, message);
    }

    public static void logDetail(String context, Object ... msgParts) {
        LogManager.logMessage(5, context, msgParts);
    }

    public static void logDetail(String context, Throwable e, Object ... message) {
        LogManager.log(5, context, e, message);
    }

    public static void logTrace(String context, Object ... msgParts) {
        LogManager.logMessage(6, context, msgParts);
    }

    public static void logTrace(String context, Throwable e, Object ... msgParts) {
        LogManager.logMessage(6, context, e, msgParts);
    }

    public static void log(int msgLevel, String context, Object message) {
        LogManager.logMessage(msgLevel, context, message);
    }

    public static void log(int msgLevel, String context, Throwable e, Object message) {
        if (!LogManager.isMessageToBeRecorded(context, msgLevel)) {
            return;
        }
        if (message != null && message.getClass().isArray()) {
            message = new LogMessage((Object[])message);
        }
        logListener.log(msgLevel, context, e, message);
    }

    public static void setLogListener(Logger listener) {
        logListener.shutdown();
        logListener = listener != null ? listener : new JavaLogger();
    }

    public static boolean isMessageToBeRecorded(String context, int msgLevel) {
        if (logListener != null) {
            return logListener.isEnabled(context, msgLevel);
        }
        return true;
    }

    private static void logMessage(int level, String context, Object ... msgParts) {
        if (msgParts == null || msgParts.length == 0 || !LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        logListener.log(level, context, msgParts.length == 1 ? msgParts[0] : new LogMessage(msgParts));
    }

    public static Object createLoggingProxy(String loggingContext, Object instance, Class<?>[] interfaces, int level) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new LoggingProxy(instance, loggingContext, level));
    }

    public static Object createLoggingProxy(String loggingContext, Object instance, Class<?>[] interfaces, int level, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new LoggingProxy(instance, loggingContext, level));
    }

    public static class LoggingProxy
    implements InvocationHandler {
        private final Object instance;
        private final String loggingContext;
        private final int level;

        public LoggingProxy(Object instance, String loggingContext, int level) {
            this.instance = instance;
            this.loggingContext = loggingContext;
            this.level = level;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean log = LogManager.isMessageToBeRecorded(this.loggingContext, this.level);
            if (log) {
                StringBuffer message = new StringBuffer();
                message.append("before ");
                message.append(method.getName());
                message.append(":");
                message.append(this.instance);
                message.append("(");
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] != null) {
                            message.append(args[i]);
                        } else {
                            message.append("null");
                        }
                        if (i == args.length - 1) continue;
                        message.append(",");
                    }
                }
                message.append(")");
                LogManager.log(this.level, this.loggingContext, message.toString());
            }
            try {
                Object result = method.invoke(this.instance, args);
                if (log) {
                    LogManager.log(this.level, this.loggingContext, "after " + method.getName() + " : " + result);
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

