/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;

public class MetadataFactory
extends Schema {
    private static final long serialVersionUID = 8590341087771685630L;
    private String vdbName;
    private int vdbVersion;
    private Map<String, Datatype> dataTypes;
    private boolean autoCorrectColumnNames = true;
    private Map<String, String> namespaces = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String rawMetadata;
    private Properties importProperties;

    public MetadataFactory(String vdbName, int vdbVersion, String schemaName, Map<String, Datatype> dataTypes, Properties importProperties, String rawMetadata) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.dataTypes = dataTypes;
        this.setName(schemaName);
        this.setUUID(this);
        this.importProperties = importProperties;
        this.rawMetadata = rawMetadata;
    }

    public Properties getImportProperties() {
        return this.importProperties;
    }

    public String getRawMetadata() {
        return this.rawMetadata;
    }

    protected void setUUID(AbstractMetadataRecord record) {
        record.setUUID("mmuuid:" + UUID.randomUUID());
    }

    public Table addTable(String name) throws TranslatorException {
        Table table = new Table();
        table.setTableType(Table.Type.Table);
        table.setName(name);
        this.setUUID(table);
        this.addTable(table);
        return table;
    }

    public Column addColumn(String name, String type, ColumnSet<?> table) throws TranslatorException {
        if (this.autoCorrectColumnNames) {
            name.replace('.', '_');
        } else if (name.indexOf(46) != -1) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60008, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60008, new Object[]{name}));
        }
        Column column = new Column();
        column.setName(name);
        table.addColumn(column);
        column.setPosition(table.getColumns().size());
        Datatype datatype = this.setColumnType(type, column);
        column.setCaseSensitive(datatype.isCaseSensitive());
        column.setAutoIncremented(datatype.isAutoIncrement());
        column.setSigned(datatype.isSigned());
        this.setUUID(column);
        return column;
    }

    private Datatype setColumnType(String type, BaseColumn column) throws TranslatorException {
        Datatype datatype = this.dataTypes.get(type);
        if (datatype == null) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60009, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60009, new Object[]{type}));
        }
        column.setDatatype(datatype);
        column.setDatatypeUUID(datatype.getUUID());
        column.setLength(datatype.getLength());
        column.setPrecision(datatype.getPrecisionLength());
        column.setRadix(datatype.getRadix());
        column.setRuntimeType(datatype.getRuntimeTypeName());
        return datatype;
    }

    public KeyRecord addPrimaryKey(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord primaryKey = new KeyRecord(KeyRecord.Type.Primary);
        primaryKey.setParent(table);
        primaryKey.setColumns(new ArrayList<Column>(columnNames.size()));
        primaryKey.setName(name);
        this.setUUID(primaryKey);
        this.assignColumns(columnNames, table, primaryKey);
        table.setPrimaryKey(primaryKey);
        return primaryKey;
    }

    public KeyRecord addAccessPattern(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord ap = new KeyRecord(KeyRecord.Type.AccessPattern);
        ap.setParent(table);
        ap.setColumns(new ArrayList<Column>(columnNames.size()));
        ap.setName(name);
        this.setUUID(ap);
        this.assignColumns(columnNames, table, ap);
        table.getAccessPatterns().add(ap);
        return ap;
    }

    public KeyRecord addIndex(String name, boolean nonUnique, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord index = new KeyRecord(nonUnique ? KeyRecord.Type.Index : KeyRecord.Type.Unique);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(columnNames.size()));
        index.setName(name);
        this.setUUID(index);
        this.assignColumns(columnNames, table, index);
        if (nonUnique) {
            table.getIndexes().add(index);
        } else {
            table.getUniqueKeys().add(index);
        }
        return index;
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, String referenceTable, Table table) throws TranslatorException {
        return this.addForiegnKey(name, columnNames, null, referenceTable, table);
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, List<String> referencedColumnNames, String referenceTable, Table table) throws TranslatorException {
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setParent(table);
        foreignKey.setColumns(new ArrayList<Column>(columnNames.size()));
        this.assignColumns(columnNames, table, foreignKey);
        foreignKey.setReferenceTableName(referenceTable);
        foreignKey.setReferenceColumns(referencedColumnNames);
        foreignKey.setName(name);
        this.setUUID(foreignKey);
        table.getForeignKeys().add(foreignKey);
        return foreignKey;
    }

    public Procedure addProcedure(String name) throws TranslatorException {
        Procedure procedure = new Procedure();
        procedure.setName(name);
        this.setUUID(procedure);
        procedure.setParameters(new LinkedList<ProcedureParameter>());
        this.addProcedure(procedure);
        return procedure;
    }

    public ProcedureParameter addProcedureParameter(String name, String type, ProcedureParameter.Type parameterType, Procedure procedure) throws TranslatorException {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        this.setUUID(param);
        param.setType(parameterType);
        param.setProcedure(procedure);
        this.setColumnType(type, param);
        procedure.getParameters().add(param);
        param.setPosition(procedure.getParameters().size());
        return param;
    }

    public Column addProcedureResultSetColumn(String name, String type, Procedure procedure) throws TranslatorException {
        if (procedure.getResultSet() == null) {
            ColumnSet<Procedure> resultSet = new ColumnSet<Procedure>();
            resultSet.setParent(procedure);
            resultSet.setName("RSParam");
            this.setUUID(resultSet);
            procedure.setResultSet(resultSet);
        }
        return this.addColumn(name, type, procedure.getResultSet());
    }

    private void assignColumns(List<String> columnNames, Table table, ColumnSet<?> columns) throws TranslatorException {
        for (String columnName : columnNames) {
            boolean match = false;
            for (Column column : table.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                match = true;
                columns.getColumns().add(column);
                break;
            }
            if (match) continue;
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60011, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60011, new Object[]{columnName}));
        }
    }

    public FunctionMethod addFunction(String name) throws TranslatorException {
        FunctionMethod function = new FunctionMethod();
        function.setName(name);
        this.setUUID(function);
        this.addFunction(function);
        return function;
    }

    public void setAutoCorrectColumnNames(boolean autoCorrectColumnNames) {
        this.autoCorrectColumnNames = autoCorrectColumnNames;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public void mergeInto(MetadataStore store) {
        store.addSchema(this);
        store.addDataTypes(this.dataTypes.values());
        store.addNamespaces(this.namespaces);
    }

    public MetadataStore asMetadataStore() {
        MetadataStore store = new MetadataStore();
        this.mergeInto(store);
        return store;
    }

    public void mergeFrom(Schema schema) {
        this.setName(schema.getName());
        this.setUUID(schema.getUUID());
        for (Table t : schema.getTables().values()) {
            this.addTable(t);
        }
        for (Procedure p : schema.getProcedures().values()) {
            this.addProcedure(p);
        }
        for (FunctionMethod fm : schema.getFunctions().values()) {
            this.addFunction(fm);
        }
        this.setProperties(new LinkedHashMap<String, String>(schema.getProperties()));
    }

    public Map<String, Datatype> getDataTypes() {
        return this.dataTypes;
    }

    void addDataTypes(Collection<Datatype> types) {
        for (Datatype type : types) {
            this.addDatatype(type);
        }
    }

    public void addDatatype(Datatype datatype) {
        if (this.dataTypes == null) {
            this.dataTypes = new TreeMap<String, Datatype>();
        }
        this.dataTypes.put(datatype.getName(), datatype);
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public int getVdbVersion() {
        return this.vdbVersion;
    }
}

