/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Schema;

public class MetadataStore
implements Serializable {
    private static final long serialVersionUID = -3130247626435324312L;
    protected Map<String, Schema> schemas = new TreeMap<String, Schema>(String.CASE_INSENSITIVE_ORDER);
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected Map<String, Datatype> datatypes = new TreeMap<String, Datatype>();
    protected Map<String, String> namespaces = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        Schema s = this.schemas.get(name);
        if (s == null) {
            s = this.schemas.get(name.toUpperCase());
        }
        return s;
    }

    public void addSchema(Schema schema) {
        if (this.schemas.put(schema.getCanonicalName(), schema) != null) {
            throw new DuplicateRecordException(DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60012, new Object[]{schema.getName()}));
        }
        this.schemaList.add(schema);
    }

    public List<Schema> getSchemaList() {
        return this.schemaList;
    }

    void addDataTypes(Collection<Datatype> types) {
        if (types != null) {
            for (Datatype type : types) {
                this.addDatatype(type);
            }
        }
    }

    public void addDatatype(Datatype datatype) {
        this.datatypes.put(datatype.getName(), datatype);
    }

    public Map<String, Datatype> getDatatypes() {
        return this.datatypes;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    void addNamespaces(Map<String, String> namespaces) {
        this.namespaces.putAll(namespaces);
    }

    public void merge(MetadataStore store) {
        if (store != null) {
            for (Schema s : store.getSchemaList()) {
                this.addSchema(s);
            }
            this.addDataTypes(store.getDatatypes().values());
        }
    }
}

