/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;

public abstract class AbstractMetadataRecord
implements Serializable {
    private static final long serialVersionUID = 564092984812414058L;
    public static final char NAME_DELIM_CHAR = '.';
    private static AtomicLong UUID_SEQUENCE = new AtomicLong();
    private String uuid;
    private String name;
    private String nameInSource;
    private LinkedHashMap<String, String> properties;
    private String annotation;
    public static final String RELATIONAL_URI = "{http://www.teiid.org/ext/relational/2012}";

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = String.valueOf(UUID_SEQUENCE.getAndIncrement());
        }
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String nameInSource) {
        this.nameInSource = DataTypeManager.getCanonicalString((String)nameInSource);
    }

    public String getFullName() {
        AbstractMetadataRecord parent = this.getParent();
        if (parent != null) {
            String result = parent.getFullName() + '.' + this.getName();
            return result;
        }
        return this.name;
    }

    public AbstractMetadataRecord getParent() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = DataTypeManager.getCanonicalString((String)name);
    }

    public String getCanonicalName() {
        return this.name.toUpperCase();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getSimpleName());
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", nameInSource=");
        sb.append(this.getNameInSource());
        sb.append(", uuid=");
        sb.append(this.getUUID());
        return sb.toString();
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public String getProperty(String key, boolean checkUnqualified) {
        String value = this.getProperties().get(key);
        if (value != null || !checkUnqualified) {
            return value;
        }
        int index = key.indexOf(125);
        if (index > 0 && index < key.length() && key.charAt(0) == '{') {
            key = key.substring(index + 1, key.length());
        }
        return this.getProperties().get(key);
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.remove(key);
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.put(DataTypeManager.getCanonicalString((String)key), DataTypeManager.getCanonicalString((String)value));
    }

    public void setProperties(LinkedHashMap<String, String> properties) {
        this.properties = properties;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = DataTypeManager.getCanonicalString((String)annotation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        return EquivalenceUtil.areEqual((Object)this.getUUID(), (Object)other.getUUID());
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public static interface DataModifiable {
        public long getLastDataModification();
    }

    public static interface Modifiable {
        public long getLastModified();
    }
}

