/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;

public class Schema
extends AbstractMetadataRecord {
    private static final long serialVersionUID = -5113742472848113008L;
    private boolean physical = true;
    private boolean isVisible = true;
    private String primaryMetamodelUri = "http://www.metamatrix.com/metamodels/Relational";
    private Map<String, Table> tables = new TreeMap<String, Table>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Procedure> procedures = new TreeMap<String, Procedure>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, FunctionMethod> functions = new TreeMap<String, FunctionMethod>(String.CASE_INSENSITIVE_ORDER);

    public void addTable(Table table) {
        table.setParent(this);
        if (this.tables.put(table.getName(), table) != null) {
            throw new DuplicateRecordException(DataPlugin.Util.getString("Schema.duplicate_table", new Object[]{table.getName()}));
        }
    }

    public void addProcedure(Procedure procedure) {
        procedure.setParent(this);
        if (this.procedures.put(procedure.getName(), procedure) != null) {
            throw new DuplicateRecordException(DataPlugin.Util.getString("Schema.duplicate_procedure", new Object[]{procedure.getName()}));
        }
    }

    public void addFunction(FunctionMethod function) {
        function.setParent(this);
        if (this.functions.put(function.getName(), function) != null) {
            throw new DuplicateRecordException(DataPlugin.Util.getString("Schema.duplicate_function", new Object[]{function.getName()}));
        }
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public Map<String, Procedure> getProcedures() {
        return this.procedures;
    }

    public Map<String, FunctionMethod> getFunctions() {
        return this.functions;
    }

    public String getPrimaryMetamodelUri() {
        return this.primaryMetamodelUri;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public void setPrimaryMetamodelUri(String string) {
        this.primaryMetamodelUri = string;
    }

    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    public void setPhysical(boolean physical) {
        this.physical = physical;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.functions == null) {
            this.functions = new LinkedHashMap<String, FunctionMethod>();
        }
    }
}

