/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Datatype;

public class Column
extends BaseColumn
implements Comparable<Column> {
    private static final long serialVersionUID = -1310120788764453726L;
    private boolean selectable = true;
    private boolean updatable;
    private boolean autoIncremented;
    private boolean caseSensitive;
    private boolean signed;
    private boolean currency;
    private boolean fixedLength;
    private SearchType searchType;
    private String minimumValue;
    private String maximumValue;
    private String nativeType;
    private String format;
    private int charOctetLength;
    private int distinctValues = -1;
    private int nullValues = -1;
    private ColumnSet<?> parent;

    @Override
    public void setDatatype(Datatype datatype, boolean copyAttributes) {
        super.setDatatype(datatype, copyAttributes);
        if (datatype != null && copyAttributes) {
            this.signed = datatype.isSigned();
            this.autoIncremented = datatype.isAutoIncrement();
            this.caseSensitive = datatype.isCaseSensitive();
            this.signed = datatype.isSigned();
        }
    }

    public void setParent(ColumnSet<?> parent) {
        this.parent = parent;
    }

    @Override
    public ColumnSet<?> getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(Column record) {
        return this.getPosition() - record.getPosition();
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public String getMaximumValue() {
        return this.maximumValue;
    }

    public String getMinimumValue() {
        return this.minimumValue;
    }

    public SearchType getSearchType() {
        if (this.searchType == null) {
            return this.getDatatype().getSearchType();
        }
        return this.searchType;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public int getDistinctValues() {
        return this.distinctValues;
    }

    public int getNullValues() {
        return this.nullValues;
    }

    public void setAutoIncremented(boolean b) {
        this.autoIncremented = b;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public void setCharOctetLength(int i) {
        this.charOctetLength = i;
    }

    public void setCurrency(boolean b) {
        this.currency = b;
    }

    public void setFixedLength(boolean b) {
        this.fixedLength = b;
    }

    public void setMaximumValue(String object) {
        this.maximumValue = DataTypeManager.getCanonicalString((String)object);
    }

    public void setMinimumValue(String object) {
        this.minimumValue = DataTypeManager.getCanonicalString((String)object);
    }

    public void setSearchType(SearchType s) {
        this.searchType = s;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    public void setSigned(boolean b) {
        this.signed = b;
    }

    public void setUpdatable(boolean b) {
        this.updatable = b;
    }

    public void setFormat(String string) {
        this.format = DataTypeManager.getCanonicalString((String)string);
    }

    public void setDistinctValues(int distinctValues) {
        this.distinctValues = distinctValues;
    }

    public void setNullValues(int nullValues) {
        this.nullValues = nullValues;
    }

    public void setNativeType(String nativeType) {
        this.nativeType = DataTypeManager.getCanonicalString((String)nativeType);
    }

    public void setColumnStats(ColumnStats stats) {
        if (stats.getDistinctValues() != null) {
            this.setDistinctValues(stats.getDistinctValues());
        }
        if (stats.getNullValues() != null) {
            this.setNullValues(stats.getNullValues());
        }
        if (stats.getMaximumValue() != null) {
            this.setMaximumValue(stats.getMaximumValue());
        }
        if (stats.getMinimumValue() != null) {
            this.setMinimumValue(stats.getMinimumValue());
        }
    }

    public static enum SearchType {
        Unsearchable,
        Like_Only{

            public String toString() {
                return "Like Only";
            }
        }
        ,
        All_Except_Like{

            public String toString() {
                return "All Except Like";
            }
        }
        ,
        Searchable;

    }
}

