/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;

public class MetadataFactory
implements Serializable {
    private static final long serialVersionUID = 8590341087771685630L;
    private String vdbName;
    private int vdbVersion;
    private Map<String, Datatype> dataTypes;
    private Map<String, Datatype> builtinDataTypes;
    private boolean autoCorrectColumnNames = true;
    private Map<String, String> namespaces = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String rawMetadata;
    private Properties importProperties;
    private Schema schema = new Schema();
    private String idPrefix;
    private int count;

    public MetadataFactory(String vdbName, int vdbVersion, String schemaName, Map<String, Datatype> runtimeTypes, Properties importProperties, String rawMetadata) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.dataTypes = runtimeTypes;
        this.builtinDataTypes = runtimeTypes;
        this.schema.setName(schemaName);
        long msb = this.longHash(vdbName, 0L);
        msb = 31L * msb + (long)vdbVersion;
        msb = this.longHash(schemaName, msb);
        this.idPrefix = "tid:" + MetadataFactory.hex(msb, 12);
        this.setUUID(this.schema);
        this.importProperties = importProperties;
        this.rawMetadata = rawMetadata;
    }

    private long longHash(String s, long h) {
        if (s == null) {
            return h;
        }
        for (int i = 0; i < s.length(); ++i) {
            h = 31L * h + (long)s.charAt(i);
        }
        return h;
    }

    private static String hex(long val, int hexLength) {
        long hi = 1L << hexLength * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public Properties getImportProperties() {
        return this.importProperties;
    }

    public String getRawMetadata() {
        return this.rawMetadata;
    }

    protected void setUUID(AbstractMetadataRecord record) {
        int lsb = 0;
        if (record.getParent() != null) {
            lsb = record.getParent().getUUID().hashCode();
        }
        lsb = 31 * lsb + record.getName().hashCode();
        String uuid = this.idPrefix + "-" + MetadataFactory.hex(lsb, 8) + "-" + MetadataFactory.hex(this.count++, 8);
        record.setUUID(uuid);
    }

    public String getName() {
        return this.schema.getName();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Table addTable(String name) throws TranslatorException {
        Table table = new Table();
        table.setTableType(Table.Type.Table);
        table.setName(name);
        this.setUUID(table);
        this.schema.addTable(table);
        return table;
    }

    public Column addColumn(String name, String type, ColumnSet<?> table) throws TranslatorException {
        if (this.autoCorrectColumnNames) {
            name.replace('.', '_');
        } else if (name.indexOf(46) != -1) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60008, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60008, new Object[]{name}));
        }
        if (table.getColumnByName(name) != null) {
            throw new DuplicateRecordException(DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60016, new Object[]{table.getFullName() + '.' + name}));
        }
        Column column = new Column();
        column.setName(name);
        table.addColumn(column);
        column.setParent(table);
        column.setPosition(table.getColumns().size());
        this.setColumnType(type, column);
        this.setUUID(column);
        return column;
    }

    private Datatype setColumnType(String type, BaseColumn column) throws TranslatorException {
        Datatype datatype = this.dataTypes.get(type);
        if (datatype == null) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60009, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60009, new Object[]{type}));
        }
        column.setDatatype(datatype, true);
        return datatype;
    }

    public KeyRecord addPrimaryKey(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord primaryKey = new KeyRecord(KeyRecord.Type.Primary);
        primaryKey.setParent(table);
        primaryKey.setColumns(new ArrayList<Column>(columnNames.size()));
        primaryKey.setName(name);
        this.setUUID(primaryKey);
        this.assignColumns(columnNames, table, primaryKey);
        table.setPrimaryKey(primaryKey);
        return primaryKey;
    }

    public KeyRecord addAccessPattern(String name, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord ap = new KeyRecord(KeyRecord.Type.AccessPattern);
        ap.setParent(table);
        ap.setColumns(new ArrayList<Column>(columnNames.size()));
        ap.setName(name);
        this.setUUID(ap);
        this.assignColumns(columnNames, table, ap);
        table.getAccessPatterns().add(ap);
        return ap;
    }

    public KeyRecord addIndex(String name, boolean nonUnique, List<String> columnNames, Table table) throws TranslatorException {
        KeyRecord index = new KeyRecord(nonUnique ? KeyRecord.Type.Index : KeyRecord.Type.Unique);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(columnNames.size()));
        index.setName(name);
        this.setUUID(index);
        this.assignColumns(columnNames, table, index);
        if (nonUnique) {
            table.getIndexes().add(index);
        } else {
            table.getUniqueKeys().add(index);
        }
        return index;
    }

    public KeyRecord addFunctionBasedIndex(String name, List<String> expressions, List<Boolean> nonColumnExpressions, Table table) throws TranslatorException {
        KeyRecord index = new KeyRecord(KeyRecord.Type.Index);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(expressions.size()));
        index.setName(name);
        this.setUUID(index);
        boolean functionBased = false;
        for (int i = 0; i < expressions.size(); ++i) {
            String expr = expressions.get(i);
            if (nonColumnExpressions.get(i).booleanValue()) {
                Column c = new Column();
                c.setName(expr);
                c.setNameInSource(expr);
                this.setUUID(c);
                c.setParent(index);
                c.setPosition(i + 1);
                index.getColumns().add(c);
                functionBased = true;
                continue;
            }
            this.assignColumn(table, index, expr);
        }
        if (!functionBased) {
            table.getIndexes().add(index);
        } else {
            table.getFunctionBasedIndexes().add(index);
        }
        return index;
    }

    private void assignColumn(Table table, ColumnSet<?> columns, String columnName) throws TranslatorException {
        Column column = table.getColumnByName(columnName);
        if (column == null) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60011, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60011, new Object[]{columnName}));
        }
        columns.getColumns().add(column);
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, String referenceTable, Table table) throws TranslatorException {
        return this.addForiegnKey(name, columnNames, null, referenceTable, table);
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, List<String> referencedColumnNames, String referenceTable, Table table) throws TranslatorException {
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setParent(table);
        foreignKey.setColumns(new ArrayList<Column>(columnNames.size()));
        this.assignColumns(columnNames, table, foreignKey);
        foreignKey.setReferenceTableName(referenceTable);
        foreignKey.setReferenceColumns(referencedColumnNames);
        foreignKey.setName(name);
        this.setUUID(foreignKey);
        table.getForeignKeys().add(foreignKey);
        return foreignKey;
    }

    public Procedure addProcedure(String name) throws TranslatorException {
        Procedure procedure = new Procedure();
        procedure.setName(name);
        this.setUUID(procedure);
        procedure.setParameters(new LinkedList<ProcedureParameter>());
        this.schema.addProcedure(procedure);
        return procedure;
    }

    public ProcedureParameter addProcedureParameter(String name, String type, ProcedureParameter.Type parameterType, Procedure procedure) throws TranslatorException {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        this.setUUID(param);
        param.setType(parameterType);
        param.setProcedure(procedure);
        this.setColumnType(type, param);
        if (parameterType == ProcedureParameter.Type.ReturnValue) {
            procedure.getParameters().add(0, param);
            for (int i = 0; i < procedure.getParameters().size(); ++i) {
                procedure.getParameters().get(i).setPosition(i + 1);
            }
        } else {
            procedure.getParameters().add(param);
            param.setPosition(procedure.getParameters().size());
        }
        return param;
    }

    public Column addProcedureResultSetColumn(String name, String type, Procedure procedure) throws TranslatorException {
        if (procedure.getResultSet() == null) {
            ColumnSet<Procedure> resultSet = new ColumnSet<Procedure>();
            resultSet.setParent(procedure);
            resultSet.setName("RSParam");
            this.setUUID(resultSet);
            procedure.setResultSet(resultSet);
        }
        return this.addColumn(name, type, procedure.getResultSet());
    }

    private void assignColumns(List<String> columnNames, Table table, ColumnSet<?> columns) throws TranslatorException {
        for (String columnName : columnNames) {
            this.assignColumn(table, columns, columnName);
        }
    }

    public FunctionMethod addFunction(String name) throws TranslatorException {
        FunctionMethod function = new FunctionMethod();
        function.setName(name);
        this.setUUID(function);
        this.schema.addFunction(function);
        return function;
    }

    public void setAutoCorrectColumnNames(boolean autoCorrectColumnNames) {
        this.autoCorrectColumnNames = autoCorrectColumnNames;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public void mergeInto(MetadataStore store) {
        store.addSchema(this.schema);
        store.addDataTypes(this.builtinDataTypes.values());
    }

    public MetadataStore asMetadataStore() {
        MetadataStore store = new MetadataStore();
        this.mergeInto(store);
        return store;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Map<String, Datatype> getDataTypes() {
        return this.dataTypes;
    }

    public void correctDatatypes(Map<String, Datatype> dt, Map<String, Datatype> builtin) {
        this.dataTypes = dt;
        this.builtinDataTypes = builtin;
        for (Table t : this.schema.getTables().values()) {
            this.correctDataTypes(t.getColumns());
        }
        for (Procedure p : this.schema.getProcedures().values()) {
            this.correctDataTypes(p.getParameters());
            if (p.getResultSet() == null) continue;
            this.correctDataTypes(p.getResultSet().getColumns());
        }
    }

    private void correctDataTypes(List<? extends BaseColumn> cols) {
        if (cols == null) {
            return;
        }
        for (BaseColumn baseColumn : cols) {
            if (baseColumn.getDatatype() == null) continue;
            Datatype dt = this.builtinDataTypes.get(baseColumn.getDatatype().getName());
            if (dt != null) {
                baseColumn.setDatatype(dt);
                continue;
            }
            this.addDatatype(dt);
        }
    }

    public void addDatatype(Datatype datatype) {
        this.builtinDataTypes.put(datatype.getName(), datatype);
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public int getVdbVersion() {
        return this.vdbVersion;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setBuiltinDataTypes(Map<String, Datatype> builtinDataTypes) {
        this.builtinDataTypes = builtinDataTypes;
    }

    public Map<String, Datatype> getBuiltinDataTypes() {
        return this.builtinDataTypes;
    }
}

