/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.language.Comparison;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.Like;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.ScalarSubquery;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.Update;
import org.teiid.language.WindowFunction;
import org.teiid.language.WindowSpecification;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.language.visitor.AbstractLanguageVisitor;

public abstract class HierarchyVisitor
extends AbstractLanguageVisitor {
    private boolean visitSubcommands;

    public HierarchyVisitor() {
        this(true);
    }

    public HierarchyVisitor(boolean visitSubcommands) {
        this.visitSubcommands = visitSubcommands;
    }

    @Override
    public void visit(AggregateFunction obj) {
        this.visitNodes(obj.getParameters());
        this.visitNode(obj.getCondition());
    }

    @Override
    public void visit(BatchedUpdates obj) {
        this.visitNodes(obj.getUpdateCommands());
    }

    @Override
    public void visit(Comparison obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
    }

    @Override
    public void visit(AndOr obj) {
        this.visitNode(obj.getLeftCondition());
        this.visitNode(obj.getRightCondition());
    }

    @Override
    public void visit(Delete obj) {
        this.visitNode(obj.getTable());
        this.visitNode(obj.getWhere());
    }

    @Override
    public void visit(Call obj) {
        this.visitNodes(obj.getArguments());
    }

    @Override
    public void visit(Exists obj) {
        if (this.visitSubcommands) {
            this.visitNode(obj.getSubquery());
        }
    }

    @Override
    public void visit(Function obj) {
        this.visitNodes(obj.getParameters());
    }

    @Override
    public void visit(GroupBy obj) {
        this.visitNodes(obj.getElements());
    }

    @Override
    public void visit(In obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNodes(obj.getRightExpressions());
    }

    @Override
    public void visit(Insert obj) {
        this.visitNode(obj.getTable());
        this.visitNodes(obj.getColumns());
        if (!(obj.getValueSource() instanceof QueryExpression) || this.visitSubcommands) {
            this.visitNode(obj.getValueSource());
        }
    }

    @Override
    public void visit(ExpressionValueSource obj) {
        this.visitNodes(obj.getValues());
    }

    @Override
    public void visit(IsNull obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(Join obj) {
        this.visitNode(obj.getLeftItem());
        this.visitNode(obj.getRightItem());
        this.visitNode(obj.getCondition());
    }

    @Override
    public void visit(Like obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
    }

    @Override
    public void visit(Not obj) {
        this.visitNode(obj.getCriteria());
    }

    @Override
    public void visit(OrderBy obj) {
        this.visitNodes(obj.getSortSpecifications());
    }

    @Override
    public void visit(Select obj) {
        this.visitNode(obj.getWith());
        this.visitNodes(obj.getDerivedColumns());
        this.visitNodes(obj.getFrom());
        this.visitNode(obj.getWhere());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getLimit());
    }

    @Override
    public void visit(ScalarSubquery obj) {
        if (this.visitSubcommands) {
            this.visitNode(obj.getSubquery());
        }
    }

    @Override
    public void visit(SearchedCase obj) {
        this.visitNodes(obj.getCases());
        this.visitNode(obj.getElseExpression());
    }

    @Override
    public void visit(SearchedWhenClause obj) {
        this.visitNode(obj.getCondition());
        this.visitNode(obj.getResult());
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(SubqueryComparison obj) {
        this.visitNode(obj.getLeftExpression());
        if (this.visitSubcommands) {
            this.visitNode(obj.getSubquery());
        }
    }

    @Override
    public void visit(SubqueryIn obj) {
        this.visitNode(obj.getLeftExpression());
        if (this.visitSubcommands) {
            this.visitNode(obj.getSubquery());
        }
    }

    @Override
    public void visit(SetQuery obj) {
        this.visitNode(obj.getWith());
        if (this.visitSubcommands) {
            this.visitNode(obj.getLeftQuery());
            this.visitNode(obj.getRightQuery());
        }
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getLimit());
    }

    @Override
    public void visit(Update obj) {
        this.visitNode(obj.getTable());
        this.visitNodes(obj.getChanges());
        this.visitNode(obj.getWhere());
    }

    @Override
    public void visit(DerivedTable obj) {
        if (this.visitSubcommands) {
            this.visitNode(obj.getQuery());
        }
    }

    @Override
    public void visit(SetClause obj) {
        this.visitNode(obj.getSymbol());
        this.visitNode(obj.getValue());
    }

    @Override
    public void visit(With obj) {
        this.visitNodes(obj.getItems());
    }

    @Override
    public void visit(WithItem obj) {
        this.visitNode(obj.getTable());
        this.visitNodes(obj.getColumns());
        if (this.visitSubcommands) {
            this.visitNode(obj.getSubquery());
        }
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        this.visitNode(windowFunction.getFunction());
        this.visitNode(windowFunction.getWindowSpecification());
    }

    @Override
    public void visit(WindowSpecification windowSpecification) {
        this.visitNodes(windowSpecification.getPartition());
        this.visitNode(windowSpecification.getOrderBy());
    }
}

