/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.spi;

import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class ConnectionContext {
    private static ThreadLocal<Subject> SUBJECT = new ThreadLocal<Subject>(){

        @Override
        protected Subject initialValue() {
            return null;
        }
    };

    public static Subject getSubject() {
        return SUBJECT.get();
    }

    public static void setSubject(Subject subject) {
        SUBJECT.set(subject);
    }

    public static String getUserName(Subject subject, BasicManagedConnectionFactory mcf, String defalt) {
        Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
        if (creds != null && creds.size() > 0) {
            for (PasswordCredential cred : creds) {
                if (!cred.getManagedConnectionFactory().equals(mcf) || cred.getUserName() == null) continue;
                return cred.getUserName();
            }
        }
        return defalt;
    }

    public static String getPassword(Subject subject, BasicManagedConnectionFactory mcf, String userName, String defalt) {
        Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
        if (creds != null && creds.size() > 0) {
            for (PasswordCredential cred : creds) {
                if (!cred.getManagedConnectionFactory().equals(mcf) || !cred.getUserName().equals(userName) || cred.getPassword() == null) continue;
                return new String(cred.getPassword());
            }
        }
        return defalt;
    }
}

