/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;

public class Schema
extends AbstractMetadataRecord {
    private static final long serialVersionUID = -5113742472848113008L;
    private boolean physical = true;
    private String primaryMetamodelUri = "http://www.metamatrix.com/metamodels/Relational";
    private NavigableMap<String, Table> tables = new TreeMap<String, Table>(String.CASE_INSENSITIVE_ORDER);
    private NavigableMap<String, Procedure> procedures = new TreeMap<String, Procedure>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, FunctionMethod> functions = new TreeMap<String, FunctionMethod>(String.CASE_INSENSITIVE_ORDER);
    private List<AbstractMetadataRecord> resolvingOrder = new ArrayList<AbstractMetadataRecord>();

    public void addTable(Table table) {
        table.setParent(this);
        if (this.tables.put(table.getName(), table) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60013, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60013, new Object[]{table.getName()}));
        }
        this.resolvingOrder.add(table);
    }

    public void addProcedure(Procedure procedure) {
        procedure.setParent(this);
        if (this.procedures.put(procedure.getName(), procedure) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60014, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60014, new Object[]{procedure.getName()}));
        }
        this.resolvingOrder.add(procedure);
    }

    public void addFunction(FunctionMethod function) {
        function.setParent(this);
        if (this.functions.put(function.getUUID(), function) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60015, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60015, new Object[]{function.getUUID()}));
        }
        this.resolvingOrder.add(function);
    }

    public NavigableMap<String, Table> getTables() {
        return this.tables;
    }

    public Table getTable(String tableName) {
        return (Table)this.tables.get(tableName);
    }

    public NavigableMap<String, Procedure> getProcedures() {
        return this.procedures;
    }

    public Procedure getProcedure(String procName) {
        return (Procedure)this.procedures.get(procName);
    }

    public Map<String, FunctionMethod> getFunctions() {
        return this.functions;
    }

    public FunctionMethod getFunction(String uid) {
        return this.functions.get(uid);
    }

    public String getPrimaryMetamodelUri() {
        return this.primaryMetamodelUri;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public void setPrimaryMetamodelUri(String string) {
        this.primaryMetamodelUri = string;
    }

    public void setPhysical(boolean physical) {
        this.physical = physical;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.functions == null) {
            this.functions = new TreeMap<String, FunctionMethod>(String.CASE_INSENSITIVE_ORDER);
        }
        if (this.resolvingOrder == null) {
            this.resolvingOrder = new ArrayList<AbstractMetadataRecord>();
            this.resolvingOrder.addAll(this.tables.values());
            this.resolvingOrder.addAll(this.procedures.values());
            this.resolvingOrder.addAll(this.functions.values());
        }
    }

    public List<AbstractMetadataRecord> getResolvingOrder() {
        return this.resolvingOrder;
    }
}

