/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.LanguageFactory;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;

public class ExecutionFactory<F, C> {
    public static final int DEFAULT_MAX_FROM_GROUPS = -1;
    public static final int DEFAULT_MAX_IN_CRITERIA_SIZE = -1;
    private static final TypeFacility TYPE_FACILITY = new TypeFacility();
    private boolean immutable;
    private boolean sourceRequired = true;
    private Boolean sourceRequiredForMetadata;
    private boolean threadBound;
    private boolean supportsSelectDistinct;
    private boolean supportsOuterJoins;
    private SupportedJoinCriteria supportedJoinCriteria = SupportedJoinCriteria.ANY;
    private boolean supportsOrderBy;
    private boolean supportsInnerJoins;
    private boolean supportsFullOuterJoins;
    private boolean requiresCriteria;
    private int maxInSize = -1;
    private int maxDependentInPredicates = -1;
    private boolean copyLobs;
    private boolean supportsNativeQueries;
    private LinkedList<FunctionMethod> pushdownFunctionMethods = new LinkedList();
    private String nativeProcedureName = "native";
    private String collationLocale;

    public void start() throws TranslatorException {
    }

    @TranslatorProperty(display="Is Immutable", description="Is Immutable, True if the source never changes.", advanced=true)
    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean arg0) {
        this.immutable = arg0;
    }

    @TranslatorProperty(display="Copy LOBs", description="If true, returned LOBs will be copied, rather than streamed from the source", advanced=true)
    public boolean isCopyLobs() {
        return this.copyLobs;
    }

    public void setCopyLobs(boolean copyLobs) {
        this.copyLobs = copyLobs;
    }

    @Deprecated
    public C getConnection(F factory) throws TranslatorException {
        if (factory == null) {
            return null;
        }
        if (factory instanceof ConnectionFactory) {
            try {
                return (C)((ConnectionFactory)factory).getConnection();
            }
            catch (ResourceException e) {
                throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60000, e);
            }
        }
        throw new AssertionError((Object)(factory.getClass().getName() + " is was not a ConnectionFactory implementation"));
    }

    public C getConnection(F factory, ExecutionContext executionContext) throws TranslatorException {
        return this.getConnection(factory);
    }

    public void closeConnection(C connection, F factory) {
        if (connection == null) {
            return;
        }
        if (connection instanceof Connection) {
            try {
                ((Connection)connection).close();
            }
            catch (ResourceException e) {
                LogManager.logDetail("org.teiid.CONNECTOR", (Object)e, (Object)"Error closing");
            }
            return;
        }
        throw new AssertionError((Object)"A connection was created, but no implementation provided for closeConnection");
    }

    public boolean isSourceRequired() {
        return this.sourceRequired;
    }

    public void setSourceRequired(boolean value) {
        this.sourceRequired = value;
    }

    public boolean isSourceRequiredForMetadata() {
        if (this.sourceRequiredForMetadata == null) {
            return this.sourceRequired;
        }
        return this.sourceRequiredForMetadata;
    }

    public boolean isSourceRequiredForCapabilities() {
        return false;
    }

    public void initCapabilities(C connection) throws TranslatorException {
    }

    public void setSourceRequiredForMetadata(boolean sourceRequiredForMetadata) {
        this.sourceRequiredForMetadata = sourceRequiredForMetadata;
    }

    public LanguageFactory getLanguageFactory() {
        return LanguageFactory.INSTANCE;
    }

    public TypeFacility getTypeFacility() {
        return TYPE_FACILITY;
    }

    public Execution createExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        if (command instanceof Call) {
            Call obj = (Call)command;
            if (this.supportsDirectQueryProcedure() && obj.getMetadataObject().getName().equals(this.getDirectQueryProcedureName())) {
                List<Argument> arguments = obj.getArguments();
                return this.createDirectExecution(arguments, command, executionContext, metadata, connection);
            }
        }
        if (command instanceof QueryExpression) {
            return this.createResultSetExecution((QueryExpression)command, executionContext, metadata, connection);
        }
        if (command instanceof Call) {
            return this.createProcedureExecution((Call)command, executionContext, metadata, connection);
        }
        return this.createUpdateExecution(command, executionContext, metadata, connection);
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60001, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60001, new Object[]{"createResultSetExecution"}));
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60001, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60001, new Object[]{"createProcedureExecution"}));
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60001, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60001, new Object[]{"createUpdateExecution"}));
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60001, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60001, new Object[]{"createDirectExecution"}));
    }

    public MetadataProcessor<C> getMetadataProcessor() {
        return null;
    }

    @TranslatorProperty(display="Supports Select Distinct", description="True, if this connector supports SELECT DISTINCT", advanced=true)
    public boolean supportsSelectDistinct() {
        return this.supportsSelectDistinct;
    }

    public void setSupportsSelectDistinct(boolean supportsSelectDistinct) {
        this.supportsSelectDistinct = supportsSelectDistinct;
    }

    public boolean supportsSelectExpression() {
        return false;
    }

    public boolean supportsAliasedTable() {
        return false;
    }

    @TranslatorProperty(display="Supported Join Criteria", description="Returns one of any, theta, equi, or key", advanced=true)
    public SupportedJoinCriteria getSupportedJoinCriteria() {
        return this.supportedJoinCriteria;
    }

    public void setSupportedJoinCriteria(SupportedJoinCriteria supportedJoinCriteria) {
        this.supportedJoinCriteria = supportedJoinCriteria;
    }

    @TranslatorProperty(display="Supports Inner Joins", description="True, if this connector supports inner joins", advanced=true)
    public boolean supportsInnerJoins() {
        return this.supportsInnerJoins;
    }

    public void setSupportsInnerJoins(boolean supportsInnerJoins) {
        this.supportsInnerJoins = supportsInnerJoins;
    }

    public boolean supportsSelfJoins() {
        return false;
    }

    @TranslatorProperty(display="Supports Outer Joins", description="True, if this connector supports outer joins", advanced=true)
    public boolean supportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    public void setSupportsOuterJoins(boolean supportsOuterJoins) {
        this.supportsOuterJoins = supportsOuterJoins;
    }

    @TranslatorProperty(display="Supports Full Outer Joins", description="True, if this connector supports full outer joins", advanced=true)
    public boolean supportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    public void setSupportsFullOuterJoins(boolean supportsFullOuterJoins) {
        this.supportsFullOuterJoins = supportsFullOuterJoins;
    }

    public boolean supportsInlineViews() {
        return false;
    }

    public boolean supportsCompareCriteriaEquals() {
        return false;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return false;
    }

    public boolean supportsLikeCriteria() {
        return false;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return false;
    }

    public boolean supportsInCriteria() {
        return false;
    }

    public boolean supportsInCriteriaSubquery() {
        return false;
    }

    public boolean supportsIsNullCriteria() {
        return false;
    }

    public boolean supportsOrCriteria() {
        return false;
    }

    public boolean supportsNotCriteria() {
        return false;
    }

    public boolean supportsExistsCriteria() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    @TranslatorProperty(display="Supports ORDER BY", description="True, if this connector supports ORDER BY", advanced=true)
    public boolean supportsOrderBy() {
        return this.supportsOrderBy;
    }

    public void setSupportsOrderBy(boolean supportsOrderBy) {
        this.supportsOrderBy = supportsOrderBy;
    }

    @TranslatorProperty(display="Collation Locale", description="The collation locale used by default for sorting.", advanced=true)
    public String getCollationLocale() {
        return this.collationLocale;
    }

    public void setCollationLocale(String collation) {
        this.collationLocale = collation;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }

    public NullOrder getDefaultNullOrder() {
        return NullOrder.UNKNOWN;
    }

    public boolean supportsOrderByNullOrdering() {
        return false;
    }

    public boolean supportsGroupBy() {
        return false;
    }

    public boolean supportsOnlySingleTableGroupBy() {
        return false;
    }

    public boolean supportsHaving() {
        return false;
    }

    public boolean supportsAggregatesSum() {
        return false;
    }

    public boolean supportsAggregatesAvg() {
        return false;
    }

    public boolean supportsAggregatesMin() {
        return false;
    }

    public boolean supportsAggregatesMax() {
        return false;
    }

    public boolean supportsAggregatesCount() {
        return false;
    }

    public boolean supportsAggregatesCountStar() {
        return false;
    }

    public boolean supportsAggregatesDistinct() {
        return false;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return false;
    }

    public boolean supportsStringAgg() {
        return false;
    }

    public boolean supportsScalarSubqueries() {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    public boolean supportsSearchedCaseExpressions() {
        return false;
    }

    public boolean supportsUnions() {
        return false;
    }

    public boolean supportsSetQueryOrderBy() {
        return false;
    }

    public boolean supportsIntersect() {
        return false;
    }

    public boolean supportsExcept() {
        return false;
    }

    public List<String> getSupportedFunctions() {
        return null;
    }

    public List<FunctionMethod> getPushDownFunctions() {
        return this.pushdownFunctionMethods;
    }

    protected FunctionMethod addPushDownFunction(String qualifier, String name, String returnType, String ... paramTypes) {
        FunctionMethod method = FunctionMethod.createFunctionMethod(qualifier + '.' + name, name, qualifier, returnType, paramTypes);
        method.setNameInSource(name);
        this.pushdownFunctionMethods.add(method);
        return method;
    }

    @TranslatorProperty(display="Max number of IN predicate entries", advanced=true)
    public int getMaxInCriteriaSize() {
        return this.maxInSize;
    }

    public void setMaxInCriteriaSize(int maxInSize) {
        this.maxInSize = maxInSize;
    }

    @TranslatorProperty(display="Max number of dependent IN predicates", advanced=true)
    public int getMaxDependentInPredicates() {
        return this.maxDependentInPredicates;
    }

    public void setMaxDependentInPredicates(int maxDependentInPredicates) {
        this.maxDependentInPredicates = maxDependentInPredicates;
    }

    public boolean supportsFunctionsInGroupBy() {
        return false;
    }

    public boolean supportsRowLimit() {
        return false;
    }

    public boolean supportsRowOffset() {
        return false;
    }

    public int getMaxFromGroups() {
        return -1;
    }

    public boolean useAnsiJoin() {
        return false;
    }

    @TranslatorProperty(display="Requries Criteria", description="True, if this connector requires criteria on source queries", advanced=true)
    public boolean requiresCriteria() {
        return this.requiresCriteria;
    }

    public void setRequiresCriteria(boolean requiresCriteria) {
        this.requiresCriteria = requiresCriteria;
    }

    public boolean supportsBatchedUpdates() {
        return false;
    }

    public boolean supportsBulkUpdate() {
        return false;
    }

    public boolean supportsInsertWithQueryExpression() {
        return false;
    }

    public static <T> T getInstance(Class<T> expectedType, String className, Collection<?> ctorObjs, Class<? extends T> defaultClass) throws TranslatorException {
        try {
            if (className == null) {
                if (defaultClass == null) {
                    throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60004, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60004, new Object[0]));
                }
                return expectedType.cast(defaultClass.newInstance());
            }
            return expectedType.cast(ReflectionHelper.create((String)className, ctorObjs, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        catch (TeiidException e) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60005, e);
        }
        catch (IllegalAccessException e) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60005, e);
        }
        catch (InstantiationException e) {
            throw new TranslatorException((BundleUtil.Event)DataPlugin.Event.TEIID60005, e);
        }
    }

    public void getMetadata(MetadataFactory metadataFactory, C conn) throws TranslatorException {
        MetadataProcessor<C> mp = this.getMetadataProcessor();
        if (mp != null) {
            PropertiesUtils.setBeanProperties(mp, (Properties)metadataFactory.getModelProperties(), (String)"importer");
            mp.process(metadataFactory, conn);
        }
    }

    public boolean areLobsUsableAfterClose() {
        return false;
    }

    public boolean supportsCommonTableExpressions() {
        return false;
    }

    public boolean supportsAdvancedOlapOperations() {
        return false;
    }

    public boolean supportsElementaryOlapOperations() {
        return false;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return this.supportsElementaryOlapOperations();
    }

    public boolean supportsWindowDistinctAggregates() {
        return this.supportsElementaryOlapOperations();
    }

    public boolean supportsArrayAgg() {
        return false;
    }

    public boolean supportsSimilarTo() {
        return false;
    }

    public boolean supportsLikeRegex() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        return fromType != 14 && fromType != 16 && fromType != 17 && fromType != 15 && toType != 16 && toType != 17 && toType != 15;
    }

    public boolean supportsOnlyLiteralComparison() {
        return false;
    }

    public boolean supportsDependentJoins() {
        return false;
    }

    public boolean supportsFullDependentJoins() {
        return false;
    }

    public boolean supportsOnlyFormatLiterals() {
        return false;
    }

    public boolean supportsFormatLiteral(String literal, Format format) {
        return false;
    }

    public boolean supportsSubqueryInOn() {
        return true;
    }

    public CacheDirective getCacheDirective(Command command, ExecutionContext executionContext, RuntimeMetadata metadata) throws TranslatorException {
        return null;
    }

    public boolean isForkable() {
        return true;
    }

    @TranslatorProperty(display="Thread Bound", description="True, if this translator's executions must complete in a single thread.", advanced=true)
    public boolean isThreadBound() {
        return this.threadBound;
    }

    public boolean supportsArrayType() {
        return false;
    }

    @Deprecated
    @TranslatorProperty(display="Deprecated Property:Supports Direct Query Procedure", description="Deprecated Property, Use Supports Direct Query Procedure instead", advanced=true)
    public final boolean supportsNativeQueries() {
        return this.supportsNativeQueries;
    }

    @Deprecated
    public final void setSupportsNativeQueries(boolean state) {
        this.supportsNativeQueries = state;
    }

    @TranslatorProperty(display="Supports Direct Query Procedure", description="True, if this translator supports execution of source specific commands unaltered through a direct procedure", advanced=true)
    public boolean supportsDirectQueryProcedure() {
        return this.supportsNativeQueries;
    }

    public void setSupportsDirectQueryProcedure(boolean state) {
        this.supportsNativeQueries = state;
    }

    @Deprecated
    @TranslatorProperty(display="Deprecated Property:Direct Query Procedure Name", description="Deprecated Property, use Direct Query Procedure Name", advanced=true)
    public final String getNativeQueryProcedureName() {
        return this.nativeProcedureName;
    }

    @Deprecated
    public final void setNativeQueryProcedureName(String name) {
        this.nativeProcedureName = name;
    }

    @TranslatorProperty(display="Direct Query Procedure Name", description="The name of the direct query procedure", advanced=true)
    public String getDirectQueryProcedureName() {
        return this.nativeProcedureName;
    }

    public void setDirectQueryProcedureName(String name) {
        this.nativeProcedureName = name;
    }

    public boolean supportsOnlyCorrelatedSubqueries() {
        return false;
    }

    public boolean supportsSelectWithoutFrom() {
        return false;
    }

    public boolean supportsGroupByRollup() {
        return false;
    }

    public boolean supportsOrderByWithExtendedGrouping() {
        return this.supportsOrderBy();
    }

    public void setThreadBound(boolean threadBound) {
        this.threadBound = threadBound;
    }

    public static enum Format {
        NUMBER,
        DATE;

    }

    public static enum NullOrder {
        HIGH,
        LOW,
        FIRST,
        LAST,
        UNKNOWN;

    }

    public static enum SupportedJoinCriteria {
        ANY,
        THETA,
        EQUI,
        KEY;

    }
}

