/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;

public class TestLogManager
extends TestCase {
    private static final String CONTEXT = "SomeContext";

    public TestLogManager(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        ListLogger logger = new ListLogger();
        logger.setLogLevel(CONTEXT, 5);
        LogManager.logListener = logger;
    }

    public void testIsMessageToBeRecordedString() {
        TestLogManager.assertTrue((boolean)LogManager.isMessageToBeRecorded((String)CONTEXT, (int)1));
        ListLogger cfg = (ListLogger)LogManager.logListener;
        cfg.setLogLevel(CONTEXT, 0);
        TestLogManager.assertFalse((boolean)LogManager.isMessageToBeRecorded((String)CONTEXT, (int)1));
    }

    public void testLogMessage() throws Exception {
        ListLogger cfg = (ListLogger)LogManager.logListener;
        cfg.setLogLevel(CONTEXT, 4);
        ArrayList<String> sentMsgList = new ArrayList<String>();
        sentMsgList.add("A message 1");
        sentMsgList.add("A message 2");
        sentMsgList.add("A message 3");
        sentMsgList.add("A message 4");
        sentMsgList.add("A message 5");
        sentMsgList.add("A message 6");
        for (String msg : sentMsgList) {
            LogManager.logInfo((String)CONTEXT, (Object)msg);
        }
        List<String> recevedMsgList = cfg.getLoggedMessages();
        TestLogManager.assertEquals((int)sentMsgList.size(), (int)recevedMsgList.size());
        TestLogManager.assertEquals(sentMsgList, recevedMsgList);
    }

    class ListLogger
    implements Logger {
        private List<String> messages = new ArrayList<String>();
        private Map<String, Integer> contextMap = new HashMap<String, Integer>();
        private int defaultLevel;

        public void log(int level, String context, Object ... msg) {
            this.messages.add(msg[0].toString());
        }

        public void log(int level, String context, Throwable t, Object ... msg) {
            this.messages.add(msg[0].toString());
        }

        public void shutdown() {
            this.messages.clear();
            this.messages = null;
        }

        public int size() {
            return this.messages.size();
        }

        public List<String> getLoggedMessages() {
            return this.messages;
        }

        public Set<String> getContexts() {
            return this.contextMap.keySet();
        }

        public int getLogLevel(String context) {
            Integer level = this.contextMap.get(context);
            if (level != null) {
                return level;
            }
            return this.defaultLevel;
        }

        public void setLogLevel(String context, int logLevel) {
            this.contextMap.put(context, logLevel);
        }

        public boolean isEnabled(String context, int msgLevel) {
            int level = this.getLogLevel(context);
            return level >= msgLevel;
        }

        public void putMdc(String key, String val) {
        }

        public void removeMdc(String key) {
        }
    }
}

