/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.sql.Timestamp;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.util.StringUtil;
import org.teiid.translator.ExecutionContext;

public class CommandLogMessage {
    private boolean source;
    private Event event;
    private long timestamp;
    private String transactionID;
    private String sessionID;
    private String applicationName;
    private String principal;
    private String vdbName;
    private String vdbVersion;
    private String requestID;
    private Long sourceCommandID;
    private String sql;
    private Long rowCount;
    private String modelName;
    private String translatorName;
    private ExecutionContext executionContext;
    private PlanNode plan;
    private Object[] sourceCommand;
    private Long cpuTime;

    public CommandLogMessage(long timestamp, String requestID, String transactionID, String sessionID, String applicationName, String principal, String vdbName, String vdbVersion, String sql, Long cpuTime) {
        this(timestamp, requestID, transactionID, sessionID, principal, vdbName, vdbVersion, null, Event.NEW, null);
        this.applicationName = applicationName;
        this.sql = sql;
        this.cpuTime = cpuTime;
    }

    public CommandLogMessage(long timestamp, String requestID, String transactionID, String sessionID, String principal, String vdbName, String vdbVersion, Long finalRowCount, Event event, PlanNode plan) {
        this.event = event;
        this.timestamp = timestamp;
        this.requestID = requestID;
        this.transactionID = transactionID;
        this.sessionID = sessionID;
        this.principal = principal;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.rowCount = finalRowCount;
        this.plan = plan;
    }

    public CommandLogMessage(long timestamp, String requestID, long sourceCommandID, String transactionID, String modelName, String translatorName, String sessionID, String principal, String sql, ExecutionContext context) {
        this(timestamp, requestID, sourceCommandID, transactionID, modelName, translatorName, sessionID, principal, null, Event.NEW, context, null);
        this.sql = sql;
    }

    public CommandLogMessage(long timestamp, String requestID, long sourceCommandID, String transactionID, String modelName, String translatorName, String sessionID, String principal, Long finalRowCount, Event event, ExecutionContext context, Long cpuTime) {
        this.source = true;
        this.event = event;
        this.timestamp = timestamp;
        this.requestID = requestID;
        this.sourceCommandID = sourceCommandID;
        this.transactionID = transactionID;
        this.modelName = modelName;
        this.translatorName = translatorName;
        this.sessionID = sessionID;
        this.principal = principal;
        this.rowCount = finalRowCount;
        this.executionContext = context;
        this.cpuTime = cpuTime;
    }

    public String toString() {
        if (!this.source) {
            if (this.event == Event.NEW) {
                return "\tSTART USER COMMAND:\tstartTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\ttxID=" + this.transactionID + "\tsessionID=" + this.sessionID + "\tapplicationName=" + this.applicationName + "\tprincipal=" + this.principal + "\tvdbName=" + this.vdbName + "\tvdbVersion=" + this.vdbVersion + "\tsql=" + this.sql;
            }
            return "\t" + (Object)((Object)this.event) + " USER COMMAND:\tendTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\ttxID=" + this.transactionID + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + "\tvdbName=" + this.vdbName + "\tvdbVersion=" + this.vdbVersion + "\tfinalRowCount=" + this.rowCount + (this.plan != null ? "\tplan=" + this.plan : "") + (this.cpuTime != null ? "\tcpuTime(ns)=" + this.cpuTime : "");
        }
        if (this.event == Event.NEW) {
            return "\tSTART DATA SRC COMMAND:\tstartTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\tsourceCommandID=" + this.sourceCommandID + "\texecutionID=" + this.executionContext.getExecutionCountIdentifier() + "\ttxID=" + this.transactionID + "\tmodelName=" + this.modelName + "\ttranslatorName=" + this.translatorName + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + "\tsql=" + this.sql;
        }
        return "\t" + (Object)((Object)this.event) + " SRC COMMAND:\tendTime=" + new Timestamp(this.timestamp) + "\trequestID=" + this.requestID + "\tsourceCommandID=" + this.sourceCommandID + "\texecutionID=" + this.executionContext.getExecutionCountIdentifier() + "\ttxID=" + this.transactionID + "\tmodelName=" + this.modelName + "\ttranslatorName=" + this.translatorName + "\tsessionID=" + this.sessionID + "\tprincipal=" + this.principal + (this.sourceCommand != null ? "\tsourceCommand=" + StringUtil.toString((Object[])this.sourceCommand, (String)" ") : "") + (this.rowCount != null ? "\tfinalRowCount=" + this.rowCount : "") + (this.cpuTime != null ? "\tcpuTime(ns)=" + this.cpuTime : "");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public String getVdbVersion() {
        return this.vdbVersion;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public Long getSourceCommandID() {
        return this.sourceCommandID;
    }

    public String getSql() {
        return this.sql;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getConnectorBindingName() {
        return this.translatorName;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public Event getStatus() {
        return this.event;
    }

    public boolean isSource() {
        return this.source;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public PlanNode getPlan() {
        return this.plan;
    }

    public Long getCpuTime() {
        return this.cpuTime;
    }

    public void setSourceCommand(Object[] sourceCommand) {
        this.sourceCommand = sourceCommand;
    }

    public Object[] getSourceCommand() {
        return this.sourceCommand;
    }

    public static enum Event {
        NEW,
        PLAN,
        END,
        CANCEL,
        SOURCE,
        ERROR;

    }
}

