/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.lang.reflect.Method;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;

public class TestMetadataFactory {
    @Test
    public void testSchemaProperties() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("teiid_rel:data-ttl", "1");
        MetadataFactory mf = new MetadataFactory("x", (Object)1, Collections.EMPTY_MAP, mmd);
        Schema s = mf.getSchema();
        Assert.assertEquals((Object)"foo", (Object)s.getName());
        String val = s.getProperty("{http://www.teiid.org/ext/relational/2012}data-ttl", false);
        Assert.assertEquals((Object)"1", (Object)val);
    }

    @Test
    public void testCreateFunction() throws NoSuchMethodException, SecurityException {
        FunctionMethod fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)TestMetadataFactory.class.getMethod("someFunction", new Class[0]));
        Assert.assertEquals(Boolean.class, (Object)fm.getOutputParameter().getJavaType());
        fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)TestMetadataFactory.class.getMethod("someArrayFunction", new Class[0]));
        Assert.assertEquals(String[].class, (Object)fm.getOutputParameter().getJavaType());
    }

    @Test
    public void testCreateAggregateFunction() throws NoSuchMethodException, SecurityException {
        FunctionMethod fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)MyUDAF.class.getMethod("addInput", String.class));
        Assert.assertEquals(Boolean.class, (Object)fm.getOutputParameter().getJavaType());
        Assert.assertNotNull((Object)fm.getAggregateAttributes());
    }

    public static boolean someFunction() {
        return true;
    }

    public static String[] someArrayFunction() {
        return null;
    }

    public static class MyUDAF
    implements UserDefinedAggregate<Boolean> {
        public Boolean getResult(CommandContext commandContext) {
            return null;
        }

        public void reset() {
        }

        public void addInput(String val) {
        }
    }
}

