/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXSource;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.Streamable;
import org.teiid.util.XMLInputStream;
import org.teiid.util.XMLReader;

public class StAXSQLXML
extends SQLXMLImpl {
    private StAXSourceProvider sourceProvider;

    public StAXSQLXML(StAXSource source) {
        this(new SingleUseStAXSourceProvider(source), Streamable.CHARSET);
    }

    public StAXSQLXML(StAXSourceProvider provider, Charset charSet) {
        this.sourceProvider = provider;
        this.setCharset(charSet);
    }

    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        if (sourceClass == null || sourceClass == StAXSource.class) {
            return (T)this.sourceProvider.getStaxSource();
        }
        return (T)super.getSource(sourceClass);
    }

    public String getString() throws SQLException {
        StringWriter sw = new StringWriter();
        try {
            new StandardXMLTranslator((Source)this.getSource(StAXSource.class)).translate((Writer)sw);
        }
        catch (TransformerException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return sw.toString();
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return new XMLInputStream(this.getSource(StAXSource.class), XMLOutputFactory.newFactory(), this.getCharset().name());
        }
        catch (XMLStreamException e) {
            throw new SQLException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new SQLException(e);
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new XMLReader(this.getSource(StAXSource.class), XMLOutputFactory.newFactory());
        }
        catch (XMLStreamException e) {
            throw new SQLException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new SQLException(e);
        }
    }

    private static final class SingleUseStAXSourceProvider
    implements StAXSourceProvider {
        private StAXSource source;

        public SingleUseStAXSourceProvider(StAXSource source) {
            this.source = source;
        }

        @Override
        public StAXSource getStaxSource() throws SQLException {
            if (this.source == null) {
                throw new SQLException(DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60019, new Object[0]));
            }
            StAXSource result = this.source;
            this.source = null;
            return result;
        }
    }

    public static interface StAXSourceProvider {
        public StAXSource getStaxSource() throws SQLException;
    }
}

