/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.LanguageFactory;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;

@Translator(name="delegator", description="Translator that delegates to another translator with capability override certain methods/capabilities")
public class BaseDelegatingExecutionFactory<F, C>
extends ExecutionFactory<F, C>
implements DelegatingExecutionFactory<F, C> {
    private String delegateName;
    private ExecutionFactory<F, C> delegate;
    ExecutionFactory.NullOrder defaultNullOrder;
    Integer maxFromGroups;
    ArrayList<String> supportedFunctions;
    Boolean supportsAggregatesAvg;
    Boolean supportsAggregatesCount;
    Boolean supportsAggregatesCountStar;
    Boolean supportsAggregatesDistinct;
    Boolean supportsAggregatesEnhancedNumeric;
    Boolean supportsAggregatesMax;
    Boolean supportsAggregatesMin;
    Boolean supportsAggregatesSum;
    Boolean supportsAliasedTable;
    Boolean supportsBatchedUpdates;
    Boolean supportsBulkUpdate;
    Boolean supportsCommonTableExpressions;
    Boolean supportsCompareCriteriaEquals;
    Boolean supportsCompareCriteriaOrdered;
    Boolean supportsCorrelatedSubqueries;
    Boolean supportsExcept;
    Boolean supportsExistsCriteria;
    Boolean supportsFunctionsInGroupBy;
    Boolean supportsGroupBy;
    Boolean supportsHaving;
    Boolean supportsInCriteria;
    Boolean supportsInCriteriaSubquery;
    Boolean supportsInlineViews;
    Boolean supportsInsertWithQueryExpression;
    Boolean supportsIntersect;
    Boolean supportsIsNullCriteria;
    Boolean supportsLikeCriteria;
    Boolean supportsLikeCriteriaEscapeCharacter;
    Boolean supportsNotCriteria;
    Boolean supportsOrCriteria;
    Boolean supportsOrderByNullOrdering;
    Boolean supportsOrderByUnrelated;
    Boolean supportsQuantifiedCompareCriteriaAll;
    Boolean supportsQuantifiedCompareCriteriaSome;
    Boolean supportsRowLimit;
    Boolean supportsRowOffset;
    Boolean supportsScalarSubqueries;
    Boolean supportsSearchedCaseExpressions;
    Boolean supportsSelectExpression;
    Boolean supportsSelfJoins;
    Boolean supportsSetQueryOrderBy;
    Boolean supportsUnions;
    Boolean useAnsiJoin;
    Boolean supportsArrayAgg;
    Boolean supportsElementaryOlapOperations;
    Boolean supportsLikeRegex;
    Boolean supportsOnlyFormatLiterals;
    Boolean supportsOnlySingleTableGroupBy;
    Boolean supportsSimilarTo;
    Boolean supportsWindowDistinctAggregates;
    Boolean supportsWindowOrderByWithAggregates;
    Boolean supportsAdvancedOlapOperations;
    Boolean supportsSubqueryInOn;
    Boolean supportsDependentJoins;
    Boolean supportsOnlyLiteralComparison;
    Boolean forkable;
    Boolean supportsArrayType;
    Boolean supportsOnlyCorrelatedSubqueries;
    Boolean sourceRequiredForCapabilities;
    Boolean supportsStringAgg;
    Boolean supportsFullDependentJoins;
    Boolean supportsSelectWithoutFrom;
    Boolean supportsGroupByRollup;
    Boolean supportsOrderByWithExtendedGrouping;
    Boolean supportsRecursiveCommonTableExpressions;
    Boolean supportsCompareCriteriaOrderedExclusive;
    Boolean supportsPartialFiltering;
    Boolean useBindingsForDependentJoin;
    Boolean supportsSubqueryCommonTableExpressions;
    Boolean supportsCorrelatedSubqueryLimit;
    Character requiredLikeEscape;
    Boolean supportsScalarSubqueryProjection;
    Boolean supportsLateralJoin;
    Boolean supportsLateralJoinCondition;
    Boolean supportsProcedureTable;
    Boolean supportsGroupByMultipleDistinctAggregates;
    Boolean supportsUpsert;

    protected ExecutionFactory<F, C> getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(ExecutionFactory<F, C> delegate) {
        this.delegate = delegate;
    }

    @Override
    @TranslatorProperty(display="Delegate name", required=true)
    public String getDelegateName() {
        return this.delegateName;
    }

    public void setDelegateName(String delegateName) {
        this.delegateName = delegateName;
    }

    @Override
    public boolean areLobsUsableAfterClose() {
        return this.delegate.areLobsUsableAfterClose();
    }

    @Override
    public void closeConnection(C connection, F factory) {
        this.delegate.closeConnection(connection, factory);
    }

    @Override
    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        return (ProcedureExecution)this.delegate.createExecution(command, executionContext, metadata, connection);
    }

    @Override
    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        return (ResultSetExecution)this.delegate.createExecution(command, executionContext, metadata, connection);
    }

    @Override
    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        return (UpdateExecution)this.delegate.createExecution(command, executionContext, metadata, connection);
    }

    @Override
    public C getConnection(F factory, ExecutionContext executionContext) throws TranslatorException {
        return this.delegate.getConnection(factory, executionContext);
    }

    @Override
    @TranslatorProperty(display="Default Null Order", advanced=true)
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        if (this.defaultNullOrder != null) {
            return this.defaultNullOrder;
        }
        return this.delegate.getDefaultNullOrder();
    }

    public void setDefaultNullOrder(ExecutionFactory.NullOrder nullOrder) {
        this.defaultNullOrder = nullOrder;
    }

    @Override
    public LanguageFactory getLanguageFactory() {
        return this.delegate.getLanguageFactory();
    }

    @Override
    @TranslatorProperty(display="Max FROM Allowed", description="The number of groups supported in the from clause", advanced=true)
    public int getMaxFromGroups() {
        if (this.maxFromGroups != null) {
            return this.maxFromGroups;
        }
        return this.delegate.getMaxFromGroups();
    }

    public void setMaxFromGroups(int value) {
        this.maxFromGroups = value;
    }

    @Override
    public void getMetadata(MetadataFactory metadataFactory, C conn) throws TranslatorException {
        this.delegate.getMetadata(metadataFactory, conn);
    }

    @Override
    public List<FunctionMethod> getPushDownFunctions() {
        return this.delegate.getPushDownFunctions();
    }

    @Override
    public List<String> getSupportedFunctions() {
        if (this.supportedFunctions != null) {
            return this.supportedFunctions;
        }
        return this.delegate.getSupportedFunctions();
    }

    @TranslatorProperty(display="Add Supported Functions(CSV)", description="Add comma seperated names to system functions", advanced=true)
    public void setAddSupportedFunctions(String functionNames) {
        if (this.supportedFunctions == null) {
            this.supportedFunctions = new ArrayList();
            this.supportedFunctions.addAll(this.delegate.getSupportedFunctions());
        }
        StringTokenizer st = new StringTokenizer(functionNames, ",");
        while (st.hasMoreTokens()) {
            this.supportedFunctions.add(st.nextToken().trim());
        }
    }

    @TranslatorProperty(display="Remove Supported Functions(CSV)", description="Remove comma seperated names from system functions", advanced=true)
    public void setRemoveSupportedFunctions(String functionNames) {
        if (this.supportedFunctions == null) {
            this.supportedFunctions = new ArrayList();
            this.supportedFunctions.addAll(this.delegate.getSupportedFunctions());
        }
        StringTokenizer st = new StringTokenizer(functionNames, ",");
        while (st.hasMoreTokens()) {
            this.supportedFunctions.remove(st.nextToken().trim());
        }
    }

    @Override
    public TypeFacility getTypeFacility() {
        return this.delegate.getTypeFacility();
    }

    @Override
    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.delegate.setImmutable(value);
    }

    @Override
    @TranslatorProperty(display="Is Source Required", advanced=true)
    public boolean isSourceRequired() {
        return this.delegate.isSourceRequired();
    }

    @Override
    public void setSourceRequired(boolean value) {
        this.delegate.setSourceRequired(value);
    }

    @Override
    @TranslatorProperty(display="Supports AVG()", advanced=true)
    public boolean supportsAggregatesAvg() {
        if (this.supportsAggregatesAvg != null) {
            return this.supportsAggregatesAvg;
        }
        return this.delegate.supportsAggregatesAvg();
    }

    public void setSupportsAggregatesAvg(boolean value) {
        this.supportsAggregatesAvg = value;
    }

    @Override
    @TranslatorProperty(display="Supports COUNT()", advanced=true)
    public boolean supportsAggregatesCount() {
        if (this.supportsAggregatesCount != null) {
            return this.supportsAggregatesCount;
        }
        return this.delegate.supportsAggregatesCount();
    }

    public void setSupportsAggregatesCount(boolean value) {
        this.supportsAggregatesCount = value;
    }

    @Override
    @TranslatorProperty(display="Supports Count(*)", advanced=true)
    public boolean supportsAggregatesCountStar() {
        if (this.supportsAggregatesCountStar != null) {
            return this.supportsAggregatesCountStar;
        }
        return this.delegate.supportsAggregatesCountStar();
    }

    public void setSupportsAggregatesCountStar(boolean value) {
        this.supportsAggregatesCountStar = value;
    }

    @Override
    @TranslatorProperty(display="Supports DISTINCT", advanced=true)
    public boolean supportsAggregatesDistinct() {
        if (this.supportsAggregatesDistinct != null) {
            return this.supportsAggregatesDistinct;
        }
        return this.delegate.supportsAggregatesDistinct();
    }

    public void setSupportsAggregatesDistinct(boolean value) {
        this.supportsAggregatesDistinct = value;
    }

    @Override
    @TranslatorProperty(display="Supports Aggegate Enhanced Numeric", advanced=true)
    public boolean supportsAggregatesEnhancedNumeric() {
        if (this.supportsAggregatesEnhancedNumeric != null) {
            return this.supportsAggregatesEnhancedNumeric;
        }
        return this.delegate.supportsAggregatesEnhancedNumeric();
    }

    public void setSupportsAggregatesEnhancedNumeric(boolean value) {
        this.supportsAggregatesEnhancedNumeric = value;
    }

    @Override
    @TranslatorProperty(display="Supports MAX", advanced=true)
    public boolean supportsAggregatesMax() {
        if (this.supportsAggregatesMax != null) {
            return this.supportsAggregatesMax;
        }
        return this.delegate.supportsAggregatesMax();
    }

    public void setSupportsAggregatesMax(boolean value) {
        this.supportsAggregatesMax = value;
    }

    @Override
    @TranslatorProperty(display="Supports MIN", advanced=true)
    public boolean supportsAggregatesMin() {
        if (this.supportsAggregatesMin != null) {
            return this.supportsAggregatesMin;
        }
        return this.delegate.supportsAggregatesMin();
    }

    public void setSupportsAggregatesMin(boolean value) {
        this.supportsAggregatesMin = value;
    }

    @Override
    @TranslatorProperty(display="Supports SUM", advanced=true)
    public boolean supportsAggregatesSum() {
        if (this.supportsAggregatesSum != null) {
            return this.supportsAggregatesSum;
        }
        return this.delegate.supportsAggregatesSum();
    }

    public void setSupportsAggregatesSum(boolean value) {
        this.supportsAggregatesSum = value;
    }

    @Override
    @TranslatorProperty(display="Supports Alias (ex: as A)", advanced=true)
    public boolean supportsAliasedTable() {
        if (this.supportsAliasedTable != null) {
            return this.supportsAliasedTable;
        }
        return this.delegate.supportsAliasedTable();
    }

    public void setSupportsAliasedTable(boolean value) {
        this.supportsAliasedTable = value;
    }

    @Override
    @TranslatorProperty(display="Supports Batched Updates", advanced=true)
    public boolean supportsBatchedUpdates() {
        if (this.supportsBatchedUpdates != null) {
            return this.supportsBatchedUpdates;
        }
        return this.delegate.supportsBatchedUpdates();
    }

    public void setSupportsBatchedUpdates(boolean value) {
        this.supportsBatchedUpdates = value;
    }

    @Override
    @TranslatorProperty(display="Supports Bulk Updates", advanced=true)
    public boolean supportsBulkUpdate() {
        if (this.supportsBulkUpdate != null) {
            return this.supportsBulkUpdate;
        }
        return this.delegate.supportsBulkUpdate();
    }

    public void setSupportsBulkUpdate(boolean value) {
        this.supportsBulkUpdate = value;
    }

    @Override
    @TranslatorProperty(display="Supports Common Table Expressions", advanced=true)
    public boolean supportsCommonTableExpressions() {
        if (this.supportsCommonTableExpressions != null) {
            return this.supportsCommonTableExpressions;
        }
        return this.delegate.supportsCommonTableExpressions();
    }

    public void setSupportsCommonTableExpressions(boolean value) {
        this.supportsCommonTableExpressions = value;
    }

    @Override
    @TranslatorProperty(display="Supports Compare Criteria Equals", advanced=true)
    public boolean supportsCompareCriteriaEquals() {
        if (this.supportsCompareCriteriaEquals != null) {
            return this.supportsCompareCriteriaEquals;
        }
        return this.delegate.supportsCompareCriteriaEquals();
    }

    public void setSupportsCompareCriteriaEquals(boolean value) {
        this.supportsCompareCriteriaEquals = value;
    }

    @Override
    @TranslatorProperty(display="Supports Compare Criteria Ordered", advanced=true)
    public boolean supportsCompareCriteriaOrdered() {
        if (this.supportsCompareCriteriaOrdered != null) {
            return this.supportsCompareCriteriaOrdered;
        }
        return this.delegate.supportsCompareCriteriaOrdered();
    }

    public void setSupportsCompareCriteriaOrdered(boolean value) {
        this.supportsCompareCriteriaOrdered = value;
    }

    @Override
    @TranslatorProperty(display="Supports Correlated Subqueries", advanced=true)
    public boolean supportsCorrelatedSubqueries() {
        if (this.supportsCorrelatedSubqueries != null) {
            return this.supportsCorrelatedSubqueries;
        }
        return this.delegate.supportsCorrelatedSubqueries();
    }

    public void setSupportsCorrelatedSubqueries(boolean value) {
        this.supportsCorrelatedSubqueries = value;
    }

    @Override
    @TranslatorProperty(display="Supports EXCEPT", advanced=true)
    public boolean supportsExcept() {
        if (this.supportsExcept != null) {
            return this.supportsExcept;
        }
        return this.delegate.supportsExcept();
    }

    public void setSupportsExcept(boolean value) {
        this.supportsExcept = value;
    }

    @Override
    @TranslatorProperty(display="Supports EXISTS", advanced=true)
    public boolean supportsExistsCriteria() {
        if (this.supportsExistsCriteria != null) {
            return this.supportsExistsCriteria;
        }
        return this.delegate.supportsExistsCriteria();
    }

    public void setSupportsExistsCriteria(boolean value) {
        this.supportsExistsCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports Functions in GROUP BY", advanced=true)
    public boolean supportsFunctionsInGroupBy() {
        if (this.supportsFunctionsInGroupBy != null) {
            return this.supportsFunctionsInGroupBy;
        }
        return this.delegate.supportsFunctionsInGroupBy();
    }

    public void setSupportsFunctionsInGroupBy(boolean value) {
        this.supportsFunctionsInGroupBy = value;
    }

    @Override
    @TranslatorProperty(display="Supports GROUP BY", advanced=true)
    public boolean supportsGroupBy() {
        if (this.supportsGroupBy != null) {
            return this.supportsGroupBy;
        }
        return this.delegate.supportsGroupBy();
    }

    public void setSupportsGroupBy(boolean value) {
        this.supportsGroupBy = value;
    }

    @Override
    @TranslatorProperty(display="Supports HAVING", advanced=true)
    public boolean supportsHaving() {
        if (this.supportsHaving != null) {
            return this.supportsHaving;
        }
        return this.delegate.supportsHaving();
    }

    public void setSupportsHaving(boolean value) {
        this.supportsHaving = value;
    }

    @Override
    @TranslatorProperty(display="Supports IN", advanced=true)
    public boolean supportsInCriteria() {
        if (this.supportsInCriteria != null) {
            return this.supportsInCriteria;
        }
        return this.delegate.supportsInCriteria();
    }

    public void setSupportsInCriteria(boolean value) {
        this.supportsInCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports IN in Subquery", advanced=true)
    public boolean supportsInCriteriaSubquery() {
        if (this.supportsInCriteriaSubquery != null) {
            return this.supportsInCriteriaSubquery;
        }
        return this.delegate.supportsInCriteriaSubquery();
    }

    public void setSupportsInCriteriaSubquery(boolean value) {
        this.supportsInCriteriaSubquery = value;
    }

    @Override
    @TranslatorProperty(display="Supports Inline Views", advanced=true)
    public boolean supportsInlineViews() {
        if (this.supportsInlineViews != null) {
            return this.supportsInlineViews;
        }
        return this.delegate.supportsInlineViews();
    }

    public void setSupportsInlineViews(boolean value) {
        this.supportsInlineViews = value;
    }

    @Override
    @TranslatorProperty(display="Supports INSERT with Query Expression", advanced=true)
    public boolean supportsInsertWithQueryExpression() {
        if (this.supportsInsertWithQueryExpression != null) {
            return this.supportsInsertWithQueryExpression;
        }
        return this.delegate.supportsInsertWithQueryExpression();
    }

    public void setSupportsInsertWithQueryExpression(boolean value) {
        this.supportsInsertWithQueryExpression = value;
    }

    @Override
    @TranslatorProperty(display="Supports INTERSECT", advanced=true)
    public boolean supportsIntersect() {
        if (this.supportsIntersect != null) {
            return this.supportsIntersect;
        }
        return this.delegate.supportsIntersect();
    }

    public void setSupportsIntersect(boolean value) {
        this.supportsIntersect = value;
    }

    @Override
    @TranslatorProperty(display="Supports ISNULL", advanced=true)
    public boolean supportsIsNullCriteria() {
        if (this.supportsIsNullCriteria != null) {
            return this.supportsIsNullCriteria;
        }
        return this.delegate.supportsIsNullCriteria();
    }

    public void setSupportsIsNullCriteria(boolean value) {
        this.supportsIsNullCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports LIKE", advanced=true)
    public boolean supportsLikeCriteria() {
        if (this.supportsLikeCriteria != null) {
            return this.supportsLikeCriteria;
        }
        return this.delegate.supportsLikeCriteria();
    }

    public void setSupportsLikeCriteria(boolean value) {
        this.supportsLikeCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports Escape Char in LIKE", advanced=true)
    public boolean supportsLikeCriteriaEscapeCharacter() {
        if (this.supportsLikeCriteriaEscapeCharacter != null) {
            return this.supportsLikeCriteriaEscapeCharacter;
        }
        return this.delegate.supportsLikeCriteriaEscapeCharacter();
    }

    public void setSupportsLikeCriteriaEscapeCharacter(boolean value) {
        this.supportsLikeCriteriaEscapeCharacter = value;
    }

    @Override
    @TranslatorProperty(display="Supports NOT", advanced=true)
    public boolean supportsNotCriteria() {
        if (this.supportsNotCriteria != null) {
            return this.supportsNotCriteria;
        }
        return this.delegate.supportsNotCriteria();
    }

    public void setSupportsNotCriteria(boolean value) {
        this.supportsNotCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports OR", advanced=true)
    public boolean supportsOrCriteria() {
        if (this.supportsOrCriteria != null) {
            return this.supportsOrCriteria;
        }
        return this.delegate.supportsOrCriteria();
    }

    public void setSupportsOrCriteria(boolean value) {
        this.supportsOrCriteria = value;
    }

    @Override
    @TranslatorProperty(display="Supports ORDER BY w/Null [FIRST|LAST]", advanced=true)
    public boolean supportsOrderByNullOrdering() {
        if (this.supportsOrderByNullOrdering != null) {
            return this.supportsOrderByNullOrdering;
        }
        return this.delegate.supportsOrderByNullOrdering();
    }

    public void setSupportsOrderByNullOrdering(boolean value) {
        this.supportsOrderByNullOrdering = value;
    }

    @Override
    @TranslatorProperty(display="Supports ORDER BY Unrelated", advanced=true)
    public boolean supportsOrderByUnrelated() {
        if (this.supportsOrderByUnrelated != null) {
            return this.supportsOrderByUnrelated;
        }
        return this.delegate.supportsOrderByUnrelated();
    }

    public void setSupportsOrderByUnrelated(boolean value) {
        this.supportsOrderByUnrelated = value;
    }

    @Override
    @TranslatorProperty(display="Supports ALL", advanced=true)
    public boolean supportsQuantifiedCompareCriteriaAll() {
        if (this.supportsQuantifiedCompareCriteriaAll != null) {
            return this.supportsQuantifiedCompareCriteriaAll;
        }
        return this.delegate.supportsQuantifiedCompareCriteriaAll();
    }

    public void setSupportsQuantifiedCompareCriteriaAll(boolean value) {
        this.supportsQuantifiedCompareCriteriaAll = value;
    }

    @Override
    @TranslatorProperty(display="Supports SOME", advanced=true)
    public boolean supportsQuantifiedCompareCriteriaSome() {
        if (this.supportsQuantifiedCompareCriteriaSome != null) {
            return this.supportsQuantifiedCompareCriteriaSome;
        }
        return this.delegate.supportsQuantifiedCompareCriteriaSome();
    }

    public void setSupportsQuantifiedCompareCriteriaSome(boolean value) {
        this.supportsQuantifiedCompareCriteriaSome = value;
    }

    @Override
    @TranslatorProperty(display="Supports LIMIT", advanced=true)
    public boolean supportsRowLimit() {
        if (this.supportsRowLimit != null) {
            return this.supportsRowLimit;
        }
        return this.delegate.supportsRowLimit();
    }

    public void setSupportsRowLimit(boolean value) {
        this.supportsRowLimit = value;
    }

    @Override
    @TranslatorProperty(display="Supports LIMIT OFFSET", advanced=true)
    public boolean supportsRowOffset() {
        if (this.supportsRowOffset != null) {
            return this.supportsRowOffset;
        }
        return this.delegate.supportsRowOffset();
    }

    public void setSupportsRowOffset(boolean value) {
        this.supportsRowOffset = value;
    }

    @Override
    @TranslatorProperty(display="Supports Scalar Sub-Queries", advanced=true)
    public boolean supportsScalarSubqueries() {
        if (this.supportsScalarSubqueries != null) {
            return this.supportsScalarSubqueries;
        }
        return this.delegate.supportsScalarSubqueries();
    }

    public void setSupportsScalarSubqueries(boolean value) {
        this.supportsScalarSubqueries = value;
    }

    @Override
    @TranslatorProperty(display="Supports CASE Expression", advanced=true)
    public boolean supportsSearchedCaseExpressions() {
        if (this.supportsSearchedCaseExpressions != null) {
            return this.supportsSearchedCaseExpressions;
        }
        return this.delegate.supportsSearchedCaseExpressions();
    }

    public void setSupportsSearchedCaseExpressions(boolean value) {
        this.supportsSearchedCaseExpressions = value;
    }

    @Override
    @TranslatorProperty(display="Supports SELECT", advanced=true)
    public boolean supportsSelectExpression() {
        if (this.supportsSelectExpression != null) {
            return this.supportsSelectExpression;
        }
        return this.delegate.supportsSelectExpression();
    }

    public void setSupportsSelectExpression(boolean value) {
        this.supportsSelectExpression = value;
    }

    @Override
    @TranslatorProperty(display="Supports Self JOINS", advanced=true)
    public boolean supportsSelfJoins() {
        if (this.supportsSelfJoins != null) {
            return this.supportsSelfJoins;
        }
        return this.delegate.supportsSelfJoins();
    }

    public void setSupportsSelfJoins(boolean value) {
        this.supportsSelfJoins = value;
    }

    @Override
    @TranslatorProperty(display="Supports Set Query Orderby", advanced=true)
    public boolean supportsSetQueryOrderBy() {
        if (this.supportsSetQueryOrderBy != null) {
            return this.supportsSetQueryOrderBy;
        }
        return this.delegate.supportsSetQueryOrderBy();
    }

    public void setSupportsSetQueryOrderBy(boolean value) {
        this.supportsSetQueryOrderBy = value;
    }

    @Override
    @TranslatorProperty(display="Supports UNION", advanced=true)
    public boolean supportsUnions() {
        if (this.supportsUnions != null) {
            return this.supportsUnions;
        }
        return this.delegate.supportsUnions();
    }

    public void setSupportsUnions(boolean value) {
        this.supportsUnions = value;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    @TranslatorProperty(display="Supports ANSI Joins", advanced=true)
    public boolean useAnsiJoin() {
        if (this.useAnsiJoin != null) {
            return this.useAnsiJoin;
        }
        return this.delegate.useAnsiJoin();
    }

    public void setUseAnsiJoin(boolean value) {
        this.useAnsiJoin = value;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    @TranslatorProperty(display="Supports Copy LOBS", advanced=true)
    public boolean isCopyLobs() {
        return this.delegate.isCopyLobs();
    }

    @Override
    public void setCopyLobs(boolean value) {
        this.delegate.setCopyLobs(value);
    }

    @Override
    @TranslatorProperty(display="Supports Array Aggregation", advanced=true)
    public boolean supportsArrayAgg() {
        if (this.supportsArrayAgg != null) {
            return this.supportsArrayAgg;
        }
        return this.delegate.supportsArrayAgg();
    }

    public void setSupportsArrayAgg(boolean value) {
        this.supportsArrayAgg = value;
    }

    @Override
    @TranslatorProperty(display="Supports OLAP Operations", advanced=true)
    public boolean supportsElementaryOlapOperations() {
        if (this.supportsElementaryOlapOperations != null) {
            return this.supportsElementaryOlapOperations;
        }
        return this.delegate.supportsElementaryOlapOperations();
    }

    public void setSupportsElementaryOlapOperations(boolean value) {
        this.supportsElementaryOlapOperations = value;
    }

    @Override
    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        return this.delegate.supportsFormatLiteral(literal, format);
    }

    @Override
    @TranslatorProperty(display="Supports REGEX in LIKE", advanced=true)
    public boolean supportsLikeRegex() {
        if (this.supportsLikeRegex != null) {
            return this.supportsLikeRegex;
        }
        return this.delegate.supportsLikeRegex();
    }

    public void setSupportsLikeRegex(boolean value) {
        this.supportsLikeRegex = value;
    }

    @Override
    @TranslatorProperty(display="Supports only Format Literals", advanced=true)
    public boolean supportsOnlyFormatLiterals() {
        if (this.supportsOnlyFormatLiterals != null) {
            return this.supportsOnlyFormatLiterals;
        }
        return this.delegate.supportsOnlyFormatLiterals();
    }

    public void setSupportsOnlyFormatLiterals(boolean value) {
        this.supportsOnlyFormatLiterals = value;
    }

    @Override
    @TranslatorProperty(display="Supports Single Table GROUP BY", advanced=true)
    public boolean supportsOnlySingleTableGroupBy() {
        if (this.supportsOnlySingleTableGroupBy != null) {
            return this.supportsOnlySingleTableGroupBy;
        }
        return this.delegate.supportsOnlySingleTableGroupBy();
    }

    public void setSupportsOnlySingleTableGroupBy(boolean value) {
        this.supportsOnlySingleTableGroupBy = value;
    }

    @Override
    @TranslatorProperty(display="Supports SIMILAR TO", advanced=true)
    public boolean supportsSimilarTo() {
        if (this.supportsSimilarTo != null) {
            return this.supportsSimilarTo;
        }
        return this.delegate.supportsSimilarTo();
    }

    public void setSupportsSimilarTo(boolean value) {
        this.supportsSimilarTo = value;
    }

    @Override
    @TranslatorProperty(display="Supports Windowed Aggregates", advanced=true)
    public boolean supportsWindowDistinctAggregates() {
        if (this.supportsWindowDistinctAggregates != null) {
            return this.supportsWindowDistinctAggregates;
        }
        return this.delegate.supportsWindowDistinctAggregates();
    }

    public void setSupportsWindowDistinctAggregates(boolean value) {
        this.supportsWindowDistinctAggregates = value;
    }

    @Override
    @TranslatorProperty(display="Supports Order by With Windowed Aggregates", advanced=true)
    public boolean supportsWindowOrderByWithAggregates() {
        if (this.supportsWindowOrderByWithAggregates != null) {
            return this.supportsWindowOrderByWithAggregates;
        }
        return this.delegate.supportsWindowOrderByWithAggregates();
    }

    public void setSupportsWindowOrderByWithAggregates(boolean value) {
        this.supportsWindowOrderByWithAggregates = value;
    }

    @Override
    public int getMaxInCriteriaSize() {
        return this.delegate.getMaxInCriteriaSize();
    }

    @Override
    public void setMaxInCriteriaSize(int max) {
        this.delegate.setMaxInCriteriaSize(max);
    }

    @Override
    public ExecutionFactory.SupportedJoinCriteria getSupportedJoinCriteria() {
        return this.delegate.getSupportedJoinCriteria();
    }

    @Override
    public void setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria value) {
        this.delegate.setSupportedJoinCriteria(value);
    }

    @Override
    public boolean requiresCriteria() {
        return this.delegate.requiresCriteria();
    }

    @Override
    public void setRequiresCriteria(boolean value) {
        this.delegate.setRequiresCriteria(value);
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return this.delegate.supportsFullOuterJoins();
    }

    @Override
    public void setSupportsFullOuterJoins(boolean supportsFullOuterJoins) {
        this.delegate.setSupportsFullOuterJoins(supportsFullOuterJoins);
    }

    @Override
    public boolean supportsInnerJoins() {
        return this.delegate.supportsInnerJoins();
    }

    @Override
    public void setSupportsInnerJoins(boolean supportsInnerJoins) {
        this.delegate.setSupportsInnerJoins(supportsInnerJoins);
    }

    @Override
    public boolean supportsOrderBy() {
        return this.delegate.supportsOrderBy();
    }

    @Override
    public void setSupportsOrderBy(boolean supportsOrderBy) {
        this.delegate.setSupportsOrderBy(supportsOrderBy);
    }

    @Override
    public boolean supportsOuterJoins() {
        return this.delegate.supportsOuterJoins();
    }

    @Override
    public void setSupportsOuterJoins(boolean supportsOuterJoins) {
        this.delegate.setSupportsOuterJoins(supportsOuterJoins);
    }

    @Override
    public boolean supportsSelectDistinct() {
        return this.delegate.supportsSelectDistinct();
    }

    @Override
    public void setSupportsSelectDistinct(boolean supportsSelectDistinct) {
        this.delegate.setSupportsSelectDistinct(supportsSelectDistinct);
    }

    @Override
    public int getMaxDependentInPredicates() {
        return this.delegate.getMaxDependentInPredicates();
    }

    @Override
    public void setMaxDependentInPredicates(int maxDependentInPredicates) {
        this.delegate.setMaxDependentInPredicates(maxDependentInPredicates);
    }

    @Override
    @TranslatorProperty(display="Supports Advanced OLAP Operations", advanced=true)
    public boolean supportsAdvancedOlapOperations() {
        if (this.supportsAdvancedOlapOperations != null) {
            return this.supportsAdvancedOlapOperations;
        }
        return this.delegate.supportsAdvancedOlapOperations();
    }

    public void setSupportsAdvancedOlapOperations(boolean value) {
        this.supportsAdvancedOlapOperations = value;
    }

    @Override
    @TranslatorProperty(display="Supports Subquery In ON", advanced=true)
    public boolean supportsSubqueryInOn() {
        if (this.supportsSubqueryInOn != null) {
            return this.supportsSubqueryInOn;
        }
        return this.delegate.supportsSubqueryInOn();
    }

    public void setSupportsSubqueryInOn(boolean value) {
        this.supportsSubqueryInOn = value;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return this.delegate.supportsConvert(fromType, toType);
    }

    @Override
    @TranslatorProperty(display="Supports Dependent Joins", advanced=true)
    public boolean supportsDependentJoins() {
        if (this.supportsDependentJoins != null) {
            return this.supportsDependentJoins;
        }
        return this.delegate.supportsDependentJoins();
    }

    public void setSupportsDependentJoins(boolean value) {
        this.supportsDependentJoins = value;
    }

    @Override
    @TranslatorProperty(display="Supports Only Literal Comparision", advanced=true)
    public boolean supportsOnlyLiteralComparison() {
        if (this.supportsOnlyLiteralComparison != null) {
            return this.supportsOnlyLiteralComparison;
        }
        return this.delegate.supportsOnlyLiteralComparison();
    }

    public void setSupportsOnlyLiteralComparison(boolean value) {
        this.supportsOnlyLiteralComparison = value;
    }

    @Override
    public CacheDirective getCacheDirective(Command command, ExecutionContext executionContext, RuntimeMetadata metadata) throws TranslatorException {
        return this.delegate.getCacheDirective(command, executionContext, metadata);
    }

    @Override
    @TranslatorProperty(display="Is Source Required For Metadata", advanced=true)
    public boolean isSourceRequiredForMetadata() {
        return this.delegate.isSourceRequiredForMetadata();
    }

    @Override
    public void setSourceRequiredForMetadata(boolean value) {
        this.delegate.setSourceRequiredForMetadata(value);
    }

    @Override
    @TranslatorProperty(display="Is Forkable", description="When forkable the engine may use a separate thread to interact with returned Exection", advanced=true)
    public boolean isForkable() {
        if (this.forkable != null) {
            return this.forkable;
        }
        return this.delegate.isForkable();
    }

    public void setForkable(boolean value) {
        this.forkable = value;
    }

    @Override
    @TranslatorProperty(display="Supports Array Type", advanced=true)
    public boolean supportsArrayType() {
        if (this.supportsArrayType != null) {
            return this.supportsArrayType;
        }
        return this.delegate.supportsArrayType();
    }

    public void setSupportsArrayType(boolean value) {
        this.supportsArrayType = value;
    }

    @Override
    @TranslatorProperty(display="Direct Query Procedure Name", advanced=true)
    public String getDirectQueryProcedureName() {
        return this.delegate.getDirectQueryProcedureName();
    }

    @Override
    public void setDirectQueryProcedureName(String name) {
        this.delegate.setDirectQueryProcedureName(name);
    }

    @Override
    public boolean supportsDirectQueryProcedure() {
        return this.delegate.supportsDirectQueryProcedure();
    }

    @Override
    public void setSupportsDirectQueryProcedure(boolean value) {
        this.delegate.setSupportsDirectQueryProcedure(value);
    }

    @Override
    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        return this.delegate.createDirectExecution(arguments, command, executionContext, metadata, connection);
    }

    @Override
    @TranslatorProperty(display="Supports Correlated Sub Queries", advanced=true)
    public boolean supportsOnlyCorrelatedSubqueries() {
        if (this.supportsOnlyCorrelatedSubqueries != null) {
            return this.supportsOnlyCorrelatedSubqueries;
        }
        return this.delegate.supportsOnlyCorrelatedSubqueries();
    }

    public void setSupportsOnlyCorrelatedSubqueries(boolean value) {
        this.supportsOnlyCorrelatedSubqueries = value;
    }

    @Override
    @TranslatorProperty(display="Source required for Capabilities", advanced=true)
    public boolean isSourceRequiredForCapabilities() {
        if (this.sourceRequiredForCapabilities != null) {
            return this.sourceRequiredForCapabilities;
        }
        return this.delegate.isSourceRequiredForCapabilities();
    }

    public void setSourceRequiredForCapabilities(boolean value) {
        this.sourceRequiredForCapabilities = value;
    }

    @Override
    public void initCapabilities(C connection) throws TranslatorException {
        this.delegate.initCapabilities(connection);
    }

    @Override
    @TranslatorProperty(display="Supports STRING_AGG", advanced=true)
    public boolean supportsStringAgg() {
        if (this.supportsStringAgg != null) {
            return this.supportsStringAgg;
        }
        return this.delegate.supportsStringAgg();
    }

    public void setSupportsStringAgg(boolean value) {
        this.supportsStringAgg = value;
    }

    @Override
    @TranslatorProperty(display="Supports Full Dependent Joins", advanced=true)
    public boolean supportsFullDependentJoins() {
        if (this.supportsFullDependentJoins != null) {
            return this.supportsFullDependentJoins;
        }
        return this.delegate.supportsFullDependentJoins();
    }

    public void setSupportsFullDependentJoins(boolean value) {
        this.supportsFullDependentJoins = value;
    }

    @Override
    @TranslatorProperty(display="Supports SELECT w/o FROM", advanced=true)
    public boolean supportsSelectWithoutFrom() {
        if (this.supportsSelectWithoutFrom != null) {
            return this.supportsSelectWithoutFrom;
        }
        return this.delegate.supportsSelectWithoutFrom();
    }

    public void setSupportsSelectWithoutFrom(boolean value) {
        this.supportsSelectWithoutFrom = value;
    }

    @Override
    @TranslatorProperty(display="Supports GROUP BY ROLLUP", advanced=true)
    public boolean supportsGroupByRollup() {
        if (this.supportsGroupByRollup != null) {
            return this.supportsGroupByRollup;
        }
        return this.delegate.supportsGroupByRollup();
    }

    public void setSupportsGroupByRollup(boolean value) {
        this.supportsGroupByRollup = value;
    }

    @Override
    @TranslatorProperty(display="Supports Orderby w/extended grouping", advanced=true)
    public boolean supportsOrderByWithExtendedGrouping() {
        if (this.supportsOrderByWithExtendedGrouping != null) {
            return this.supportsOrderByWithExtendedGrouping;
        }
        return this.delegate.supportsOrderByWithExtendedGrouping();
    }

    public void setSupportsOrderByWithExtendedGrouping(boolean value) {
        this.supportsOrderByWithExtendedGrouping = value;
    }

    @Override
    public boolean isThreadBound() {
        return this.delegate.isThreadBound();
    }

    @Override
    public void setThreadBound(boolean value) {
        this.delegate.setThreadBound(value);
    }

    @Override
    public String getCollationLocale() {
        return this.delegate.getCollationLocale();
    }

    @Override
    public void setCollationLocale(String value) {
        this.delegate.setCollationLocale(value);
    }

    @Override
    @TranslatorProperty(display="Supports Recursive Common Table Expresions", advanced=true)
    public boolean supportsRecursiveCommonTableExpressions() {
        if (this.supportsRecursiveCommonTableExpressions != null) {
            return this.supportsRecursiveCommonTableExpressions;
        }
        return this.delegate.supportsRecursiveCommonTableExpressions();
    }

    public void setSupportsRecursiveCommonTableExpressions(boolean value) {
        this.supportsRecursiveCommonTableExpressions = value;
    }

    @Override
    @TranslatorProperty(display="Supports Criteria Ordered Exclusive", advanced=true)
    public boolean supportsCompareCriteriaOrderedExclusive() {
        if (this.supportsCompareCriteriaOrderedExclusive != null) {
            return this.supportsCompareCriteriaOrderedExclusive;
        }
        return this.delegate.supportsCompareCriteriaOrderedExclusive();
    }

    public void supportsCompareCriteriaOrderedExclusive(boolean value) {
        this.supportsCompareCriteriaOrderedExclusive = value;
    }

    @Override
    public boolean returnsSingleUpdateCount() {
        return this.delegate.returnsSingleUpdateCount();
    }

    @Override
    @TranslatorProperty(display="Supports Partial Filtering", advanced=true)
    public boolean supportsPartialFiltering() {
        if (this.supportsPartialFiltering != null) {
            return this.supportsPartialFiltering;
        }
        return this.delegate.supportsPartialFiltering();
    }

    public void setSupportsPartialFiltering(boolean value) {
        this.supportsPartialFiltering = value;
    }

    @Override
    @TranslatorProperty(display="Use Bindings for Dependent Joins", advanced=true)
    public boolean useBindingsForDependentJoin() {
        if (this.useBindingsForDependentJoin != null) {
            return this.useBindingsForDependentJoin;
        }
        return this.delegate.useBindingsForDependentJoin();
    }

    public void setUseBindingsForDependentJoin(boolean value) {
        this.useBindingsForDependentJoin = value;
    }

    @Override
    @TranslatorProperty(display="Supports Subquery Common Table Expressions", advanced=true)
    public boolean supportsSubqueryCommonTableExpressions() {
        if (this.supportsSubqueryCommonTableExpressions != null) {
            return this.supportsSubqueryCommonTableExpressions;
        }
        return this.delegate.supportsSubqueryCommonTableExpressions();
    }

    public void setSupportsSubqueryCommonTableExpressions(boolean value) {
        this.supportsSubqueryCommonTableExpressions = value;
    }

    @Override
    @TranslatorProperty(display="Supports Correlated Subquery Limit", advanced=true)
    public boolean supportsCorrelatedSubqueryLimit() {
        if (this.supportsCorrelatedSubqueryLimit != null) {
            return this.supportsCorrelatedSubqueryLimit;
        }
        return this.delegate.supportsCorrelatedSubqueryLimit();
    }

    public void setSupportsCorrelatedSubqueryLimit(boolean value) {
        this.supportsCorrelatedSubqueryLimit = value;
    }

    @Override
    @TranslatorProperty(display="Escape char for LIKE", advanced=true)
    public Character getRequiredLikeEscape() {
        if (this.requiredLikeEscape != null) {
            return this.requiredLikeEscape;
        }
        return this.delegate.getRequiredLikeEscape();
    }

    public void setRequiredLikeEscape(Character c) {
        this.requiredLikeEscape = c;
    }

    @Override
    @TranslatorProperty(display="Supports Scalar SubQuery in SELECT", advanced=true)
    public boolean supportsScalarSubqueryProjection() {
        if (this.supportsScalarSubqueryProjection != null) {
            return this.supportsScalarSubqueryProjection;
        }
        return this.delegate.supportsScalarSubqueryProjection();
    }

    public void setSupportsScalarSubqueryProjection(boolean value) {
        this.supportsScalarSubqueryProjection = value;
    }

    @Override
    public ExecutionFactory.TransactionSupport getTransactionSupport() {
        return this.delegate.getTransactionSupport();
    }

    @Override
    public void setTransactionSupport(ExecutionFactory.TransactionSupport transactionSupport) {
        this.delegate.setTransactionSupport(transactionSupport);
    }

    @Override
    @TranslatorProperty(display="Excluded Common Table Expression Name", advanced=true)
    public String getExcludedCommonTableExpressionName() {
        return this.delegate.getExcludedCommonTableExpressionName();
    }

    @Override
    public void setExcludedCommonTableExpressionName(String value) {
        this.delegate.setExcludedCommonTableExpressionName(value);
    }

    @Override
    @TranslatorProperty(display="Supports Lateral Join", advanced=true)
    public boolean supportsLateralJoin() {
        if (this.supportsLateralJoin != null) {
            return this.supportsLateralJoin;
        }
        return this.delegate.supportsLateralJoin();
    }

    public void setSupportsLateralJoin(boolean value) {
        this.supportsLateralJoin = value;
    }

    @Override
    @TranslatorProperty(display="Supports Lateral Join Condition", advanced=true)
    public boolean supportsLateralJoinCondition() {
        if (this.supportsLateralJoinCondition != null) {
            return this.supportsLateralJoinCondition;
        }
        return this.delegate.supportsLateralJoinCondition();
    }

    public void setSupportsLateralJoinCondition(boolean value) {
        this.supportsLateralJoinCondition = value;
    }

    @Override
    @TranslatorProperty(display="Supports Procedure Table", advanced=true)
    public boolean supportsProcedureTable() {
        if (this.supportsProcedureTable != null) {
            return this.supportsProcedureTable;
        }
        return this.delegate.supportsProcedureTable();
    }

    public void setSupportsProcedureTable(boolean value) {
        this.supportsProcedureTable = value;
    }

    @Override
    @TranslatorProperty(display="Supports GROUP By with Multiple DISTINCTS", advanced=true)
    public boolean supportsGroupByMultipleDistinctAggregates() {
        if (this.supportsGroupByMultipleDistinctAggregates != null) {
            return this.supportsGroupByMultipleDistinctAggregates;
        }
        return this.delegate.supportsGroupByMultipleDistinctAggregates();
    }

    public void setSupportsGroupByMultipleDistinctAggregates(boolean value) {
        this.supportsGroupByMultipleDistinctAggregates = value;
    }

    @Override
    public void start() throws TranslatorException {
    }

    @Override
    @TranslatorProperty(display="Supports Upsert", advanced=true)
    public boolean supportsUpsert() {
        if (this.supportsUpsert != null) {
            return this.supportsUpsert;
        }
        return this.delegate.supportsGroupByMultipleDistinctAggregates();
    }

    public void setSupportsUpsert(boolean value) {
        this.supportsUpsert = value;
    }
}

