/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.Logger;

public class JavaLogger
implements Logger {
    private static ConcurrentHashMap<String, java.util.logging.Logger> loggers = new ConcurrentHashMap();

    @Override
    public boolean isEnabled(String context, int msgLevel) {
        java.util.logging.Logger logger = this.getLogger(context);
        Level javaLevel = this.convertLevel(msgLevel);
        return logger.isLoggable(javaLevel);
    }

    private java.util.logging.Logger getLogger(String context) {
        java.util.logging.Logger logger = loggers.get(context);
        if (logger == null) {
            logger = java.util.logging.Logger.getLogger(context);
            loggers.put(context, logger);
        }
        return logger;
    }

    @Override
    public void log(int level, String context, Object ... msg) {
        this.log(level, context, null, msg);
    }

    @Override
    public void log(int level, String context, Throwable t, Object ... msg) {
        java.util.logging.Logger logger = this.getLogger(context);
        Level javaLevel = this.convertLevel(level);
        if (msg.length == 0) {
            logger.log(javaLevel, null, t);
        } else if (msg.length == 1 && !(msg[0] instanceof String)) {
            String msgStr = StringUtil.toString((Object[])msg, (String)" ", (boolean)false);
            LogRecord record = new LogRecord(javaLevel, msgStr);
            record.setParameters(msg);
            record.setThrown(t);
            record.setLoggerName(context);
            logger.log(record);
        } else {
            logger.log(javaLevel, StringUtil.toString((Object[])msg, (String)" ", (boolean)false), t);
        }
    }

    public Level convertLevel(int level) {
        switch (level) {
            case 1: 
            case 2: {
                return Level.SEVERE;
            }
            case 3: {
                return Level.WARNING;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINER;
            }
            case 6: {
                return Level.FINEST;
            }
        }
        return Level.ALL;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void putMdc(String key, String val) {
    }

    @Override
    public void removeMdc(String key) {
    }
}

