/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Database;

public class Grant
extends AbstractMetadataRecord {
    private static final long serialVersionUID = 3728259393244582775L;
    protected List<Permission> permissions = new ArrayList<Permission>();
    private String role;

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    void removePermission(Permission permission) {
        this.permissions.remove(permission);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public static class Permission {
        private Database.ResourceType resourceType = null;
        private String resource = null;
        private String mask = null;
        private Integer maskOrder;
        private String condition = null;
        private Boolean isConstraint;
        private EnumSet<Privilege> privileges = EnumSet.noneOf(Privilege.class);

        public Database.ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(Database.ResourceType on) {
            this.resourceType = on;
        }

        public String getResourceName() {
            return this.resource;
        }

        public void setResourceName(String resource) {
            this.resource = resource;
        }

        public String getMask() {
            return this.mask;
        }

        public void setMask(String mask) {
            this.mask = mask;
        }

        public Integer getMaskOrder() {
            return this.maskOrder;
        }

        public void setMaskOrder(Integer maskOrder) {
            this.maskOrder = maskOrder;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition, Boolean isConstraint) {
            this.condition = condition;
            this.isConstraint = isConstraint;
        }

        public Boolean isConditionAConstraint() {
            return this.isConstraint;
        }

        public EnumSet<Privilege> getPrivileges() {
            return this.privileges;
        }

        public boolean hasPrivilege(Privilege allow) {
            return this.privileges.contains((Object)allow);
        }

        public void setPrivileges(List<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            this.privileges = EnumSet.copyOf(types);
        }

        public void appendPrivileges(EnumSet<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            for (Privilege a : types) {
                this.privileges.add(a);
            }
        }

        public void removePrivileges(EnumSet<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            for (Privilege a : types) {
                this.privileges.remove((Object)a);
            }
        }

        private void setAllows(Boolean allow, Privilege privilege) {
            if (allow != null) {
                if (allow.booleanValue()) {
                    this.privileges.add(privilege);
                } else {
                    this.privileges.remove((Object)privilege);
                }
            }
        }

        public void setAllowSelect(Boolean allow) {
            this.setAllows(allow, Privilege.SELECT);
        }

        public void setAllowAlter(Boolean allow) {
            this.setAllows(allow, Privilege.ALTER);
        }

        public void setAllowInsert(Boolean allow) {
            this.setAllows(allow, Privilege.INSERT);
        }

        public void setAllowDelete(Boolean allow) {
            this.setAllows(allow, Privilege.DELETE);
        }

        public void setAllowExecute(Boolean allow) {
            this.setAllows(allow, Privilege.EXECUTE);
        }

        public void setAllowUpdate(Boolean allow) {
            this.setAllows(allow, Privilege.UPDATE);
        }

        public void setAllowDrop(Boolean allow) {
            this.setAllows(allow, Privilege.DROP);
        }

        public void setAllowLanguage(Boolean allow) {
            this.setAllows(allow, Privilege.LANGUAGE);
        }

        public void setAllowAllPrivileges(Boolean allow) {
            this.setAllows(allow, Privilege.ALL_PRIVILEGES);
        }

        public void setAllowTemporyTables(Boolean allow) {
            this.setAllows(allow, Privilege.TEMPORARY_TABLE);
        }

        public static enum Privilege {
            SELECT,
            INSERT,
            UPDATE,
            DELETE,
            EXECUTE,
            LANGUAGE,
            ALTER,
            DROP,
            ALL_PRIVILEGES,
            TEMPORARY_TABLE,
            CREATE;

        }
    }
}

