/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Grant;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;

public class MetadataStore
implements Serializable {
    private static final long serialVersionUID = -3130247626435324312L;
    protected NavigableMap<String, Schema> schemas = new TreeMap<String, Schema>(String.CASE_INSENSITIVE_ORDER);
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected NavigableMap<String, Datatype> datatypes = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Grant> grants = new TreeMap<String, Grant>(String.CASE_INSENSITIVE_ORDER);
    protected LinkedHashMap<String, Role> roles = new LinkedHashMap();

    public NavigableMap<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        return (Schema)this.schemas.get(name);
    }

    public void addSchema(Schema schema) {
        if (this.schemas.put(schema.getName(), schema) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60012, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60012, new Object[]{schema.getName()}));
        }
        this.schemaList.add(schema);
    }

    public List<Schema> getSchemaList() {
        return this.schemaList;
    }

    public Schema removeSchema(String schemaName) {
        Schema s = (Schema)this.schemas.remove(schemaName);
        if (s != null) {
            this.schemaList.remove(s);
        }
        return s;
    }

    public void addDataTypes(Collection<Datatype> types) {
        if (types != null) {
            for (Datatype type : types) {
                this.addDatatype(type);
            }
        }
    }

    public void addDatatype(Datatype datatype) {
        if (!this.datatypes.containsKey(datatype.getName())) {
            this.datatypes.put(datatype.getName(), datatype);
        }
    }

    public NavigableMap<String, Datatype> getDatatypes() {
        return this.datatypes;
    }

    public void merge(MetadataStore store) {
        if (store != null) {
            for (Schema s : store.getSchemaList()) {
                this.addSchema(s);
            }
            this.addDataTypes(store.getDatatypes().values());
            this.addGrants(store.grants.values());
        }
    }

    void addGrants(Collection<Grant> grants) {
        if (grants == null) {
            return;
        }
        for (Grant g : grants) {
            this.addGrant(g);
        }
    }

    public void addGrant(Grant grant) {
        if (grant == null) {
            return;
        }
        Grant previous = this.grants.get(grant.getRole());
        if (previous == null) {
            this.grants.put(grant.getRole(), grant);
        } else {
            for (Grant.Permission newP : grant.getPermissions()) {
                boolean found = false;
                for (Grant.Permission oldP : previous.getPermissions()) {
                    if (!oldP.getResourceName().equalsIgnoreCase(newP.getResourceName()) || oldP.getResourceType() != newP.getResourceType()) continue;
                    oldP.appendPrivileges(newP.getPrivileges());
                    found = true;
                }
                if (found) continue;
                previous.addPermission(newP);
            }
        }
    }

    public void removeGrant(Grant toRemoveGrant) {
        if (toRemoveGrant == null) {
            return;
        }
        Grant previous = this.grants.get(toRemoveGrant.getRole());
        if (previous != null) {
            for (Grant.Permission removePermission : toRemoveGrant.getPermissions()) {
                ArrayList<Grant.Permission> emptyPermissions = new ArrayList<Grant.Permission>();
                for (Grant.Permission currentPermission : previous.getPermissions()) {
                    if (currentPermission.getResourceName().equalsIgnoreCase(removePermission.getResourceName()) && currentPermission.getResourceType() == removePermission.getResourceType()) {
                        boolean all = removePermission.getPrivileges().contains((Object)Grant.Permission.Privilege.ALL_PRIVILEGES);
                        if (all) {
                            currentPermission.removePrivileges(currentPermission.getPrivileges());
                        } else {
                            currentPermission.removePrivileges(removePermission.getPrivileges());
                        }
                    }
                    if (!currentPermission.getPrivileges().isEmpty()) continue;
                    emptyPermissions.add(currentPermission);
                }
                for (Grant.Permission p : emptyPermissions) {
                    previous.removePermission(p);
                }
            }
            if (previous.getPermissions().isEmpty()) {
                this.grants.remove(toRemoveGrant.getRole());
            }
        }
    }

    public Collection<Grant> getGrants() {
        return this.grants.values();
    }

    public void addRole(Role role) {
        this.roles.put(role.getName(), role);
    }

    public Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Role removeRole(String roleName) {
        return (Role)this.roles.remove(roleName);
    }
}

