/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;

public class NamespaceContainer
extends AbstractMetadataRecord {
    static final String TEIID_RESERVED = "teiid_";
    private static final String TEIID_SF = "teiid_sf";
    private static final String TEIID_RELATIONAL = "teiid_rel";
    private static final String TEIID_WS = "teiid_ws";
    private static final String TEIID_MONGO = "teiid_mongo";
    private static final String TEIID_ODATA = "teiid_odata";
    private static final String TEIID_ACCUMULO = "teiid_accumulo";
    private static final String TEIID_EXCEL = "teiid_excel";
    private static final String TEIID_JPA = "teiid_jpa";
    private static final String TEIID_HBASE = "teiid_hbase";
    private static final String TEIID_SPATIAL = "teiid_spatial";
    private static final String TEIID_LDAP = "teiid_ldap";
    private static final String TEIID_REST = "teiid_rest";
    private static final String TEIID_PI = "teiid_pi";
    private static final String TEIID_COUCHBASE = "teiid_couchbase";
    private static final String TEIID_INFINISPAN = "teiid_ispn";
    public static final String SF_URI = "{http://www.teiid.org/translator/salesforce/2012}";
    public static final String WS_URI = "{http://www.teiid.org/translator/ws/2012}";
    public static final String MONGO_URI = "{http://www.teiid.org/translator/mongodb/2013}";
    public static final String ODATA_URI = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}";
    public static final String ACCUMULO_URI = "{http://www.teiid.org/translator/accumulo/2013}";
    public static final String EXCEL_URI = "{http://www.teiid.org/translator/excel/2014}";
    public static final String JPA_URI = "{http://www.teiid.org/translator/jpa/2014}";
    public static final String HBASE_URI = "{http://www.teiid.org/translator/hbase/2014}";
    public static final String SPATIAL_URI = "{http://www.teiid.org/translator/spatial/2015}";
    public static final String LDAP_URI = "{http://www.teiid.org/translator/ldap/2015}";
    public static final String REST_URI = "{http://teiid.org/rest}";
    public static final String PI_URI = "{http://www.teiid.org/translator/pi/2016}";
    public static final String COUCHBASE_URI = "{http://www.teiid.org/translator/couchbase/2017}";
    public static final String INFINISPAN_URI = "{http://www.teiid.org/translator/infinispan/2017}";
    public static final Map<String, String> BUILTIN_NAMESPACES;
    protected Map<String, String> namespaces;

    public void addNamespace(String prefix, String uri) {
        String old;
        String validURI;
        if (uri == null || uri.indexOf(125) != -1) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60018, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60018, new Object[]{uri}));
        }
        if (StringUtil.startsWithIgnoreCase((String)prefix, (String)TEIID_RESERVED) && ((validURI = (String)MetadataFactory.BUILTIN_NAMESPACES.get(prefix)) == null || !uri.equals(validURI))) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60017, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60017, new Object[]{prefix}));
        }
        if (this.namespaces == null) {
            this.namespaces = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if ((old = this.namespaces.put(prefix, uri)) != null && !old.equals(uri)) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60037, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60037, new Object[]{prefix, old, uri}));
        }
    }

    public Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptyMap();
        }
        return this.namespaces;
    }

    public static String resolvePropertyKey(NamespaceContainer baseSchema, String key) {
        int index = key.indexOf(58);
        if (index > 0 && index < key.length() - 1) {
            String prefix = key.substring(0, index);
            String uri = BUILTIN_NAMESPACES.get(prefix);
            if (uri == null && baseSchema != null) {
                uri = baseSchema.getNamespaces().get(prefix);
            }
            if (uri != null) {
                key = '{' + uri + '}' + key.substring(index + 1, key.length());
            }
        }
        return key;
    }

    static {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        map.put(TEIID_RELATIONAL, "{http://www.teiid.org/ext/relational/2012}".substring(1, "{http://www.teiid.org/ext/relational/2012}".length() - 1));
        map.put(TEIID_SF, SF_URI.substring(1, SF_URI.length() - 1));
        map.put(TEIID_WS, WS_URI.substring(1, WS_URI.length() - 1));
        map.put(TEIID_MONGO, MONGO_URI.substring(1, MONGO_URI.length() - 1));
        map.put(TEIID_ODATA, ODATA_URI.substring(1, ODATA_URI.length() - 1));
        map.put(TEIID_ACCUMULO, ACCUMULO_URI.substring(1, ACCUMULO_URI.length() - 1));
        map.put(TEIID_EXCEL, EXCEL_URI.substring(1, EXCEL_URI.length() - 1));
        map.put(TEIID_JPA, JPA_URI.substring(1, JPA_URI.length() - 1));
        map.put(TEIID_HBASE, HBASE_URI.substring(1, HBASE_URI.length() - 1));
        map.put(TEIID_SPATIAL, SPATIAL_URI.substring(1, SPATIAL_URI.length() - 1));
        map.put(TEIID_LDAP, LDAP_URI.substring(1, LDAP_URI.length() - 1));
        map.put(TEIID_REST, REST_URI.substring(1, REST_URI.length() - 1));
        map.put(TEIID_PI, PI_URI.substring(1, PI_URI.length() - 1));
        map.put(TEIID_COUCHBASE, COUCHBASE_URI.substring(1, COUCHBASE_URI.length() - 1));
        map.put(TEIID_INFINISPAN, INFINISPAN_URI.substring(1, INFINISPAN_URI.length() - 1));
        BUILTIN_NAMESPACES = Collections.unmodifiableMap(map);
    }
}

