/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.Table;

public class TestTable {
    @Test
    public void testCardinality() {
        Table t = new Table();
        Assert.assertEquals((float)-1.0f, (float)t.getCardinalityAsFloat(), (float)0.0f);
        t.setCardinality(1000);
        Assert.assertEquals((float)1000.0f, (float)t.getCardinalityAsFloat(), (float)0.0f);
        t.setCardinality(100000111000111100L);
        Assert.assertEquals((double)(1.0000011E17f / t.getCardinalityAsFloat()), (double)1.0, (double)0.01);
    }

    @Test
    public void testColumnPrecisionScale() {
        Column c = new Column();
        Datatype datatype = new Datatype();
        datatype.setName("bigdecimal");
        c.setDatatype(datatype);
        c.setPrecision(0);
        c.setScale(2);
        Assert.assertEquals((long)2L, (long)c.getScale());
        Assert.assertEquals((long)32767L, (long)c.getPrecision());
    }
}

