/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import javax.resource.cci.Connection;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;

public interface WSConnection
extends Connection {
    public static final String STATUS_CODE = "status-code";

    public <T> Dispatch<T> createDispatch(String var1, String var2, Class<T> var3, Service.Mode var4);

    public <T> Dispatch<T> createDispatch(Class<T> var1, Service.Mode var2) throws IOException;

    public URL getWsdl();

    public QName getServiceQName();

    public QName getPortQName();

    public String getStatusMessage(int var1);

    public static class Util {
        public static String appendQueryString(String endpoint, String param) {
            return endpoint + (endpoint.indexOf(63) >= 0 ? (char)'&' : '?') + param;
        }

        public static String httpURLEncode(String s) {
            try {
                return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public static void closeSource(Source source) {
            if (!(source instanceof StreamSource)) {
                return;
            }
            StreamSource stream = (StreamSource)source;
            try {
                if (stream.getInputStream() != null) {
                    stream.getInputStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (stream.getReader() != null) {
                    stream.getReader().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

