/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cache.jboss;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheConfiguration;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.jboss.JBossCache;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.jmx.CacheJmxWrapper;

@Singleton
public class JBossCacheFactory
implements CacheFactory {
    private org.jboss.cache.Cache cacheStore;
    private volatile boolean destroyed = false;
    private ObjectName jmxName;

    @Inject
    public JBossCacheFactory(org.jboss.cache.Cache cacheStore) {
        try {
            CacheJmxWrapper wrapper = new CacheJmxWrapper(cacheStore);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.jmxName = new ObjectName("Teiid:service=JBossCache,name=cache");
            mbs.registerMBean(wrapper, this.jmxName);
            wrapper.create();
            wrapper.start();
            this.cacheStore = wrapper.getCache();
        }
        catch (OperationsException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    public Cache get(Cache.Type type, CacheConfiguration config) {
        if (!this.destroyed) {
            Node cacheRoot = this.cacheStore.getRoot().addChild(Fqn.fromString((String)"Teiid"));
            Node node = cacheRoot.addChild(Fqn.fromString((String)type.location()));
            Region cacheRegion = this.cacheStore.getRegion(node.getFqn(), true);
            cacheRegion.setEvictionPolicy(this.buildEvictionPolicy(config));
            return new JBossCache(this.cacheStore, node.getFqn());
        }
        throw new MetaMatrixRuntimeException("Cache system has been shutdown");
    }

    private EvictionPolicyConfig buildEvictionPolicy(CacheConfiguration config) {
        MRUConfiguration evictionConfig = null;
        if (config.getPolicy() == CacheConfiguration.Policy.LRU) {
            LRUConfiguration lru = new LRUConfiguration();
            lru.setMaxNodes(config.getMaxNodes());
            lru.setMaxAgeSeconds(config.getMaxAgeInSeconds());
            lru.setTimeToLiveSeconds(0);
            evictionConfig = lru;
        } else if (config.getPolicy() == CacheConfiguration.Policy.MRU) {
            MRUConfiguration mru = new MRUConfiguration();
            mru.setMaxNodes(config.getMaxNodes());
            evictionConfig = mru;
        } else if (config.getPolicy() == CacheConfiguration.Policy.FIFO) {
            FIFOConfiguration fifo = new FIFOConfiguration();
            fifo.setMaxNodes(config.getMaxNodes());
            evictionConfig = fifo;
        } else if (config.getPolicy() == CacheConfiguration.Policy.LFU) {
            LFUConfiguration lfu = new LFUConfiguration();
            lfu.setMaxNodes(config.getMaxNodes());
            evictionConfig = lfu;
        }
        return evictionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(this.jmxName);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
        }
        finally {
            this.cacheStore.destroy();
            this.destroyed = true;
        }
    }
}

