/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.events.jboss;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.util.naming.Util;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.teiid.events.EventDistributor;

public class JGroupsEventDistributor
extends ReceiverAdapter
implements Serializable {
    private static final long serialVersionUID = -1140683411842561358L;
    private transient JChannelFactory channelFactory;
    private String multiplexerStack;
    private String clusterName;
    private String jndiName;
    private String localEventDistributorName;
    private transient EventDistributor proxyEventDistributor;
    private transient EventDistributor localEventDistributor;
    private transient Channel channel;
    private transient RpcDispatcher rpcDispatcher;
    private transient Vector<Address> members;

    public JChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getLocalEventDistributorName() {
        return this.localEventDistributorName;
    }

    public void setLocalEventDistributorName(String localEventDistributorName) {
        this.localEventDistributorName = localEventDistributorName;
    }

    public String getMultiplexerStack() {
        return this.multiplexerStack;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setChannelFactory(JChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMultiplexerStack(String multiplexerStack) {
        this.multiplexerStack = multiplexerStack;
    }

    public void start() throws Exception {
        if (this.channelFactory == null) {
            return;
        }
        this.channel = this.channelFactory.createMultiplexerChannel(this.multiplexerStack, null);
        this.channel.connect(this.clusterName);
        this.proxyEventDistributor = (EventDistributor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EventDistributor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                JGroupsEventDistributor.this.rpcDispatcher.callRemoteMethods(JGroupsEventDistributor.this.members, new MethodCall(method, args), 6, 0L);
                return null;
            }
        });
        this.rpcDispatcher = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EventDistributor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                EventDistributor local = JGroupsEventDistributor.this.getLocalEventDistributor();
                if (local == null) {
                    return null;
                }
                return method.invoke((Object)local, args);
            }
        }));
        this.rpcDispatcher.setDeadlockDetection(false);
        if (this.jndiName != null) {
            InitialContext ic = new InitialContext();
            Util.bind((Context)ic, (String)this.jndiName, (Object)this.proxyEventDistributor);
        }
    }

    private EventDistributor getLocalEventDistributor() {
        if (this.localEventDistributor == null && this.localEventDistributorName != null) {
            try {
                InitialContext ctx = new InitialContext();
                return (EventDistributor)ctx.lookup(this.localEventDistributorName);
            }
            catch (NamingException e) {
                return null;
            }
        }
        return this.localEventDistributor;
    }

    public void viewAccepted(View newView) {
        Vector new_members = new Vector(newView.getMembers());
        new_members.remove(this.channel.getLocalAddress());
        this.members = new_members;
    }

    public void stop() {
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Util.unbind((Context)ic, (String)this.jndiName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            this.channel.close();
            this.rpcDispatcher.stop();
        }
    }
}

