/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.util.HashSet;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheListener;
import org.teiid.cache.jboss.JBossCacheListener;

public class JBossCache<K, V>
implements Cache<K, V> {
    protected org.jboss.cache.Cache<K, V> cacheStore;
    protected Fqn rootFqn;
    protected JBossCacheListener cacheListener;
    protected CacheConfiguration config;

    public JBossCache(org.jboss.cache.Cache<K, V> cacheStore, Fqn fqn) {
        this.cacheStore = cacheStore;
        this.rootFqn = fqn;
    }

    public V get(K key) {
        Node<K, V> node = this.getRootNode();
        Node child = node.getChild(this.getFqn(key));
        if (child != null) {
            return (V)child.get(key);
        }
        return null;
    }

    protected Fqn<String> getFqn(K key) {
        if (key.getClass().isPrimitive() || key instanceof String) {
            return Fqn.fromString((String)String.valueOf(key));
        }
        return Fqn.fromString((String)String.valueOf(key.getClass().getSimpleName() + key.hashCode()));
    }

    public V put(K key, V value) {
        Node<K, V> node = this.getRootNode();
        Node child = node.addChild(this.getFqn(key));
        return (V)child.put(key, value);
    }

    public V put(K key, V value, Long ttl) {
        return this.put(key, value);
    }

    public V remove(K key) {
        Fqn<String> fqn;
        Node<K, V> node = this.getRootNode();
        Node child = node.getChild(fqn = this.getFqn(key));
        if (child != null) {
            Object value = child.remove(key);
            node.removeChild(fqn);
            return (V)value;
        }
        return null;
    }

    public int size() {
        Node<K, V> node = this.getRootNode();
        int size = 0;
        HashSet nodes = new HashSet(node.getChildren());
        for (Node child : nodes) {
            if (child.getData().isEmpty()) continue;
            ++size;
        }
        return size;
    }

    public void clear() {
        Node<K, V> node = this.getRootNode();
        node.clearData();
        HashSet nodes = new HashSet(node.getChildren());
        for (Node child : nodes) {
            child.clearData();
            node.removeChild(child.getFqn());
        }
    }

    public synchronized void addListener(CacheListener listener) {
        this.cacheListener = new JBossCacheListener(this.rootFqn, listener);
        this.cacheStore.addCacheListener((Object)this.cacheListener);
    }

    public synchronized void removeListener() {
        this.cacheStore.removeCacheListener((Object)this.cacheListener);
        this.cacheListener = null;
    }

    protected Node<K, V> getRootNode() {
        Node node = this.cacheStore.getNode(this.rootFqn);
        if (node == null) {
            throw new IllegalStateException("Cache Node " + this.rootFqn + " not found.");
        }
        return node;
    }

    public String getName() {
        return this.rootFqn.toString();
    }

    void setCacheConfiguration(CacheConfiguration config) {
        this.config = config;
    }

    public Set<K> keys() {
        HashSet keys = new HashSet();
        Node<K, V> node = this.getRootNode();
        Set children = node.getChildren();
        for (Node child : children) {
            keys.addAll(child.getData().keySet());
        }
        return keys;
    }
}

