/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.teiid.cache.Cache;

public class JBossCache<K, V>
implements Cache<String, V> {
    protected org.infinispan.Cache<String, V> cacheStore;
    private final String name;

    public JBossCache(org.infinispan.Cache<String, V> cacheStore, String cacheName) {
        this.cacheStore = cacheStore;
        this.name = cacheName;
    }

    private String fqn(String key) {
        return this.name + "." + key;
    }

    public V get(String key) {
        return (V)this.cacheStore.get((Object)this.fqn(key));
    }

    public V put(String key, V value) {
        return (V)this.cacheStore.put((Object)this.fqn(key), value);
    }

    public V put(String key, V value, Long ttl) {
        if (ttl != null) {
            return (V)this.cacheStore.put((Object)this.fqn(key), value, ttl.longValue(), TimeUnit.MILLISECONDS);
        }
        return (V)this.cacheStore.put((Object)this.fqn(key), value);
    }

    public V remove(String key) {
        return (V)this.cacheStore.remove((Object)this.fqn(key));
    }

    public int size() {
        return this.cacheStore.size();
    }

    public void clear() {
        this.cacheStore.clear();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> keys() {
        return this.cacheStore.keySet();
    }
}

