/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.lang.reflect.Method;
import org.teiid.client.xa.XATransactionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;

public class ExceptionUtil {
    public static <T extends Throwable> T getExceptionOfType(Throwable ex, Class<T> cls) {
        while (ex != null) {
            if (cls.isAssignableFrom(ex.getClass())) {
                return (T)ex;
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
        }
        return null;
    }

    public static Throwable convertException(Method method, Throwable exception) {
        boolean canThrowXATransactionException = false;
        boolean canThrowComponentException = false;
        boolean canThrowAdminException = false;
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            if (exception.getClass().isAssignableFrom(exceptionClasses[i])) {
                return exception;
            }
            canThrowComponentException |= TeiidComponentException.class.isAssignableFrom(exceptionClasses[i]);
            canThrowXATransactionException |= XATransactionException.class.isAssignableFrom(exceptionClasses[i]);
        }
        if (canThrowComponentException) {
            return new TeiidComponentException(exception);
        }
        if (canThrowXATransactionException) {
            return new XATransactionException(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return new TeiidRuntimeException(exception);
    }
}

