/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.XAResourceImpl;
import org.teiid.net.CommunicationException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.SingleInstanceCommunicationException;

public class XAConnectionImpl
implements XAConnection {
    private Set<ConnectionEventListener> listeners;
    private XAResource resource;
    private ConnectionImpl connection;
    private ConnectionSource cs;
    private boolean isClosed;

    public static XAConnectionImpl newInstance(ConnectionSource cs) {
        return new XAConnectionImpl(cs);
    }

    public XAConnectionImpl(ConnectionSource cs) {
        this.cs = cs;
    }

    @Override
    public Connection getConnection() throws SQLException {
        ConnectionImpl conn = this.getConnectionImpl();
        Connection result = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new CloseInterceptor(conn));
        return result;
    }

    ConnectionImpl getConnectionImpl() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCPlugin.Util.getString("MMXAConnection.connection_is_closed"));
        }
        if (this.connection == null) {
            try {
                this.connection = this.cs.createConnection();
            }
            catch (SQLException e) {
                this.notifyListener(e);
                throw e;
            }
        }
        return this.connection;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.newSetFromMap(new IdentityHashMap());
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.resource == null) {
            this.resource = XAResourceImpl.newInstance(this);
        }
        return this.resource;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.isClosed = true;
    }

    protected synchronized void notifyListener(SQLException e) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ConnectionEventListener listener : this.listeners) {
                if (e == null) {
                    listener.connectionClosed(new ConnectionEvent(this));
                    continue;
                }
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener arg0) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener arg0) {
    }

    private final class CloseInterceptor
    implements InvocationHandler {
        private ConnectionImpl proxiedConnection;

        CloseInterceptor(ConnectionImpl connection) {
            this.proxiedConnection = connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                this.proxiedConnection.recycleConnection();
                XAConnectionImpl.this.notifyListener(null);
                return null;
            }
            try {
                return method.invoke((Object)this.proxiedConnection, args);
            }
            catch (InvocationTargetException e) {
                ServerConnection sc;
                Exception ex = (Exception)((Object)ExceptionUtil.getExceptionOfType(e, InvalidSessionException.class));
                if (ex == null && (ex = (Exception)((Object)ExceptionUtil.getExceptionOfType(e, CommunicationException.class))) instanceof SingleInstanceCommunicationException && !(sc = this.proxiedConnection.getServerConnection()).isOpen(120000L)) {
                    ex = null;
                }
                if (ex != null) {
                    SQLException se = null;
                    se = e.getCause() instanceof SQLException ? (SQLException)e.getCause() : TeiidSQLException.create(e.getCause());
                    XAConnectionImpl.this.notifyListener(se);
                }
                throw e.getTargetException();
            }
        }
    }

    static interface ConnectionSource {
        public ConnectionImpl createConnection() throws SQLException;
    }
}

