/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnectionFactory;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.ObjectChannelFactory;
import org.teiid.net.socket.OioOjbectChannelFactory;
import org.teiid.net.socket.ServerDiscovery;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;
import org.teiid.net.socket.UrlServerDiscovery;

public class SocketServerConnectionFactory
implements ServerConnectionFactory,
SocketServerInstanceFactory {
    private static final String URL = "URL";
    private static SocketServerConnectionFactory INSTANCE;
    private static Logger log;
    private ObjectChannelFactory channelFactory;
    private Timer pingTimer;
    private HashMap<HostInfo, Set<SessionToken>> sessions = new HashMap();
    private AtomicInteger instanceCount = new AtomicInteger();
    private Map<CachedInstance, CachedInstance> instancePool = new LinkedHashMap<CachedInstance, CachedInstance>();
    private long synchronousTtl = 120000L;
    private int maxCachedInstances = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SocketServerConnectionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SocketServerConnectionFactory();
            Properties props = System.getProperties();
            InputStream is = SocketServerConnectionFactory.class.getResourceAsStream("/teiid-client-settings.properties");
            if (is != null) {
                props = new Properties(props);
                try {
                    props.load(is);
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            INSTANCE.initialize(props);
        }
        return INSTANCE;
    }

    public void initialize(Properties info) {
        PropertiesUtils.setBeanProperties((Object)this, (Properties)info, (String)"org.teiid.sockets");
        this.pingTimer = new Timer("SocketPing", true);
        this.pingTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet sessionEntries = null;
                HashMap hashMap = SocketServerConnectionFactory.this.sessions;
                synchronized (hashMap) {
                    sessionEntries = new HashSet(SocketServerConnectionFactory.this.sessions.entrySet());
                }
                for (Map.Entry entry : sessionEntries) {
                    SocketServerInstance instance = null;
                    HashSet entries = null;
                    HashMap hashMap2 = SocketServerConnectionFactory.this.sessions;
                    synchronized (hashMap2) {
                        entries = new HashSet((Collection)entry.getValue());
                    }
                    try {
                        instance = SocketServerConnectionFactory.this.getServerInstance((HostInfo)entry.getKey());
                        ILogon logon = instance.getService(ILogon.class);
                        if ("7.1.1".compareTo(instance.getServerVersion()) > 0) {
                            for (SessionToken session : entries) {
                                try {
                                    logon.assertIdentity(session);
                                    logon.ping();
                                    log.log(Level.FINER, "issueing ping for session:", session);
                                }
                                catch (InvalidSessionException e) {}
                            }
                            continue;
                        }
                        ArrayList<String> sessionStrings = new ArrayList<String>(((Set)entry.getValue()).size());
                        for (SessionToken session : entries) {
                            sessionStrings.add(session.getSessionID());
                        }
                        logon.ping(sessionStrings);
                        log.log(Level.FINER, "issueing ping for sessions:", sessionStrings);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error performing keep-alive ping", e);
                    }
                    finally {
                        if (instance == null) continue;
                        instance.shutdown();
                    }
                }
            }
        }, 120000L, 120000L);
        this.channelFactory = new OioOjbectChannelFactory(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
        boolean useCache;
        CachedInstance key = null;
        boolean bl = useCache = this.maxCachedInstances > 0;
        if (useCache) {
            CachedInstance instance = null;
            key = new CachedInstance(info);
            Map<CachedInstance, CachedInstance> map = this.instancePool;
            synchronized (map) {
                instance = this.instancePool.remove(key);
            }
            if (instance != null) {
                ILogon logon = instance.actual.getService(ILogon.class);
                boolean valid = false;
                try {
                    ResultsFuture<?> success = logon.ping();
                    success.get(this.channelFactory.getSoTimeout(), TimeUnit.MILLISECONDS);
                    valid = true;
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Error performing ping, will select another instance", e);
                }
                if (valid) {
                    return instance.proxy;
                }
                instance.actual.shutdown();
                while (true) {
                    CachedInstance invalid = null;
                    Map<CachedInstance, CachedInstance> map2 = this.instancePool;
                    synchronized (map2) {
                        invalid = this.instancePool.remove(key);
                    }
                    if (invalid == null) break;
                    invalid.actual.shutdown();
                }
            }
        }
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, this.getSynchronousTtl());
        ssii.connect(this.channelFactory);
        if (useCache) {
            key.actual = ssii;
            key.instance = this.instanceCount.getAndIncrement();
            key.proxy = (SocketServerInstance)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SocketServerInstance.class}, (InvocationHandler)new ShutdownHandler(key));
            return key.proxy;
        }
        return ssii;
    }

    @Override
    public SocketServerConnection getConnection(Properties connectionProperties) throws CommunicationException, ConnectionException {
        ServerDiscovery discovery;
        TeiidURL url;
        SocketServerConnectionFactory.updateConnectionProperties(connectionProperties);
        try {
            url = new TeiidURL(connectionProperties.getProperty("serverURL"));
        }
        catch (MalformedURLException e1) {
            throw new ConnectionException(JDBCPlugin.Event.TEIID20014, e1, e1.getMessage());
        }
        String discoveryStrategyName = connectionProperties.getProperty("discoveryStategy", URL);
        if (URL.equalsIgnoreCase(discoveryStrategyName)) {
            discovery = new UrlServerDiscovery();
        } else {
            try {
                discovery = (ServerDiscovery)ReflectionHelper.create((String)discoveryStrategyName, null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (TeiidException e) {
                throw new ConnectionException(JDBCPlugin.Event.TEIID20015, e, e.getMessage());
            }
        }
        discovery.init(url, connectionProperties);
        return new SocketServerConnection(this, url.isUsingSSL(), discovery, connectionProperties);
    }

    static void updateConnectionProperties(Properties connectionProperties) {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            connectionProperties.put("clientIpAddress", addr.getHostAddress());
            connectionProperties.put("clientHostName", addr.getCanonicalHostName());
            NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
            if (ni != null && ni.getHardwareAddress() != null) {
                StringBuilder sb = new StringBuilder();
                for (byte b : ni.getHardwareAddress()) {
                    sb.append(PropertiesUtils.toHex((int)(b >> 4)));
                    sb.append(PropertiesUtils.toHex((int)b));
                }
                connectionProperties.put("clientMAC", sb.toString());
            }
        }
        catch (UnknownHostException err1) {
            connectionProperties.put("clientIpAddress", "UnknownClientAddress");
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public long getSynchronousTtl() {
        return this.synchronousTtl;
    }

    public void setSynchronousTtl(long synchronousTTL) {
        this.synchronousTtl = synchronousTTL;
    }

    public int getMaxCachedInstances() {
        return this.maxCachedInstances;
    }

    public void setMaxCachedInstances(int maxCachedInstances) {
        this.maxCachedInstances = maxCachedInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(SocketServerInstance instance, SessionToken session) {
        HashMap<HostInfo, Set<SessionToken>> hashMap = this.sessions;
        synchronized (hashMap) {
            Set<SessionToken> instanceSessions = this.sessions.get(instance.getHostInfo());
            if (instanceSessions == null) {
                instanceSessions = new HashSet<SessionToken>();
                this.sessions.put(instance.getHostInfo(), instanceSessions);
            }
            instanceSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(SocketServerInstance instance, SessionToken session) {
        HashMap<HostInfo, Set<SessionToken>> hashMap = this.sessions;
        synchronized (hashMap) {
            Set<SessionToken> instanceSessions = this.sessions.get(instance.getHostInfo());
            if (instanceSessions != null) {
                instanceSessions.remove(session);
                if (instanceSessions.isEmpty()) {
                    this.sessions.remove(instance.getHostInfo());
                }
            }
        }
    }

    static {
        log = Logger.getLogger("org.teiid.client.sockets");
    }

    private static class CachedInstance {
        HostInfo info;
        Integer instance;
        SocketServerInstance actual;
        SocketServerInstance proxy;

        public CachedInstance(HostInfo info) {
            this.info = info;
        }

        public int hashCode() {
            return this.info.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachedInstance)) {
                return false;
            }
            CachedInstance other = (CachedInstance)obj;
            if (!this.info.equals(other.info)) {
                return false;
            }
            if (this.instance == null || other.instance == null) {
                return true;
            }
            return this.instance.equals(other.instance);
        }
    }

    private final class ShutdownHandler
    implements InvocationHandler {
        private final CachedInstance key;

        private ShutdownHandler(CachedInstance key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
            if (arg1.getName().equals("shutdown")) {
                CachedInstance purge = null;
                if (!this.key.actual.isOpen()) {
                    return null;
                }
                Map map = SocketServerConnectionFactory.this.instancePool;
                synchronized (map) {
                    SocketServerConnectionFactory.this.instancePool.put(this.key, this.key);
                    if (SocketServerConnectionFactory.this.instancePool.size() > SocketServerConnectionFactory.this.maxCachedInstances) {
                        Iterator iter = SocketServerConnectionFactory.this.instancePool.keySet().iterator();
                        purge = (CachedInstance)iter.next();
                        iter.remove();
                    }
                }
                if (purge != null) {
                    purge.actual.shutdown();
                }
                return null;
            }
            try {
                return arg1.invoke((Object)this.key.actual, arg2);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

