/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.ArrayImpl;
import org.teiid.jdbc.DataTypeTransformer;

public class TestDataTypeTransformer {
    @Test
    public void testClobToStringConversion() throws Exception {
        SerialClob clob = new SerialClob("foo".toCharArray());
        String value = DataTypeTransformer.getString((Object)clob);
        Assert.assertEquals((Object)"foo", (Object)value);
    }

    @Test
    public void testInvalidTransformation() throws Exception {
        try {
            DataTypeTransformer.getDate((Object)1);
            Assert.fail((String)"exception expected");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Unable to transform the column value 1 to a Date.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetDefaultShort() throws Exception {
        Assert.assertEquals((long)0L, (long)DataTypeTransformer.getShort(null));
    }

    @Test
    public void testGetDefaultByte() throws Exception {
        Assert.assertEquals((long)0L, (long)DataTypeTransformer.getByte(null));
    }

    @Test
    public void testGetString() throws Exception {
        Assert.assertEquals((Object)"", (Object)DataTypeTransformer.getString((Object)new SerialClob(new char[0])));
    }

    @Test
    public void testGetArray() throws Exception {
        Assert.assertEquals((Object)new ArrayImpl(new Object[]{1, 2}), (Object)DataTypeTransformer.getArray((Object)new int[]{1, 2}));
    }

    @Test
    public void testGetArray1() throws Exception {
        Assert.assertEquals((Object)new ArrayImpl(new Object[]{1, 2}), (Object)DataTypeTransformer.getArray((Object)new Integer[]{1, 2}));
    }
}

