/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.teiid.client.util.ResultsReceiver;

public class ResultsFuture<T>
implements Future<T> {
    public static ResultsFuture<Void> NULL_FUTURE = new ResultsFuture();
    private LinkedList<CompletionListener<T>> listeners = new LinkedList();
    private T result;
    private Throwable exception;
    private boolean done;
    private ResultsReceiver<T> resultsReceiver = new ResultsReceiver<T>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exceptionOccurred(Throwable e) {
            ResultsFuture resultsFuture = ResultsFuture.this;
            synchronized (resultsFuture) {
                if (ResultsFuture.this.done) {
                    throw new IllegalStateException("Already sent results");
                }
                ResultsFuture.this.exception = e;
                ResultsFuture.this.done = true;
                ResultsFuture.this.notifyAll();
            }
            ResultsFuture.this.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveResults(T results) {
            ResultsFuture resultsFuture = ResultsFuture.this;
            synchronized (resultsFuture) {
                if (ResultsFuture.this.done) {
                    throw new IllegalStateException("Already sent results");
                }
                ResultsFuture.this.result = results;
                ResultsFuture.this.done = true;
                ResultsFuture.this.notifyAll();
            }
            ResultsFuture.this.done();
        }
    };

    public ResultsReceiver<T> getResultsReceiver() {
        return this.resultsReceiver;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (!this.done) {
            this.wait();
        }
        return this.convertResult();
    }

    protected T convertResult() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long millis = unit.toMillis(timeout);
        long start = System.currentTimeMillis();
        while (!this.done) {
            long waitTill = start + millis - System.currentTimeMillis();
            if (waitTill <= 0L) {
                throw new TimeoutException();
            }
            this.wait(waitTill);
        }
        return this.convertResult();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        LinkedList<CompletionListener<T>> linkedList = this.listeners;
        synchronized (linkedList) {
            for (CompletionListener completionListener : this.listeners) {
                completionListener.onCompletion(this);
            }
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(CompletionListener<T> listener) {
        ResultsFuture resultsFuture = this;
        synchronized (resultsFuture) {
            if (this.done) {
                listener.onCompletion(this);
                return;
            }
            LinkedList<CompletionListener<T>> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.add(listener);
            }
        }
    }

    static {
        NULL_FUTURE.getResultsReceiver().receiveResults(null);
    }

    public static interface CompletionListener<T> {
        public void onCompletion(ResultsFuture<T> var1);
    }
}

