/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TestConnection;
import org.teiid.jdbc.XAConnectionImpl;
import org.teiid.net.ServerConnection;

public class TestXAConnection {
    @Test
    public void testConnectionClose() throws Exception {
        ConnectionImpl mmConn = TestConnection.getMMConnection();
        XAConnectionImpl xaConn = new XAConnectionImpl(mmConn);
        Connection conn = xaConn.getConnection();
        StatementImpl stmt = (StatementImpl)conn.createStatement();
        conn.setAutoCommit(false);
        conn.close();
        ServerConnection sc = xaConn.getConnectionImpl().getServerConnection();
        ((ServerConnection)Mockito.verify((Object)sc, (VerificationMode)VerificationModeFactory.times((int)1))).cleanUp();
        Assert.assertTrue((boolean)stmt.isClosed());
        Assert.assertTrue((boolean)conn.getAutoCommit());
        conn = xaConn.getConnection();
        stmt = (StatementImpl)conn.createStatement();
        XAResource resource = xaConn.getXAResource();
        resource.start((Xid)new XidImpl(1, new byte[0], new byte[0]), 0);
        conn.close();
        Assert.assertTrue((boolean)stmt.isClosed());
        Assert.assertTrue((boolean)conn.getAutoCommit());
    }

    @Test
    public void testDisableLoadBalancing() throws Exception {
        ConnectionImpl mmConn = TestConnection.getMMConnection();
        XAConnectionImpl xaConn = new XAConnectionImpl(mmConn);
        xaConn.setLoadBalance(false);
        Connection conn = xaConn.getConnection();
        conn.close();
        ServerConnection sc = xaConn.getConnectionImpl().getServerConnection();
        ((ServerConnection)Mockito.verify((Object)sc, (VerificationMode)VerificationModeFactory.times((int)0))).cleanUp();
    }

    @Test
    public void testNotification() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ((ConnectionImpl)Mockito.doThrow((Throwable)new SQLException((Throwable)new InvalidSessionException())).when((Object)conn)).commit();
        XAConnectionImpl xaConn = new XAConnectionImpl(conn);
        ConnectionEventListener cel = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        xaConn.addConnectionEventListener(cel);
        Connection c = xaConn.getConnection();
        try {
            c.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ConnectionEventListener)Mockito.verify((Object)cel)).connectionErrorOccurred((ConnectionEvent)Mockito.anyObject());
    }
}

