/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.connector;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ConnectorBindingCreationTest
extends TestCase {
    private static final String ORACLE_ANSI = "Oracle ANSI JDBC Connector";
    private static final String ORACLE_8 = "Oracle 8 JDBC Connector";
    private static final String DB2 = "DB2 JDBC Connector";
    private static final String SYBASE_ANSI = "Sybase ANSI JDBC Connector";
    private static final String SYBASE_11 = "Sybase 11 JDBC Connector";
    private static final String SQL_SERVER = "SQL Server JDBC Connector";
    private static final String JDBC_GENERIC = "JDBC Connector";
    private static final String MS_ACCESS = "MS Access Connector";
    private static final String JDBC_ODBC = "JDBC ODBC Connector";
    private static final String TEXT_FILE = "Text File Connector";
    private static final String MYSQL = "MySQL JDBC Connector";
    private static final String POSTGRESQL = "PostgreSQL JDBC Connector";
    private static final String APACHE_DERBY_EMBEDDED = "Apache Derby Embedded Connector";
    private static final String APACHE_DERBY_NETWORK = "Apache Derby Network Connector";
    private static final String SECURE_DATA_SOURCE = "Secure Data Source Connector";
    private static final String SOAP = "SOAP Connector";
    private static final String XML_FILE = "XML File Connector";
    private static final String XML_HTTP = "XML HTTP Connector";
    private String CONFIG_FILE_PATH = null;
    private ConfigurationModelContainer config;

    public ConnectorBindingCreationTest() {
    }

    public ConnectorBindingCreationTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.CONFIG_FILE_PATH = UnitTestUtil.getTestDataPath() + "/" + "config.xml";
        File configFile = new File(this.CONFIG_FILE_PATH);
        this.config = this.importConfigurationModel(configFile, Configuration.NEXT_STARTUP_ID);
    }

    public void testCreateORACLE_ANSIConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(ORACLE_ANSI);
        this.helpTestConnectorBinding(ct, "TestOracleANSI");
    }

    public void testCreateORACLE_8ConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(ORACLE_8);
        this.helpTestConnectorBinding(ct, "ORACLE_8");
    }

    public void testCreateDB2ConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(DB2);
        this.helpTestConnectorBinding(ct, "DB2");
    }

    public void testCreateSYBASE_ANSIConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(SYBASE_ANSI);
        this.helpTestConnectorBinding(ct, "SYBASE_ANSI");
    }

    public void testCreateSYBASE_11ConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(SYBASE_11);
        this.helpTestConnectorBinding(ct, "SYBASE_11");
    }

    public void testCreateSQL_SERVERConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(SQL_SERVER);
        this.helpTestConnectorBinding(ct, "SQL_SERVER");
    }

    public void testCreateJDBC_GENERICConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(JDBC_GENERIC);
        this.helpTestConnectorBinding(ct, "JDBC_GENERIC");
    }

    public void testCreateMS_ACCESSConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(MS_ACCESS);
        this.helpTestConnectorBinding(ct, "MS_ACCESS");
    }

    public void testCreateJDBC_ODBCConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(JDBC_ODBC);
        this.helpTestConnectorBinding(ct, "JDBC_ODBC");
    }

    public void testCreateTEXT_FILEConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(TEXT_FILE);
        this.helpTestConnectorBinding(ct, "TEXT_FILE");
    }

    public void testCreateMYSQLConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(MYSQL);
        this.helpTestConnectorBinding(ct, "MYSQL");
    }

    public void testCreatePOSTGRESQLConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(POSTGRESQL);
        this.helpTestConnectorBinding(ct, "POSTGRESQL");
    }

    public void testCreateAPACHE_DERBY_EMBEDDEDConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(APACHE_DERBY_EMBEDDED);
        this.helpTestConnectorBinding(ct, "APACHE_DERBY_EMBEDDED");
    }

    public void testCreateAPACHE_DERBY_NETWORKConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(APACHE_DERBY_NETWORK);
        this.helpTestConnectorBinding(ct, "APACHE_DERBY_NETWORK");
    }

    public void testCreateSECURE_DATA_SOURCEConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(SECURE_DATA_SOURCE);
        this.helpTestConnectorBinding(ct, "SECURE_DATA_SOURCE");
    }

    public void testCreateSOAPConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(SOAP);
        this.helpTestConnectorBinding(ct, "SOAP");
    }

    public void testCreateXML_FILEConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(XML_FILE);
        this.helpTestConnectorBinding(ct, "XML_FILE");
    }

    public void testCreateXML_HTTPConnectorBinding() throws Exception {
        ComponentType ct = this.config.getComponentType(XML_HTTP);
        this.helpTestConnectorBinding(ct, "XML_HTTP");
    }

    private void helpTestConnectorBinding(ComponentType ct, String bindingName) {
        BasicConfigurationObjectEditor coe = new BasicConfigurationObjectEditor();
        ConnectorBinding binding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)ct.getID(), bindingName, null);
        Properties props = binding.getProperties();
        ConnectorBindingCreationTest.assertNotNull((String)"Props are null!", (Object)props);
        Properties defaultProps = ct.getDefaultPropertyValues();
        ConnectorBindingCreationTest.assertNotNull((String)"Default Props are null!", (Object)defaultProps);
        binding = (ConnectorBinding)coe.modifyProperties((ComponentObject)binding, defaultProps, 1);
        props = binding.getProperties();
        this.assertNotEmpty("Assigned connector binding props are empty!", props);
        ConnectorBindingCreationTest.assertEquals((String)"Expected Binding props to be equal to default props!", (Object)props, (Object)defaultProps);
    }

    private void assertNotEmpty(String message, Properties props) {
        if (props == null || props.keySet().size() == 0) {
            throw new AssertionFailedError(message);
        }
    }

    private ConfigurationModelContainer importConfigurationModel(File fileToImport, ConfigurationID configID) throws Exception {
        Collection configObjects = null;
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        ConfigurationModelContainerImpl configModel = null;
        XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
        FileInputStream inputStream = new FileInputStream(fileToImport);
        configObjects = io.importConfigurationObjects((InputStream)inputStream, (ConfigurationObjectEditor)editor, configID.getFullName());
        configModel = new ConfigurationModelContainerImpl();
        configModel.setConfigurationObjects(configObjects);
        return configModel;
    }
}

