/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentTypeDefnID;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.common.config.model.BasicComponentTypeDefn;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.config.model.ComponentCryptoUtil;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestComponentCryptoUtil
extends TestCase {
    private static String ENCRYPTED;
    private static final String NOT_ENCRYPTED = "not decrypted";

    public TestComponentCryptoUtil(String name) throws Exception {
        super(name);
    }

    public void setUp() throws Exception {
        System.setProperty("metamatrix.config.none", "true");
        System.setProperty("metamatrix.config.reader", "com.metamatrix.common.config.reader.SystemCurrentConfigurationReader");
        ENCRYPTED = new String(CryptoUtil.stringEncrypt((String)"password"));
    }

    public void testCheckPropertiesDecryptable() throws Exception {
        BasicConnectorBinding defn = new BasicConnectorBinding(null, new ConnectorBindingID(null, "binding"), null);
        ArrayList componentTypeDefns = new ArrayList();
        this.helpSetProperty((BasicComponentDefn)defn, componentTypeDefns, "prop1", ENCRYPTED, true);
        this.helpSetProperty((BasicComponentDefn)defn, componentTypeDefns, "prop2", NOT_ENCRYPTED, false);
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((ComponentDefn)defn, componentTypeDefns);
        TestComponentCryptoUtil.assertTrue((boolean)decryptable);
        componentTypeDefns = new ArrayList();
        this.helpSetProperty((BasicComponentDefn)defn, componentTypeDefns, "prop1", ENCRYPTED, true);
        this.helpSetProperty((BasicComponentDefn)defn, componentTypeDefns, "prop2", NOT_ENCRYPTED, true);
        decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((ComponentDefn)defn, componentTypeDefns);
        TestComponentCryptoUtil.assertFalse((boolean)decryptable);
    }

    private void helpSetProperty(BasicComponentDefn defn, List componentTypeDefns, String key, String value, boolean isMasked) {
        defn.addProperty(key, value);
        PropertyDefinitionImpl pd = new PropertyDefinitionImpl();
        pd.setName(key);
        pd.setMasked(isMasked);
        BasicComponentTypeDefn ctd = new BasicComponentTypeDefn(new ComponentTypeDefnID(key), null, (PropertyDefinition)pd, false, false);
        componentTypeDefns.add(ctd);
    }

    public void testCheckPropertiesDecryptableEmpty() throws Exception {
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((Properties)new Properties(), new ArrayList());
        TestComponentCryptoUtil.assertTrue((String)"Expected true ", (boolean)decryptable);
    }

    public void testCheckPropertiesDecryptableNull() throws Exception {
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((Properties)null, (Collection)null);
        TestComponentCryptoUtil.assertTrue((String)"Expected true ", (boolean)decryptable);
    }

    public void testCheckPropertiesDecryptableNullProperties() throws Exception {
        ArrayList<String> maskedNames = new ArrayList<String>();
        maskedNames.add("Roberto");
        maskedNames.add("Pietro");
        maskedNames.add("Digiorno");
        maskedNames.add("Digragorio");
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((Properties)null, maskedNames);
        TestComponentCryptoUtil.assertTrue((String)"Expected true ", (boolean)decryptable);
    }

    public void testCheckPropertiesDecryptableFail() throws Exception {
        String maskedPropName = "password";
        ArrayList<String> maskedNames = new ArrayList<String>();
        maskedNames.add(maskedPropName);
        Properties props = new Properties();
        props.setProperty(maskedPropName, "mm");
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((Properties)props, maskedNames);
        TestComponentCryptoUtil.assertFalse((String)"Expected not decryptable ", (boolean)decryptable);
    }

    public void testCheckPropertiesDecryptablePass() throws Exception {
        String maskedPropName = "password";
        ArrayList<String> maskedNames = new ArrayList<String>();
        maskedNames.add(maskedPropName);
        Properties props = new Properties();
        props.setProperty(maskedPropName, ENCRYPTED);
        boolean decryptable = ComponentCryptoUtil.checkPropertiesDecryptable((Properties)props, maskedNames);
        TestComponentCryptoUtil.assertTrue((String)"Expected decryptable ", (boolean)decryptable);
    }
}

