/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.PropertyValidations;
import junit.framework.TestCase;

public class TestPropertyValidation
extends TestCase {
    public TestPropertyValidation(String name) {
        super(name);
    }

    public void testBoundariesMultiCastPort() throws Exception {
        PropertyValidations val = new PropertyValidations();
        val.isPropertyValid("udp.mcast_addr", "224.0.0.0");
        val.isPropertyValid("udp.mcast_addr", "224.255.255.255");
    }

    public void testInvalidAlphaMultiCastPort() throws Exception {
        try {
            PropertyValidations val = new PropertyValidations();
            val.isPropertyValid("udp.mcast_addr", "224.a.c.d");
            TestPropertyValidation.fail((String)"224.a.c.d multicast port has alpha characters and is invalid");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testMissingNodesMultiCastPort() throws Exception {
        try {
            PropertyValidations val = new PropertyValidations();
            val.isPropertyValid("udp.mcast_addr", "224.10.");
            TestPropertyValidation.fail((String)"224.10. multicast port is missing nodes and is invalid");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

