/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.TestCase;

public class TestXMLConfigurationImportExportUtility
extends TestCase {
    public void testImportConnectorArchive() throws Exception {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        FileInputStream stream = new FileInputStream(UnitTestUtil.getTestDataPath() + "/configutil/sample_connector_archive.caf");
        ConnectorArchive archive = util.importConnectorArchive((InputStream)stream, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)archive);
        ConnectorBindingType type = archive.getConnectorTypes()[0];
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)type);
        TestXMLConfigurationImportExportUtility.assertEquals((String)"Sample Connector", (String)type.getName());
        ExtensionModule[] extModules = archive.getExtensionModules(type);
        TestXMLConfigurationImportExportUtility.assertEquals((int)2, (int)extModules.length);
        TestXMLConfigurationImportExportUtility.assertEquals((String)"jdbcconn.jar", (String)extModules[0].getFullName());
        TestXMLConfigurationImportExportUtility.assertEquals((String)"sampleconn.jar", (String)extModules[1].getFullName());
    }

    public void testExportConnectorArchive() throws Exception {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        ConnectorBindingType type = (ConnectorBindingType)util.importComponentType((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + "/configutil/sample.cdk"), (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), "sample");
        BasicExtensionModule ext1 = new BasicExtensionModule("jdbcconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/jdbcconn.jar")));
        BasicExtensionModule ext2 = new BasicExtensionModule("sampleconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/jdbcconn.jar")));
        BasicConnectorArchive ca = new BasicConnectorArchive();
        ca.addConnectorType(type);
        ca.addExtensionModule(type, (ExtensionModule)ext1);
        ca.addExtensionModule(type, (ExtensionModule)ext2);
        File f = new File(UnitTestUtil.getTestDataPath() + "/configutil/exported_sample.caf");
        FileOutputStream out = new FileOutputStream(f);
        util.exportConnectorArchive((OutputStream)out, (ConnectorArchive)ca, new Properties());
        out.close();
        ZipFile zip = new ZipFile(UnitTestUtil.getTestDataPath() + "/configutil/exported_sample.caf");
        ZipEntry entry = zip.getEntry("ConnectorTypes/");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        entry = zip.getEntry("Manifest.xml");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        entry = zip.getEntry("ConnectorTypes/sample");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        entry = zip.getEntry("ConnectorTypes/sample/sample.cdk");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        entry = zip.getEntry("ConnectorTypes/sample/jdbcconn.jar");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        entry = zip.getEntry("ConnectorTypes/sample/sampleconn.jar");
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)entry);
        zip.close();
        f.delete();
    }

    public void testImportSelfExportedConnectorArchive() throws Exception {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        ConnectorBindingType type = (ConnectorBindingType)util.importComponentType((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + "/configutil/sample.cdk"), (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), "myexported");
        BasicExtensionModule ext1 = new BasicExtensionModule("jdbcconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/jdbcconn.jar")));
        BasicExtensionModule ext2 = new BasicExtensionModule("sampleconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar")));
        BasicConnectorArchive ca = new BasicConnectorArchive();
        ca.addConnectorType(type);
        ca.addExtensionModule(type, (ExtensionModule)ext1);
        ca.addExtensionModule(type, (ExtensionModule)ext2);
        File f = new File(UnitTestUtil.getTestDataPath() + "/configutil/exported_sample.caf");
        FileOutputStream out = new FileOutputStream(f);
        util.exportConnectorArchive((OutputStream)out, (ConnectorArchive)ca, new Properties());
        out.close();
        FileInputStream stream = new FileInputStream(f);
        ConnectorArchive archive = util.importConnectorArchive((InputStream)stream, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
        stream.close();
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)archive);
        ConnectorBindingType type2 = archive.getConnectorTypes()[0];
        TestXMLConfigurationImportExportUtility.assertNotNull((Object)type2);
        TestXMLConfigurationImportExportUtility.assertEquals((String)"myexported", (String)type2.getName());
        ExtensionModule[] extModules = archive.getExtensionModules(type2);
        TestXMLConfigurationImportExportUtility.assertEquals((int)2, (int)extModules.length);
        TestXMLConfigurationImportExportUtility.assertEquals((String)"jdbcconn.jar", (String)extModules[0].getFullName());
        TestXMLConfigurationImportExportUtility.assertEquals((String)"sampleconn.jar", (String)extModules[1].getFullName());
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleTypesInSingleCAFExport() throws Exception {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        try {
            FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar"), (String)(UnitTestUtil.getTestDataPath() + "/configutil/ext1.jar"), (boolean)true);
            FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar"), (String)(UnitTestUtil.getTestDataPath() + "/configutil/ext2.jar"), (boolean)true);
            FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar"), (String)(UnitTestUtil.getTestDataPath() + "/configutil/ext3.jar"), (boolean)true);
            FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar"), (String)(UnitTestUtil.getTestDataPath() + "/configutil/ext4.jar"), (boolean)true);
            FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar"), (String)(UnitTestUtil.getTestDataPath() + "/configutil/ext5.jar"), (boolean)true);
            BasicConnectorArchive ca = new BasicConnectorArchive();
            for (int i = 1; i <= 3; ++i) {
                ConnectorBindingType type = (ConnectorBindingType)util.importComponentType((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + "/configutil/type" + i + ".cdk"), (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), null);
                ca.addConnectorType(type);
                String[] extModules = type.getExtensionModules();
                for (int m = 0; m < extModules.length; ++m) {
                    BasicExtensionModule ext = new BasicExtensionModule(extModules[m], "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/" + extModules[m])));
                    ca.addExtensionModule(type, (ExtensionModule)ext);
                }
            }
            File f = new File(UnitTestUtil.getTestDataPath() + "/configutil/exported_multiple_types.caf");
            FileOutputStream out = new FileOutputStream(f);
            util.exportConnectorArchive((OutputStream)out, (ConnectorArchive)ca, new Properties());
            out.close();
            TestXMLConfigurationImportExportUtility.assertTrue((String)"Exported File must exist", (boolean)f.exists());
            ZipFile zip = new ZipFile(f);
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"1 null", (Object)zip.getEntry("ConnectorTypes/TypeOne/TypeOne.cdk"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"2 null", (Object)zip.getEntry("ConnectorTypes/TypeOne/ext4.jar"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"3 null", (Object)zip.getEntry("ConnectorTypes/TypeTwo/TypeTwo.cdk"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"4 null", (Object)zip.getEntry("ConnectorTypes/TypeThree/TypeThree.cdk"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"5 null", (Object)zip.getEntry("ConnectorTypes/TypeThree/ext3.jar"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"6 null", (Object)zip.getEntry("ConnectorTypes/TypeThree/ext5.jar"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"7 null", (Object)zip.getEntry("ConnectorTypes/Shared/ext1.jar"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"8 null", (Object)zip.getEntry("ConnectorTypes/Shared/ext2.jar"));
            TestXMLConfigurationImportExportUtility.assertNotNull((String)"9 null", (Object)zip.getEntry("Manifest.xml"));
            zip.close();
            FileInputStream stream = new FileInputStream(f);
            ConnectorArchive archive = util.importConnectorArchive((InputStream)stream, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
            stream.close();
            TestXMLConfigurationImportExportUtility.assertNotNull((Object)archive);
            ConnectorBindingType[] types = archive.getConnectorTypes();
            TestXMLConfigurationImportExportUtility.assertEquals((int)3, (int)types.length);
            for (int i = 0; i < types.length; ++i) {
                int m;
                ExtensionModule[] modules;
                ConnectorBindingType type = types[1];
                if (type.getName().equals("TypeOne")) {
                    modules = archive.getExtensionModules(type);
                    TestXMLConfigurationImportExportUtility.assertEquals((int)2, (int)modules.length);
                    for (m = 0; m < modules.length; ++m) {
                        TestXMLConfigurationImportExportUtility.assertTrue((modules[m].getFullName().equals("ext1.jar") || modules[m].getFullName().equals("ext4.jar") ? 1 : 0) != 0);
                    }
                    continue;
                }
                if (type.getName().equals("TypeTwo")) {
                    modules = archive.getExtensionModules(type);
                    TestXMLConfigurationImportExportUtility.assertEquals((int)2, (int)modules.length);
                    for (m = 0; m < modules.length; ++m) {
                        TestXMLConfigurationImportExportUtility.assertTrue((modules[m].getFullName().equals("ext1.jar") || modules[m].getFullName().equals("ext2.jar") ? 1 : 0) != 0);
                    }
                    continue;
                }
                if (type.getName().equals("TypeThree")) {
                    modules = archive.getExtensionModules(type);
                    TestXMLConfigurationImportExportUtility.assertEquals((int)4, (int)modules.length);
                    for (m = 0; m < modules.length; ++m) {
                        TestXMLConfigurationImportExportUtility.assertTrue((modules[m].getFullName().equals("ext1.jar") || modules[m].getFullName().equals("ext2.jar") || modules[m].getFullName().equals("ext3.jar") || modules[m].getFullName().equals("ext5.jar") ? 1 : 0) != 0);
                    }
                    continue;
                }
                TestXMLConfigurationImportExportUtility.fail((String)"Unknown type");
            }
            String nl = "\n";
            String manifest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + nl + "<DeploymentManifest>" + nl + "    <ConnectorTypes>" + nl + "        <ConnectorType Name=\"TypeOne\" File=\"ConnectorTypes/TypeOne/TypeOne.cdk\">" + nl + "            <ExtensionModules>" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/Shared/ext1.jar\" />" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/TypeOne/ext4.jar\" />" + nl + "            </ExtensionModules>" + nl + "        </ConnectorType>" + nl + "        <ConnectorType Name=\"TypeTwo\" File=\"ConnectorTypes/TypeTwo/TypeTwo.cdk\">" + nl + "            <ExtensionModules>" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/Shared/ext2.jar\" />" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/Shared/ext1.jar\" />" + nl + "            </ExtensionModules>" + nl + "        </ConnectorType>" + nl + "        <ConnectorType Name=\"TypeThree\" File=\"ConnectorTypes/TypeThree/TypeThree.cdk\">" + nl + "            <ExtensionModules>" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/Shared/ext1.jar\" />" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/Shared/ext2.jar\" />" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/TypeThree/ext3.jar\" />" + nl + "                <ExtensionModule Type=\"JAR File\" File=\"ConnectorTypes/TypeThree/ext5.jar\" />" + nl + "            </ExtensionModules>" + nl + "        </ConnectorType>" + nl + "    </ConnectorTypes>" + nl + "</DeploymentManifest>" + nl + "" + nl;
            String actualManifest = new String(archive.getManifestContents());
            TestXMLConfigurationImportExportUtility.assertEquals((String)manifest, (String)actualManifest);
            f.delete();
        }
        finally {
            FileUtils.remove((String)(UnitTestUtil.getTestDataPath() + "/configutil/ext1.jar"));
            FileUtils.remove((String)(UnitTestUtil.getTestDataPath() + "/configutil/ext2.jar"));
            FileUtils.remove((String)(UnitTestUtil.getTestDataPath() + "/configutil/ext3.jar"));
            FileUtils.remove((String)(UnitTestUtil.getTestDataPath() + "/configutil/ext4.jar"));
            FileUtils.remove((String)(UnitTestUtil.getTestDataPath() + "/configutil/ext5.jar"));
        }
    }

    public void testExportBadType() throws Exception {
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        BasicConnectorArchive ca = new BasicConnectorArchive();
        ConnectorBindingType type = (ConnectorBindingType)util.importComponentType((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + "/configutil/type1.cdk"), (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(), null);
        ca.addConnectorType(type);
        BasicExtensionModule ext1 = new BasicExtensionModule("jdbcconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/jdbcconn.jar")));
        BasicExtensionModule ext2 = new BasicExtensionModule("sampleconn.jar", "JAR File", "Foo", ByteArrayHelper.toByteArray((File)new File(UnitTestUtil.getTestDataPath() + "/configutil/sampleconn.jar")));
        ca.addExtensionModule(type, (ExtensionModule)ext2);
        ca.addExtensionModule(type, (ExtensionModule)ext1);
        try {
            File f = new File(UnitTestUtil.getTestDataPath() + "/configutil/exported_multiple_types.caf");
            FileOutputStream out = new FileOutputStream(f);
            util.exportConnectorArchive((OutputStream)out, (ConnectorArchive)ca, new Properties());
            out.close();
            f.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

