/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.LogMessage;
import com.metamatrix.internal.core.log.PlatformLog;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestLogManager
extends TestCase {
    public TestLogManager(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        LogManager.configuration = new BasicLogConfiguration();
        LogManager.logListener = new PlatformLog();
    }

    public void testIsMessageToBeRecordedStringI() {
        String context = "SomeContext";
        TestLogManager.assertTrue((boolean)LogManager.isMessageToBeRecorded((String)context, (int)1));
        LogConfiguration cfg = LogManager.getLogConfigurationCopy();
        cfg.discardContext(context);
        LogManager.setLogConfiguration((LogConfiguration)cfg);
        TestLogManager.assertFalse((boolean)LogManager.isMessageToBeRecorded((String)context, (int)1));
    }

    public void testLogMessage() throws Exception {
        LogConfiguration cfg = LogManager.getLogConfigurationCopy();
        cfg.setMessageLevel(4);
        LogManager.setLogConfiguration((LogConfiguration)cfg);
        ListLogger listener = new ListLogger(6);
        LogManager.logListener = listener;
        ArrayList<String> sentMsgList = new ArrayList<String>();
        sentMsgList.add("A message 1");
        sentMsgList.add("A message 2");
        sentMsgList.add("A message 3");
        sentMsgList.add("A message 4");
        sentMsgList.add("A message 5");
        sentMsgList.add("A message 6");
        for (String msg : sentMsgList) {
            LogManager.logInfo((String)"SomeContext", (String)msg);
        }
        List recevedMsgList = listener.getLoggedMessages();
        TestLogManager.assertEquals(sentMsgList, (Object)recevedMsgList);
    }

    class ListLogger
    implements LogListener {
        private List messages = new ArrayList();
        private int expectedMessages;

        public ListLogger(int expectedMessages) {
            this.expectedMessages = expectedMessages;
        }

        public synchronized void logMessage(LogMessage msg) {
            this.messages.add(msg.getText());
            if (this.messages.size() == this.expectedMessages) {
                this.notifyAll();
            }
        }

        public void shutdown() {
            this.messages.clear();
            this.messages = null;
        }

        public int size() {
            return this.messages.size();
        }

        public synchronized List getLoggedMessages() throws InterruptedException {
            if (this.messages.size() < this.expectedMessages) {
                this.wait(1000L);
            }
            return this.messages;
        }
    }
}

