/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.queue;

import com.metamatrix.common.queue.FakeWorkItem;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.common.queue.WorkerPoolStats;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class TestQueueWorkerPool
extends TestCase {
    public TestQueueWorkerPool(String arg0) {
        super(arg0);
    }

    public void testQueuing() throws Exception {
        long SINGLE_WAIT = 50L;
        int WORK_ITEMS = 10;
        int MAX_THREADS = 5;
        WorkerPool pool = WorkerPoolFactory.newWorkerPool((String)"test", (int)5, (long)120000L);
        for (int i = 0; i < 10; ++i) {
            pool.execute((Runnable)new FakeWorkItem(50L));
        }
        pool.shutdown();
        pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        TestQueueWorkerPool.assertTrue((boolean)pool.isTerminated());
        WorkerPoolStats stats = pool.getStats();
        TestQueueWorkerPool.assertEquals((long)10L, (long)stats.totalCompleted);
        TestQueueWorkerPool.assertEquals((String)"Expected threads to be maxed out", (int)5, (int)stats.highestActiveThreads);
    }

    public void testThreadReuse() throws Exception {
        long SINGLE_WAIT = 50L;
        long NUM_THREADS = 5L;
        WorkerPool pool = WorkerPoolFactory.newWorkerPool((String)"test", (int)5, (long)120000L);
        int i = 0;
        while ((long)i < 5L) {
            pool.execute((Runnable)new FakeWorkItem(50L));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        pool.shutdown();
        WorkerPoolStats stats = pool.getStats();
        TestQueueWorkerPool.assertEquals((String)"Expected 1 thread for serial execution", (int)1, (int)stats.highestActiveThreads);
        pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    public void testShutdown() throws Exception {
        WorkerPool pool = WorkerPoolFactory.newWorkerPool((String)"test", (int)5, (long)120000L);
        pool.shutdown();
        try {
            pool.execute((Runnable)new FakeWorkItem(1L));
            TestQueueWorkerPool.fail((String)"expected exception");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

