/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemView;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class FileSystemTestUtil {
    private FileSystemTestUtil() {
    }

    public static void helpTestDelete(FileSystemEntry fsEntry) {
        FileSystemTestUtil.helpTestDelete(fsEntry, true);
    }

    public static void helpTestDelete(FileSystemEntry fsEntry, boolean expectSuccess) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        boolean success = fsEntry.delete();
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\" deletion from the file system, success =" + success), (success == expectSuccess ? 1 : 0) != 0);
        if (expectSuccess) {
            Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\" was not deleted from the file system"), (!fsEntry.exists() ? 1 : 0) != 0);
            Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\" was not deleted from the file system"), (!fsEntry.getFile().exists() ? 1 : 0) != 0);
        }
    }

    public static void helpTestDefaultProperties(FileSystemEntry fsEntry, boolean isFolder) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        FileSystemTestUtil.helpTestExistence(fsEntry, true);
        FileSystemTestUtil.helpTestEntryType(fsEntry, isFolder);
        FileSystemTestUtil.helpTestPrivileges(fsEntry, true, true);
        FileSystemTestUtil.helpTestEmpty(fsEntry, true);
    }

    public static void helpTestExistence(FileSystemEntry fsEntry, boolean exists) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", exists is " + fsEntry.exists()), (fsEntry.exists() == exists ? 1 : 0) != 0);
    }

    public static void helpTestEntryType(FileSystemEntry fsEntry, boolean isFolder) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        String entryType = fsEntry.isFolder() ? "FOLDER" : "FILE";
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", type is " + entryType), (fsEntry.isFolder() == isFolder ? 1 : 0) != 0);
        ObjectDefinition type = fsEntry.getType();
        if (isFolder) {
            Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", type is " + fsEntry.getType()), (type == DirectoryEntry.TYPE_FOLDER ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", type is " + fsEntry.getType()), (type == DirectoryEntry.TYPE_FILE ? 1 : 0) != 0);
        }
    }

    public static void helpTestPrivileges(FileSystemEntry fsEntry, boolean canRead, boolean canWrite) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        fsEntry.isFolder();
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", canRead is " + fsEntry.canRead()), (fsEntry.canRead() == canRead ? 1 : 0) != 0);
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", canRead is " + fsEntry.canWrite()), (fsEntry.canWrite() == canWrite ? 1 : 0) != 0);
        Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", isReadOnly is " + fsEntry.isReadOnly()), (fsEntry.isReadOnly() == !canWrite ? 1 : 0) != 0);
    }

    public static void helpTestEmpty(FileSystemEntry fsEntry, boolean empty) {
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)fsEntry);
        if (!fsEntry.isFolder()) {
            Assert.assertTrue((String)("FileSystemEntry \"" + fsEntry + "\", isEmpty is " + fsEntry.isEmpty()), (fsEntry.isEmpty() == empty ? 1 : 0) != 0);
        }
    }

    public static FileSystemEntry helpGetActualRoot(FileSystemView fsView) {
        Assert.assertNotNull((String)"The FileSystemView reference should not be null", (Object)fsView);
        List roots = fsView.getActualRoots();
        Assert.assertTrue((String)("FileSystemView has " + roots.size() + " roots"), (roots.size() >= 1 ? 1 : 0) != 0);
        return (FileSystemEntry)roots.iterator().next();
    }

    public static FileSystemEntry helpLookupByName(String name, Collection entries) {
        Assert.assertNotNull((String)"The String reference should not be null", (Object)name);
        Assert.assertNotNull((String)"The List reference should not be null", (Object)entries);
        for (FileSystemEntry entry : entries) {
            if (entry == null || !entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static void helpTestParentChildRelationship(FileSystemView fsView, FileSystemEntry parent, FileSystemEntry child) {
        Assert.assertNotNull((String)"The FileSystemView reference should not be null", (Object)fsView);
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)parent);
        Assert.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)child);
        Assert.assertTrue((String)("Entry \"" + child + "\" should have parent \"" + parent + "\""), (fsView.getParent((TreeNode)child) == parent ? 1 : 0) != 0);
        Assert.assertTrue((String)("Entry \"" + parent + "\" should have child \"" + child + "\""), (boolean)fsView.getChildren((TreeNode)parent).contains(child));
    }

    public static void helpCompareResults(Collection results, Collection expectedResults) {
        Assert.assertNotNull((String)"The Collection reference should not be null", (Object)results);
        Assert.assertNotNull((String)"The Collection reference should not be null", (Object)expectedResults);
        Assert.assertTrue((String)("The number of entries in the result is " + results.size() + ", expected " + expectedResults.size()), (results.size() == expectedResults.size() ? 1 : 0) != 0);
        for (FileSystemEntry entry : results) {
            Assert.assertTrue((String)("Entry \"" + entry + "\" not found in expected results"), (boolean)expectedResults.contains(entry));
        }
    }

    public static void printCollection(Collection c, PrintStream stream) {
        Assert.assertNotNull((String)"The Collection reference may not be null", (Object)c);
        Assert.assertNotNull((String)"The PrintStream reference may not be null", (Object)stream);
        if (c.isEmpty()) {
            stream.println("<empty Collection>");
        }
        int counter = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            stream.println("Collection[" + counter + "] = " + i.next());
            ++counter;
        }
    }
}

