/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemTestUtil;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;

public class TestFileSystemEntry
extends TestCase {
    public static final SimpleDateFormat FORMATTER = new SimpleDateFormat("MMddyyhhmmssSSS");
    public static final String FILE_PREFIX = "tmp";
    public static final String FILE_SUFFIX = "";

    public TestFileSystemEntry(String name) {
        super(name);
    }

    public static File exampleTempFile() {
        Date currentTime = new Date();
        String timestamp = FORMATTER.format(currentTime);
        int counter = 0;
        String filename = FILE_PREFIX + timestamp + Integer.toString(counter) + FILE_SUFFIX;
        File tmp = new File(UnitTestUtil.getTestScratchPath(), filename);
        while (tmp.exists()) {
            filename = FILE_PREFIX + timestamp + Integer.toString(++counter) + FILE_SUFFIX;
            tmp = new File(UnitTestUtil.getTestScratchPath(), filename);
        }
        return tmp;
    }

    private FileSystemEntry helpTestCreate() {
        File tmp = TestFileSystemEntry.exampleTempFile();
        return this.helpTestCreate(tmp);
    }

    private FileSystemEntry helpTestCreate(File file) {
        FileSystemEntry fsEntry = null;
        try {
            fsEntry = new FileSystemEntry(file);
        }
        catch (IOException e) {
            TestFileSystemEntry.fail((String)("Error creating new FileSystemEntry instance: " + e));
        }
        TestFileSystemEntry.assertNotNull((String)"Error creating new FileSystemEntry instance", (Object)fsEntry);
        return fsEntry;
    }

    private FileSystemEntry helpTestCreate(boolean isFolder) {
        File tmp = TestFileSystemEntry.exampleTempFile();
        return this.helpTestCreate(tmp, isFolder);
    }

    private FileSystemEntry helpTestCreate(File file, boolean isFolder) {
        FileSystemEntry fsEntry = null;
        try {
            fsEntry = isFolder ? new FileSystemEntry(file, (ObjectDefinition)DirectoryEntry.TYPE_FOLDER) : new FileSystemEntry(file, (ObjectDefinition)DirectoryEntry.TYPE_FILE);
        }
        catch (IOException e) {
            TestFileSystemEntry.fail((String)("Error creating new FileSystemEntry instance: " + e));
        }
        TestFileSystemEntry.assertNotNull((String)"Error creating new FileSystemEntry instance", (Object)fsEntry);
        return fsEntry;
    }

    public void testCreateEntry1() {
        FileSystemEntry fsEntry = this.helpTestCreate();
        FileSystemTestUtil.helpTestDefaultProperties(fsEntry, false);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testCreateEntry2() {
        FileSystemEntry fsEntry = this.helpTestCreate(false);
        FileSystemTestUtil.helpTestDefaultProperties(fsEntry, false);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testCreateEntry3() {
        FileSystemEntry fsEntry = this.helpTestCreate(true);
        FileSystemTestUtil.helpTestDefaultProperties(fsEntry, true);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testDeleteEntry1() {
        FileSystemEntry fsEntry = this.helpTestCreate(false);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testDeleteEntry2() {
        FileSystemEntry fsEntry = this.helpTestCreate(true);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testDeleteEntry3() {
        FileSystemEntry folder = this.helpTestCreate(true);
        File tmp = new File(folder.getFile(), TestFileSystemEntry.exampleTempFile().getName());
        FileSystemEntry testFile = this.helpTestCreate(tmp, false);
        FileSystemTestUtil.helpTestDelete(folder, false);
        FileSystemTestUtil.helpTestDelete(testFile, true);
        FileSystemTestUtil.helpTestDelete(folder, true);
    }

    public void testEquivalence1() {
        FileSystemEntry fsEntry = this.helpTestCreate(false);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)fsEntry, (Object)fsEntry);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testEquivalence2() {
        FileSystemEntry fsEntry = this.helpTestCreate(true);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)fsEntry, (Object)fsEntry);
        FileSystemTestUtil.helpTestDelete(fsEntry);
    }

    public void testEquivalence3() {
        FileSystemEntry fsEntryA = this.helpTestCreate(false);
        FileSystemEntry fsEntryB = this.helpTestCreate(true);
        UnitTestUtil.helpTestEquivalence((int)-1, (Object)fsEntryA, (Object)fsEntryB);
        FileSystemTestUtil.helpTestDelete(fsEntryA);
        FileSystemTestUtil.helpTestDelete(fsEntryB);
    }

    public void testEquivalence4() {
        File testFile = TestFileSystemEntry.exampleTempFile();
        FileSystemEntry fsEntryA = this.helpTestCreate(testFile, false);
        FileSystemEntry fsEntryB = this.helpTestCreate(testFile, false);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)fsEntryA, (Object)fsEntryB);
        FileSystemTestUtil.helpTestDelete(fsEntryA);
        FileSystemTestUtil.helpTestDelete(fsEntryB, false);
    }

    public void testEquivalence5() {
        File testFile = TestFileSystemEntry.exampleTempFile();
        File controlFile = new File(testFile.getParentFile(), testFile.getName());
        FileSystemEntry fsEntryA = this.helpTestCreate(testFile, false);
        FileSystemEntry fsEntryB = this.helpTestCreate(controlFile, false);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)fsEntryA, (Object)fsEntryB);
        FileSystemTestUtil.helpTestDelete(fsEntryA);
        FileSystemTestUtil.helpTestDelete(fsEntryB, false);
    }

    public void testMove1() {
        FileSystemEntry folderA = this.helpTestCreate(true);
        FileSystemEntry folderB = this.helpTestCreate(true);
        File tmp = new File(folderA.getFile(), TestFileSystemEntry.exampleTempFile().getName());
        FileSystemEntry testFile = this.helpTestCreate(tmp, false);
        boolean success = testFile.move(folderB);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + testFile + "\" was not successfully moved under \"" + folderB.getFullName() + "\""), (boolean)success);
        File newParent = testFile.getFile().getParentFile();
        TestFileSystemEntry.assertTrue((String)("The parent \"" + newParent + "\" is not \"" + folderB.getFullName() + "\""), (boolean)newParent.equals(folderB.getFile()));
        FileSystemTestUtil.helpTestDefaultProperties(testFile, false);
        FileSystemTestUtil.helpTestDelete(testFile);
        FileSystemTestUtil.helpTestDelete(folderB);
        FileSystemTestUtil.helpTestDelete(folderA);
    }

    public void testMove2() {
        FileSystemEntry folderA = this.helpTestCreate(true);
        FileSystemEntry folderB = this.helpTestCreate(true);
        File tmp = new File(folderA.getFile(), TestFileSystemEntry.exampleTempFile().getName());
        FileSystemEntry folderC = this.helpTestCreate(tmp, true);
        tmp = new File(folderC.getFile(), TestFileSystemEntry.exampleTempFile().getName());
        FileSystemEntry testFile = this.helpTestCreate(tmp, false);
        FileSystemEntry controlFile = this.helpTestCreate(tmp, false);
        boolean success = testFile.move(folderB);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + testFile + "\" was not successfully moved under \"" + folderB.getFullName() + "\""), (boolean)success);
        File newParent = testFile.getFile().getParentFile();
        TestFileSystemEntry.assertTrue((String)("The parent \"" + newParent + "\" is not \"" + folderB.getFullName() + "\""), (boolean)newParent.equals(folderB.getFile()));
        FileSystemTestUtil.helpTestDefaultProperties(testFile, false);
        success = testFile.move(folderC);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + testFile + "\" was not successfully moved under \"" + folderC.getFullName() + "\""), (boolean)success);
        File oldParent = testFile.getFile().getParentFile();
        TestFileSystemEntry.assertTrue((String)("The parent \"" + oldParent + "\" is not \"" + folderC.getFullName() + "\""), (boolean)oldParent.equals(folderC.getFile()));
        FileSystemTestUtil.helpTestDefaultProperties(testFile, false);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)testFile, (Object)controlFile);
        FileSystemTestUtil.helpTestDelete(testFile);
        FileSystemTestUtil.helpTestDelete(folderC);
        FileSystemTestUtil.helpTestDelete(folderB);
        FileSystemTestUtil.helpTestDelete(folderA);
    }

    public void testRenameTo() {
        File testFile = TestFileSystemEntry.exampleTempFile();
        File controlFile = new File(testFile.getParentFile(), testFile.getName());
        FileSystemEntry fsEntryA = this.helpTestCreate(testFile, false);
        FileSystemEntry fsEntryB = this.helpTestCreate(controlFile, false);
        String oldName = testFile.getName();
        String newName = oldName + "Renamed";
        boolean success = fsEntryA.renameTo(newName);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + fsEntryA + "\" was not successfully renamed to \"" + newName + "\""), (boolean)success);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + fsEntryA + "\" was not successfully renamed to \"" + newName + "\""), (boolean)fsEntryA.getFile().getName().equals(newName));
        success = fsEntryA.renameTo(oldName);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + fsEntryA + "\" was not successfully renamed to \"" + oldName + "\""), (boolean)success);
        TestFileSystemEntry.assertTrue((String)("The FileSystemEntry \"" + fsEntryA + "\" was not successfully renamed to \"" + oldName + "\""), (boolean)fsEntryA.getFile().getName().equals(oldName));
        UnitTestUtil.helpTestEquivalence((int)0, (Object)fsEntryA, (Object)fsEntryB);
        FileSystemTestUtil.helpTestDelete(fsEntryA);
        FileSystemTestUtil.helpTestDelete(fsEntryB, false);
    }
}

