/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemEntryEditor;
import com.metamatrix.common.tree.directory.FileSystemTestUtil;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.common.tree.directory.TestFileSystemEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileSystemEntryEditor
extends TestCase {
    private static Map TEST_ENTRIES = new HashMap();
    private static File ROOT = TestFileSystemEntry.exampleTempFile();

    public TestFileSystemEntryEditor(String name) {
        super(name);
    }

    public static void oneTimeSetUp() {
        ROOT.mkdir();
        try {
            TEST_ENTRIES.put("testFileA", new FileSystemEntry(new File(ROOT, "testFileA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileB", new FileSystemEntry(new File(ROOT, "testFileB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileC", new FileSystemEntry(new File(ROOT, "testFileC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileD", new FileSystemEntry(new File(ROOT, "testFileD"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderX", new FileSystemEntry(new File(ROOT, "testFolderX"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderX = ((FileSystemEntry)TEST_ENTRIES.get("testFolderX")).getFile();
            TEST_ENTRIES.put("testFileXA", new FileSystemEntry(new File(folderX, "testFileXA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileXB", new FileSystemEntry(new File(folderX, "testFileXB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileXC", new FileSystemEntry(new File(folderX, "testFileXC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderY", new FileSystemEntry(new File(ROOT, "testFolderY"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderY = ((FileSystemEntry)TEST_ENTRIES.get("testFolderY")).getFile();
            TEST_ENTRIES.put("testFileYA", new FileSystemEntry(new File(folderY, "testFileYA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileYB", new FileSystemEntry(new File(folderY, "testFileYB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileYC", new FileSystemEntry(new File(folderY, "testFileYC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderZ", new FileSystemEntry(new File(ROOT, "testFolderZ"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderZ = ((FileSystemEntry)TEST_ENTRIES.get("testFolderZ")).getFile();
            TEST_ENTRIES.put("testFileZA", new FileSystemEntry(new File(folderZ, "testFileZA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileZB", new FileSystemEntry(new File(folderZ, "testFileZB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileZC", new FileSystemEntry(new File(folderZ, "testFileZC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
        }
        catch (IOException e) {
            TestFileSystemEntryEditor.oneTimeTearDown();
            TestFileSystemEntryEditor.fail((String)("Error creating new FileSystemEntry instance: " + e));
        }
    }

    public static void oneTimeTearDown() {
        boolean success;
        for (FileSystemEntry entry : TEST_ENTRIES.values()) {
            if (entry.isFolder()) continue;
            success = entry.delete();
            TestFileSystemEntryEditor.assertTrue((String)("FileSystemEntry \"" + entry + "\" was not deleted successfully"), (boolean)success);
        }
        for (FileSystemEntry entry : TEST_ENTRIES.values()) {
            if (!entry.isFolder()) continue;
            success = entry.delete();
            TestFileSystemEntryEditor.assertTrue((String)("FileSystemEntry \"" + entry + "\" was not deleted successfully"), (boolean)success);
        }
        ROOT.delete();
    }

    public static FileSystemView exampleView(boolean showRoot) {
        return new FileSystemView(ROOT, showRoot);
    }

    public static FileSystemView exampleView() {
        return new FileSystemView();
    }

    public void testCreateEntry1() {
        FileSystemView fsView = TestFileSystemEntryEditor.exampleView(false);
        FileSystemEntryEditor editor = (FileSystemEntryEditor)fsView.getDirectoryEntryEditor();
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry newEntry1 = (FileSystemEntry)editor.create((TreeNode)root, "testFileE", (ObjectDefinition)DirectoryEntry.TYPE_FILE);
        FileSystemTestUtil.helpTestDefaultProperties(newEntry1, false);
        List results = fsView.getChildren((TreeNode)root);
        ArrayList<Object> expectedResults = new ArrayList<Object>(10);
        expectedResults.add(TEST_ENTRIES.get("testFileA"));
        expectedResults.add(TEST_ENTRIES.get("testFileB"));
        expectedResults.add(TEST_ENTRIES.get("testFileC"));
        expectedResults.add(TEST_ENTRIES.get("testFileD"));
        expectedResults.add(TEST_ENTRIES.get("testFolderX"));
        expectedResults.add(TEST_ENTRIES.get("testFolderY"));
        expectedResults.add(TEST_ENTRIES.get("testFolderZ"));
        expectedResults.add(newEntry1);
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
        FileSystemTestUtil.helpTestDelete(newEntry1, true);
    }

    public void testCreateEntry2() {
        FileSystemView fsView = TestFileSystemEntryEditor.exampleView(false);
        FileSystemEntryEditor editor = (FileSystemEntryEditor)fsView.getDirectoryEntryEditor();
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry newEntry1 = (FileSystemEntry)editor.create((TreeNode)root, "testFolderW", (ObjectDefinition)DirectoryEntry.TYPE_FOLDER);
        FileSystemTestUtil.helpTestDefaultProperties(newEntry1, true);
        List results = fsView.getChildren((TreeNode)root);
        ArrayList<Object> expectedResults = new ArrayList<Object>(10);
        expectedResults.add(TEST_ENTRIES.get("testFileA"));
        expectedResults.add(TEST_ENTRIES.get("testFileB"));
        expectedResults.add(TEST_ENTRIES.get("testFileC"));
        expectedResults.add(TEST_ENTRIES.get("testFileD"));
        expectedResults.add(TEST_ENTRIES.get("testFolderX"));
        expectedResults.add(TEST_ENTRIES.get("testFolderY"));
        expectedResults.add(TEST_ENTRIES.get("testFolderZ"));
        expectedResults.add(newEntry1);
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
        FileSystemTestUtil.helpTestDelete(newEntry1, true);
    }

    public void testCopy1() {
        FileSystemView fsView = TestFileSystemEntryEditor.exampleView(false);
        FileSystemEntryEditor editor = (FileSystemEntryEditor)fsView.getDirectoryEntryEditor();
        FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder1 = (FileSystemEntry)TEST_ENTRIES.get("testFolderX");
        FileSystemEntry newEntry1 = (FileSystemEntry)editor.create((TreeNode)folder1, "testFileE", (ObjectDefinition)DirectoryEntry.TYPE_FILE);
        FileSystemTestUtil.helpTestDefaultProperties(newEntry1, false);
        FileSystemEntry folder2 = (FileSystemEntry)TEST_ENTRIES.get("testFolderZ");
        FileSystemEntry newEntry2 = (FileSystemEntry)editor.copy((TreeNode)newEntry1, (TreeNode)folder2);
        List folderContents = fsView.getChildren((TreeNode)folder1);
        ArrayList<Object> expectedResults = new ArrayList<Object>(10);
        expectedResults.add(TEST_ENTRIES.get("testFileXA"));
        expectedResults.add(TEST_ENTRIES.get("testFileXB"));
        expectedResults.add(TEST_ENTRIES.get("testFileXC"));
        expectedResults.add(newEntry1);
        FileSystemTestUtil.helpCompareResults(folderContents, expectedResults);
        folderContents = fsView.getChildren((TreeNode)folder2);
        expectedResults.clear();
        expectedResults.add(TEST_ENTRIES.get("testFileZA"));
        expectedResults.add(TEST_ENTRIES.get("testFileZB"));
        expectedResults.add(TEST_ENTRIES.get("testFileZC"));
        expectedResults.add(newEntry2);
        FileSystemTestUtil.helpCompareResults(folderContents, expectedResults);
        FileSystemTestUtil.helpTestDelete(newEntry1, true);
        FileSystemTestUtil.helpTestDelete(newEntry2, true);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestFileSystemEntryEditor.class);
        return new TestSetup((Test)suite){

            public void setUp() {
                TestFileSystemEntryEditor.oneTimeSetUp();
            }

            public void tearDown() {
                TestFileSystemEntryEditor.oneTimeTearDown();
            }
        };
    }
}

