/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemTestUtil;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.common.tree.directory.TestFileSystemEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileSystemView
extends TestCase {
    private static Map TEST_ENTRIES = new HashMap();
    private static File ROOT = TestFileSystemEntry.exampleTempFile();

    public TestFileSystemView(String name) {
        super(name);
    }

    public static void oneTimeSetUp() {
        ROOT.mkdir();
        try {
            TEST_ENTRIES.put("testFileA", new FileSystemEntry(new File(ROOT, "testFileA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileB", new FileSystemEntry(new File(ROOT, "testFileB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileC", new FileSystemEntry(new File(ROOT, "testFileC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileD", new FileSystemEntry(new File(ROOT, "testFileD"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderX", new FileSystemEntry(new File(ROOT, "testFolderX"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderX = ((FileSystemEntry)TEST_ENTRIES.get("testFolderX")).getFile();
            TEST_ENTRIES.put("testFileXA", new FileSystemEntry(new File(folderX, "testFileXA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileXB", new FileSystemEntry(new File(folderX, "testFileXB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileXC", new FileSystemEntry(new File(folderX, "testFileXC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderY", new FileSystemEntry(new File(ROOT, "testFolderY"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderY = ((FileSystemEntry)TEST_ENTRIES.get("testFolderY")).getFile();
            TEST_ENTRIES.put("testFileYA", new FileSystemEntry(new File(folderY, "testFileYA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileYB", new FileSystemEntry(new File(folderY, "testFileYB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileYC", new FileSystemEntry(new File(folderY, "testFileYC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFolderZ", new FileSystemEntry(new File(ROOT, "testFolderZ"), (ObjectDefinition)DirectoryEntry.TYPE_FOLDER));
            File folderZ = ((FileSystemEntry)TEST_ENTRIES.get("testFolderZ")).getFile();
            TEST_ENTRIES.put("testFileZA", new FileSystemEntry(new File(folderZ, "testFileZA"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileZB", new FileSystemEntry(new File(folderZ, "testFileZB"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
            TEST_ENTRIES.put("testFileZC", new FileSystemEntry(new File(folderZ, "testFileZC"), (ObjectDefinition)DirectoryEntry.TYPE_FILE));
        }
        catch (IOException e) {
            TestFileSystemView.oneTimeTearDown();
            TestFileSystemView.fail((String)("Error creating new FileSystemEntry instance: " + e));
        }
    }

    public static void oneTimeTearDown() {
        boolean success;
        for (FileSystemEntry entry : TEST_ENTRIES.values()) {
            if (entry.isFolder()) continue;
            success = entry.delete();
            TestFileSystemView.assertTrue((String)("FileSystemEntry \"" + entry + "\" was not deleted successfully"), (boolean)success);
        }
        for (FileSystemEntry entry : TEST_ENTRIES.values()) {
            if (!entry.isFolder()) continue;
            success = entry.delete();
            TestFileSystemView.assertTrue((String)("FileSystemEntry \"" + entry + "\" was not deleted successfully"), (boolean)success);
        }
        ROOT.delete();
    }

    public static FileSystemView exampleView(boolean showRoot) {
        return new FileSystemView(ROOT, showRoot);
    }

    public static FileSystemView exampleView() {
        return new FileSystemView();
    }

    public static FileSystemEntry exampleEntry(FileSystemView fsView, boolean returnFolder) {
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        return TestFileSystemView.exampleEntry(fsView, root, returnFolder);
    }

    public static FileSystemEntry exampleEntry(FileSystemView fsView, FileSystemEntry parent, boolean returnFolder) {
        TestFileSystemView.assertNotNull((String)"The FileSystemView reference should not be null", (Object)fsView);
        TestFileSystemView.assertNotNull((String)"The FileSystemEntry reference should not be null", (Object)parent);
        TestFileSystemView.assertTrue((String)"The FileSystemEntry reference must be a folder", (boolean)parent.isFolder());
        for (FileSystemEntry entry : fsView.getChildren((TreeNode)parent)) {
            if (entry.isFolder() && returnFolder) {
                return entry;
            }
            if (entry.isFolder() || returnFolder) continue;
            return entry;
        }
        return null;
    }

    public void helpTestLookup(FileSystemView fsView, String path, FileSystemEntry expectedResult) {
        this.helpTestLookup(fsView, path, fsView.getSeparator(), expectedResult);
    }

    public void helpTestLookup(FileSystemView fsView, String path, String separator, FileSystemEntry expectedResult) {
        FileSystemEntry result = (FileSystemEntry)fsView.lookup(path, separator);
        TestFileSystemView.assertTrue((String)("Lookup returned \"" + result + "\", expected \"" + expectedResult + "\""), (result == expectedResult ? 1 : 0) != 0);
    }

    public void helpTestLookup(FileSystemView fsView, String path, String separator, File expectedResult) {
        FileSystemEntry result = (FileSystemEntry)fsView.lookup(path, separator);
        TestFileSystemView.assertEquals((String)("Lookup returned \"" + result + "\", expected \"" + expectedResult + "\""), (String)expectedResult.getAbsolutePath(), (String)result.getFile().getAbsolutePath());
    }

    public void testCreate1() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        List roots = fsView.getActualRoots();
        TestFileSystemView.assertTrue((String)("FileSystemView has " + roots.size() + " root(s)"), (roots.size() == 1 ? 1 : 0) != 0);
        FileSystemEntry root = (FileSystemEntry)roots.iterator().next();
        TestFileSystemView.assertTrue((String)"FileSystemView root has changed.", (root.getFile() == ROOT ? 1 : 0) != 0);
        roots = fsView.getRoots();
        TestFileSystemView.assertTrue((String)("FileSystemView has " + roots.size() + " root(s)"), (roots.size() == 1 ? 1 : 0) != 0);
        root = (FileSystemEntry)roots.iterator().next();
        TestFileSystemView.assertTrue((String)"FileSystemView root has changed.", (root.getFile() == ROOT ? 1 : 0) != 0);
        FileSystemEntry home = (FileSystemEntry)fsView.getHome();
        TestFileSystemView.assertTrue((String)"FileSystemView home has changed.", (home.getFile() == ROOT ? 1 : 0) != 0);
    }

    public void testCreate2() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        List roots = fsView.getActualRoots();
        TestFileSystemView.assertTrue((String)("FileSystemView has " + roots.size() + " root(s)"), (roots.size() == 1 ? 1 : 0) != 0);
        FileSystemEntry root = (FileSystemEntry)roots.iterator().next();
        TestFileSystemView.assertTrue((String)"FileSystemView root has changed.", (root.getFile() == ROOT ? 1 : 0) != 0);
        roots = fsView.getRoots();
        TestFileSystemView.assertTrue((String)("FileSystemView has " + roots.size() + " root(s)"), (roots.size() == 3 ? 1 : 0) != 0);
        FileSystemEntry home = (FileSystemEntry)fsView.getHome();
        TestFileSystemView.assertTrue((String)"FileSystemView home has changed.", (home.getFile() == ROOT ? 1 : 0) != 0);
    }

    public void testRoots1() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        List results = fsView.getRoots();
        ArrayList expectedResults = new ArrayList(5);
        expectedResults.add(TEST_ENTRIES.get("testFolderX"));
        expectedResults.add(TEST_ENTRIES.get("testFolderY"));
        expectedResults.add(TEST_ENTRIES.get("testFolderZ"));
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
    }

    public void testRoots2() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        List results = fsView.getRoots();
        ArrayList<FileSystemEntry> expectedResults = new ArrayList<FileSystemEntry>(1);
        expectedResults.add(FileSystemTestUtil.helpGetActualRoot(fsView));
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
    }

    public void testRoots3() {
        FileSystemView fsView = TestFileSystemView.exampleView();
        List results = fsView.getRoots();
        TestFileSystemView.assertTrue((String)("The number of roots found is " + results.size() + ", expected >= 1"), (results.size() >= 1 ? 1 : 0) != 0);
    }

    public void testHome() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry home = FileSystemTestUtil.helpLookupByName("testFolderY", fsView.getChildren((TreeNode)root));
        fsView.setHome((TreeNode)home);
        TestFileSystemView.assertTrue((String)("FileSystemView home is " + fsView.getHome() + ", expected " + home), (fsView.getHome() == home ? 1 : 0) != 0);
    }

    public void testChildren1() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        List results = fsView.getChildren((TreeNode)root);
        ArrayList expectedResults = new ArrayList(10);
        expectedResults.add(TEST_ENTRIES.get("testFileA"));
        expectedResults.add(TEST_ENTRIES.get("testFileB"));
        expectedResults.add(TEST_ENTRIES.get("testFileC"));
        expectedResults.add(TEST_ENTRIES.get("testFileD"));
        expectedResults.add(TEST_ENTRIES.get("testFolderX"));
        expectedResults.add(TEST_ENTRIES.get("testFolderY"));
        expectedResults.add(TEST_ENTRIES.get("testFolderZ"));
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
    }

    public void testChildren2() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry parent = (FileSystemEntry)TEST_ENTRIES.get("testFolderX");
        List results = fsView.getChildren((TreeNode)parent);
        ArrayList expectedResults = new ArrayList(5);
        expectedResults.add(TEST_ENTRIES.get("testFileXA"));
        expectedResults.add(TEST_ENTRIES.get("testFileXB"));
        expectedResults.add(TEST_ENTRIES.get("testFileXC"));
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
    }

    public void testParent1() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry child = (FileSystemEntry)TEST_ENTRIES.get("testFileC");
        FileSystemEntry parent = (FileSystemEntry)fsView.getParent((TreeNode)child);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        TestFileSystemView.assertTrue((String)("Entry \"" + child + "\" should have parent \"" + root + "\""), (parent == root ? 1 : 0) != 0);
        FileSystemTestUtil.helpTestParentChildRelationship(fsView, parent, child);
    }

    public void testParent2() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry child = (FileSystemEntry)TEST_ENTRIES.get("testFileC");
        FileSystemEntry parent = (FileSystemEntry)fsView.getParent((TreeNode)child);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        TestFileSystemView.assertTrue((String)("Entry \"" + child + "\" should have parent \"" + root + "\""), (parent == root ? 1 : 0) != 0);
        FileSystemTestUtil.helpTestParentChildRelationship(fsView, parent, child);
    }

    public void testParent3() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry child = (FileSystemEntry)TEST_ENTRIES.get("testFileXB");
        FileSystemEntry parent = (FileSystemEntry)fsView.getParent((TreeNode)child);
        FileSystemEntry control = (FileSystemEntry)TEST_ENTRIES.get("testFolderX");
        TestFileSystemView.assertTrue((String)("Entry \"" + child + "\" should have parent \"" + control + "\""), (boolean)parent.equals((Object)control));
        FileSystemTestUtil.helpTestParentChildRelationship(fsView, parent, child);
    }

    public void testMarked() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        List childrenOfRoot = fsView.getChildren((TreeNode)root);
        FileSystemEntry folderX = FileSystemTestUtil.helpLookupByName("testFolderX", childrenOfRoot);
        FileSystemEntry folderY = FileSystemTestUtil.helpLookupByName("testFolderY", childrenOfRoot);
        FileSystemEntry folderZ = FileSystemTestUtil.helpLookupByName("testFolderZ", childrenOfRoot);
        fsView.setMarked((TreeNode)folderZ, true);
        fsView.setMarked((TreeNode)FileSystemTestUtil.helpLookupByName("testFileA", childrenOfRoot), true);
        fsView.setMarked((TreeNode)FileSystemTestUtil.helpLookupByName("testFileZA", fsView.getChildren((TreeNode)folderZ)), true);
        fsView.setMarked((TreeNode)FileSystemTestUtil.helpLookupByName("testFileXB", fsView.getChildren((TreeNode)folderX)), true);
        fsView.setMarked((TreeNode)FileSystemTestUtil.helpLookupByName("testFileYC", fsView.getChildren((TreeNode)folderY)), true);
        Set results = fsView.getMarked();
        ArrayList expectedResults = new ArrayList(5);
        expectedResults.add(TEST_ENTRIES.get("testFolderZ"));
        expectedResults.add(TEST_ENTRIES.get("testFileA"));
        expectedResults.add(TEST_ENTRIES.get("testFileZA"));
        expectedResults.add(TEST_ENTRIES.get("testFileXB"));
        expectedResults.add(TEST_ENTRIES.get("testFileYC"));
        FileSystemTestUtil.helpCompareResults(results, expectedResults);
    }

    public void testLookup1() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getPath((TreeNode)file);
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup2() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup3() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup4() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = root.getName() + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup5() {
        FileSystemView fsView = TestFileSystemView.exampleView(true);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getSeparator() + root.getName() + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup6() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getPath((TreeNode)file);
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup7() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup8() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup9() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = root.getName() + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup10() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = fsView.getSeparator() + root.getName() + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, file);
    }

    public void testLookup11() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String separator = "&";
        String path = separator + folder.getName() + separator + file.getName();
        this.helpTestLookup(fsView, path, separator, file);
    }

    public void testLookup12() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String separator = "&";
        String path = root.getName() + separator + folder.getName() + separator + file.getName();
        this.helpTestLookup(fsView, path, separator, file);
    }

    public void testLookup13() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        FileSystemEntry file = TestFileSystemView.exampleEntry(fsView, folder, false);
        String path = root.getName() + "&" + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + file.getName();
        this.helpTestLookup(fsView, path, null);
    }

    public void testLookup14() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        String path = fsView.getSeparator() + folder.getName() + fsView.getSeparator() + "nonExistentFile";
        this.helpTestLookup(fsView, path, null);
    }

    public void testLookup15() throws Exception {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        File file = new File(folder.getFile(), "existingFile");
        file.createNewFile();
        String path = fsView.getSeparator() + folder.getName() + fsView.getSeparator() + "existingFile";
        this.helpTestLookup(fsView, path, fsView.getSeparator(), file);
        file.delete();
    }

    public void testLookup16() {
        FileSystemView fsView = TestFileSystemView.exampleView(false);
        FileSystemEntry root = FileSystemTestUtil.helpGetActualRoot(fsView);
        FileSystemEntry folder = TestFileSystemView.exampleEntry(fsView, root, true);
        File file = new File(folder.getFile(), "existingFile");
        try {
            file.createNewFile();
            String path = fsView.getSeparator() + root.getName() + fsView.getSeparator() + folder.getName() + fsView.getSeparator() + "existingFile";
            this.helpTestLookup(fsView, path, fsView.getSeparator(), file);
            file.delete();
        }
        catch (IOException e) {
            TestFileSystemView.fail((String)"Failed to created test java.io.File instance");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestFileSystemView.class);
        return new TestSetup((Test)suite){

            public void setUp() {
                TestFileSystemView.oneTimeSetUp();
            }

            public void tearDown() {
                TestFileSystemView.oneTimeTearDown();
            }
        };
    }
}

