/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.util.Intervals;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TestIntervals
extends TestCase {
    public TestIntervals(String arg0) {
        super(arg0);
    }

    private LinkedList toLinkedList(int[] array) {
        LinkedList<Integer> intervals = new LinkedList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            intervals.add(new Integer(array[i]));
        }
        return intervals;
    }

    public void helpTestFindLocations(int[] intervalArray, int begin, int end, int[] expected) {
        int[] actual = Intervals.findLocations((LinkedList)this.toLinkedList(intervalArray), (int)begin, (int)end);
        TestIntervals.assertEquals((String)"Unexpected begin type ", (int)expected[0], (int)actual[0]);
        TestIntervals.assertEquals((String)"Unexpected begin index ", (int)expected[1], (int)actual[1]);
        TestIntervals.assertEquals((String)"Unexpected end type ", (int)expected[2], (int)actual[2]);
        TestIntervals.assertEquals((String)"Unexpected end index ", (int)expected[3], (int)actual[3]);
    }

    public void testFindLocations1() {
        int[] intervals = new int[]{5, 9};
        int[] expected = new int[]{Intervals.BEFORE_FIRST, 0, Intervals.BEFORE_FIRST, -1};
        this.helpTestFindLocations(intervals, 0, 1, expected);
    }

    public void testFindLocations2() {
        int[] intervals = new int[]{5, 9};
        int[] expected = new int[]{Intervals.AFTER_LAST, 0, Intervals.AFTER_LAST, 1};
        this.helpTestFindLocations(intervals, 10, 11, expected);
    }

    public void testFindLocations3() {
        int[] intervals = new int[]{5, 9};
        int[] expected = new int[]{Intervals.BEFORE_FIRST, 0, Intervals.WITHIN_INTERVAL, 1};
        this.helpTestFindLocations(intervals, 0, 7, expected);
    }

    public void testFindLocations4() {
        int[] intervals = new int[]{5, 9};
        int[] expected = new int[]{Intervals.WITHIN_INTERVAL, 0, Intervals.AFTER_LAST, 1};
        this.helpTestFindLocations(intervals, 6, 10, expected);
    }

    public void testFindLocations5() {
        int[] intervals = new int[]{5, 9};
        int[] expected = new int[]{Intervals.WITHIN_INTERVAL, 0, Intervals.WITHIN_INTERVAL, 1};
        this.helpTestFindLocations(intervals, 6, 7, expected);
    }

    public void testFindLocations6() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.BEFORE_FIRST, 0, Intervals.WITHIN_INTERVAL, 3};
        this.helpTestFindLocations(intervals, 0, 17, expected);
    }

    public void testFindLocations7() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.WITHIN_INTERVAL, 0, Intervals.BETWEEN_INTERVALS, 1};
        this.helpTestFindLocations(intervals, 6, 12, expected);
    }

    public void testFindLocations8() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.WITHIN_INTERVAL, 0, Intervals.WITHIN_INTERVAL, 5};
        this.helpTestFindLocations(intervals, 6, 27, expected);
    }

    public void testFindLocations9() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.BETWEEN_INTERVALS, 2, Intervals.WITHIN_INTERVAL, 5};
        this.helpTestFindLocations(intervals, 12, 27, expected);
    }

    public void testFindLocations10() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.BETWEEN_INTERVALS, 2, Intervals.AFTER_LAST, 5};
        this.helpTestFindLocations(intervals, 12, 31, expected);
    }

    public void testFindLocations11() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30};
        int[] expected = new int[]{Intervals.WITHIN_INTERVAL, 2, Intervals.AFTER_LAST, 5};
        this.helpTestFindLocations(intervals, 17, 31, expected);
    }

    public void helpTestMergeIntervals(int[] intervalArray, int firstIndex, int lastIndex, int[] expected) {
        LinkedList intervals = this.toLinkedList(intervalArray);
        Intervals.mergeIntervals((LinkedList)intervals, (int)firstIndex, (int)lastIndex);
        TestIntervals.assertEquals((String)"Didn't get expected merge results ", (Object)this.toLinkedList(expected), (Object)intervals);
    }

    public void testMergeIntervals1() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{5, 10};
        this.helpTestMergeIntervals(intervals, 0, 1, expected);
    }

    public void testMergeIntervals2() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30, 35, 40};
        int[] expected = new int[]{5, 40};
        this.helpTestMergeIntervals(intervals, 0, 7, expected);
    }

    public void testMergeIntervals3() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30, 35, 40};
        int[] expected = new int[]{5, 10, 15, 30, 35, 40};
        this.helpTestMergeIntervals(intervals, 2, 5, expected);
    }

    public void testMergeIntervals4() {
        int[] intervals = new int[]{5, 10, 15, 20, 25, 30, 35, 40};
        int[] expected = new int[]{5, 10, 15, 40};
        this.helpTestMergeIntervals(intervals, 2, 7, expected);
    }

    public void helpTestExpandIntervals(int[] intervalArray, int firstIndex, int begin, int end, int[] expected) {
        LinkedList intervals = this.toLinkedList(intervalArray);
        Intervals.expandInterval((LinkedList)intervals, (int)firstIndex, (int)begin, (int)end);
        TestIntervals.assertEquals((String)"Didn't get expected expanded results ", (Object)this.toLinkedList(expected), (Object)intervals);
    }

    public void testExpandInterval1() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{0, 10};
        this.helpTestExpandIntervals(intervals, 0, 0, 9, expected);
    }

    public void testExpandInterval2() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{5, 10};
        this.helpTestExpandIntervals(intervals, 0, 6, 9, expected);
    }

    public void testExpandInterval3() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{0, 15};
        this.helpTestExpandIntervals(intervals, 0, 0, 15, expected);
    }

    public void testExpandInterval4() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{5, 15};
        this.helpTestExpandIntervals(intervals, 0, 6, 15, expected);
    }

    public void helpTestCondenseIntervals(int[] intervalArray, int[] expected) {
        LinkedList intervals = this.toLinkedList(intervalArray);
        Intervals.condense((LinkedList)intervals);
        TestIntervals.assertEquals((String)"Didn't get expected condensed results ", (Object)this.toLinkedList(expected), (Object)intervals);
    }

    public void testCondensedInterval1() {
        int[] intervals = new int[]{5, 10};
        int[] expected = new int[]{5, 10};
        this.helpTestCondenseIntervals(intervals, expected);
    }

    public void testCondensedInterval2() {
        int[] intervals = new int[]{5, 10, 11, 15};
        int[] expected = new int[]{5, 15};
        this.helpTestCondenseIntervals(intervals, expected);
    }

    public void testCondensedInterval3() {
        int[] intervals = new int[]{5, 10, 11, 15, 16, 20};
        int[] expected = new int[]{5, 20};
        this.helpTestCondenseIntervals(intervals, expected);
    }

    public void testCondensedInterval4() {
        int[] intervals = new int[]{5, 10, 11, 15, 20, 25, 26, 30};
        int[] expected = new int[]{5, 15, 20, 30};
        this.helpTestCondenseIntervals(intervals, expected);
    }

    public void testAddIntervalDistinct() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        String expected = "[5, 10, 15, 20, 25, 30]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalBeforeBeginning() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(0, 1);
        String expected = "[0, 1, 5, 10]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalAtBeginning() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(2, 5);
        String expected = "[2, 10]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalAtEnd() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(9, 15);
        String expected = "[5, 15]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalOverlapping1() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(7, 15);
        i.addInterval(12, 20);
        String expected = "[5, 20]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalOverlapping2() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(7, 15);
        i.addInterval(2, 5);
        String expected = "[2, 15]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalOverlapping3() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(6, 19);
        String expected = "[5, 20]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalExpand() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(2, 20);
        String expected = "[2, 20]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalInsert() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(12, 13);
        String expected = "[5, 10, 12, 13, 15, 20]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalWithin() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(6, 7);
        String expected = "[5, 10]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalBetweenBetween() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        i.addInterval(12, 22);
        String expected = "[5, 10, 12, 22, 25, 30]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalBetweenWithin() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        i.addInterval(12, 27);
        String expected = "[5, 10, 12, 30]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalComplex() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        i.addInterval(12, 27);
        i.addInterval(11, 11);
        String expected = "[5, 30]";
        TestIntervals.assertEquals((String)"Invalid after adds ", (String)expected, (String)i.toString());
    }

    public void testAddIntervalError() {
        Intervals i = new Intervals();
        try {
            i.addInterval(5, 3);
            TestIntervals.fail((String)"Expected to get IllegalArgumentException when adding illegal interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveInterval1() {
        Intervals i = new Intervals();
        i.removeInterval(0, 10);
        String expected = "[]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval2() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(0, 2);
        String expected = "[5, 10]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval3() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(0, 5);
        String expected = "[6, 10]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval4() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(0, 6);
        String expected = "[7, 10]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval5() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(4, 8);
        String expected = "[9, 10]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval6() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(7, 10);
        String expected = "[5, 6]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval7() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(7, 11);
        String expected = "[5, 6]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval8() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(5, 10);
        String expected = "[]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval9() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.removeInterval(6, 9);
        String expected = "[5, 5, 10, 10]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval10() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.removeInterval(12, 14);
        String expected = "[5, 10, 15, 20]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval11() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.removeInterval(8, 17);
        String expected = "[5, 7, 18, 20]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval12() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.removeInterval(12, 17);
        String expected = "[5, 10, 18, 20]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval13() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.removeInterval(7, 25);
        String expected = "[5, 6]";
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)expected, (String)i.toString());
    }

    public void testRemoveInterval14() {
        Intervals i = new Intervals();
        i.addInterval(2, 3);
        i.removeInterval(0, 4);
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)"[]", (String)i.toString());
    }

    public void testRemoveInterval15() {
        Intervals i = new Intervals();
        i.addInterval(2, 3);
        i.removeInterval(4, 5);
        TestIntervals.assertEquals((String)"Invalid after remove ", (String)"[2, 3]", (String)i.toString());
    }

    public void testRemoveIntervalInvalid() {
        Intervals i = new Intervals();
        try {
            i.removeInterval(1, 0);
            TestIntervals.fail((String)"Expected IllegalArgumentException when removing invalid interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testContainsInterval1() {
        Intervals i = new Intervals();
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(0, 1));
    }

    public void testContainsInterval2() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)true, (boolean)i.containsInterval(5, 10));
    }

    public void testContainsInterval3() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)true, (boolean)i.containsInterval(6, 9));
    }

    public void testContainsInterval4() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(1, 2));
    }

    public void testContainsInterval5() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(20, 21));
    }

    public void testContainsInterval6() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(0, 7));
    }

    public void testContainsInterval7() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(7, 20));
    }

    public void testContainsInterval8() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(12, 15);
        TestIntervals.assertEquals((String)"Contains is wrong ", (boolean)false, (boolean)i.containsInterval(5, 15));
    }

    public void testContainsIntervalInvalid() {
        Intervals i = new Intervals();
        try {
            i.containsInterval(1, 0);
            TestIntervals.fail((String)"Expected IllegalArgumentException when checking containment of invalid interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntersection1() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        Intervals expected = new Intervals();
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(0, 1));
    }

    public void testIntersection2() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        Intervals expected = new Intervals();
        expected.addInterval(5, 7);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(0, 7));
    }

    public void testIntersection3() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        Intervals expected = new Intervals();
        expected.addInterval(5, 10);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(0, 12));
    }

    public void testIntersection4() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        Intervals expected = new Intervals();
        expected.addInterval(6, 9);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(6, 9));
    }

    public void testIntersection5() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        Intervals expected = new Intervals();
        expected.addInterval(6, 10);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(6, 12));
    }

    public void testIntersection6() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(6, 10);
        expected.addInterval(15, 16);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(6, 16));
    }

    public void testIntersection7() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(6, 10);
        expected.addInterval(15, 20);
        expected.addInterval(25, 26);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(6, 26));
    }

    public void testIntersection8() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(5, 10);
        expected.addInterval(15, 20);
        expected.addInterval(25, 30);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(1, 35));
    }

    public void testIntersection9() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(15, 20);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(11, 24));
    }

    public void testIntersection10() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(15, 20);
        expected.addInterval(25, 26);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(11, 26));
    }

    public void testIntersection11() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        i.addInterval(25, 30);
        Intervals expected = new Intervals();
        expected.addInterval(25, 30);
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(24, 40));
    }

    public void testIntersection12() {
        Intervals i = new Intervals();
        Intervals expected = new Intervals();
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(5, 10));
    }

    public void testIntersection13() {
        Intervals i = new Intervals();
        i.addInterval(5, 10);
        i.addInterval(15, 20);
        Intervals expected = new Intervals();
        TestIntervals.assertEquals((String)"Intersection is wrong ", (Object)expected, (Object)i.getIntersection(11, 12));
    }

    public void testIntersectionInvalid() {
        Intervals i = new Intervals();
        try {
            i.getIntersection(1, 0);
            TestIntervals.fail((String)"Expected IllegalArgumentException when checking containment of invalid interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEquals1() {
        Intervals i1 = new Intervals();
        i1.addInterval(5, 10);
        i1.addInterval(15, 20);
        Intervals i2 = new Intervals();
        i2.addInterval(5, 10);
        i2.addInterval(15, 20);
        TestIntervals.assertTrue((String)"Equals is wrong ", (boolean)i1.equals((Object)i2));
        TestIntervals.assertTrue((String)"Equals is wrong ", (boolean)i2.equals((Object)i1));
        TestIntervals.assertTrue((String)"Equals is wrong ", (i1.hashCode() == i2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals2() {
        Intervals i1 = new Intervals();
        i1.addInterval(5, 10);
        Intervals i2 = new Intervals();
        i2.addInterval(5, 11);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i1.equals((Object)i2) ? 1 : 0) != 0);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i2.equals((Object)i1) ? 1 : 0) != 0);
        TestIntervals.assertTrue((String)"Equals is wrong ", (i1.hashCode() != i2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals3() {
        Intervals i1 = new Intervals();
        i1.addInterval(5, 10);
        i1.addInterval(14, 20);
        Intervals i2 = new Intervals();
        i2.addInterval(5, 10);
        i2.addInterval(15, 20);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i1.equals((Object)i2) ? 1 : 0) != 0);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i2.equals((Object)i1) ? 1 : 0) != 0);
    }

    public void testEquals4() {
        Intervals i1 = new Intervals();
        i1.addInterval(5, 10);
        i1.addInterval(15, 20);
        Intervals i2 = new Intervals();
        i2.addInterval(5, 10);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i1.equals((Object)i2) ? 1 : 0) != 0);
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i2.equals((Object)i1) ? 1 : 0) != 0);
        TestIntervals.assertTrue((String)"Equals is wrong ", (i1.hashCode() != i2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals5() {
        Intervals i1 = new Intervals();
        TestIntervals.assertTrue((String)"Equals is wrong ", (boolean)i1.equals((Object)i1));
    }

    public void testEquals6() {
        Intervals i1 = new Intervals();
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i1.equals(null) ? 1 : 0) != 0);
    }

    public void testEquals7() {
        Intervals i1 = new Intervals();
        TestIntervals.assertTrue((String)"Equals is wrong ", (!i1.equals((Object)"abc") ? 1 : 0) != 0);
    }

    public void testRemoveIntervals() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        Intervals y = new Intervals();
        y.addInterval(21, 30);
        x.removeIntervals(y);
        TestIntervals.assertEquals((String)"[1, 20, 31, 100]", (String)x.toString());
    }

    public void testRemoveMultipleIntervals() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        Intervals y = new Intervals();
        y.addInterval(21, 30);
        y.addInterval(41, 50);
        x.removeIntervals(y);
        TestIntervals.assertEquals((String)"[1, 20, 31, 40, 51, 100]", (String)x.toString());
    }

    public void testGetBoundingInterval() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        int[] result = x.getBoundingInterval();
        TestIntervals.assertEquals((int)1, (int)result[0]);
        TestIntervals.assertEquals((int)100, (int)result[1]);
    }

    public void testGetBoundingIntervalWithMultipleIntervals() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        x.addInterval(200, 300);
        int[] result = x.getBoundingInterval();
        TestIntervals.assertEquals((int)1, (int)result[0]);
        TestIntervals.assertEquals((int)300, (int)result[1]);
    }

    public void testGetBoundingIntervalWithNoIntervals() {
        Intervals x = new Intervals();
        int[] result = x.getBoundingInterval();
        TestIntervals.assertEquals((int)Integer.MIN_VALUE, (int)result[0]);
        TestIntervals.assertEquals((int)Integer.MAX_VALUE, (int)result[1]);
    }

    public void testGetIntersectionIntervals() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        Intervals y = new Intervals();
        y.addInterval(10, 20);
        TestIntervals.assertEquals((String)"[10, 20]", (String)x.getIntersectionIntervals(y).toString());
    }

    public void testGetIntersectionIntervalsMultiple() {
        Intervals x = new Intervals();
        x.addInterval(1, 100);
        x.addInterval(201, 300);
        Intervals y = new Intervals();
        y.addInterval(90, 210);
        y.addInterval(290, 300);
        TestIntervals.assertEquals((String)"[90, 100, 201, 210, 290, 300]", (String)x.getIntersectionIntervals(y).toString());
    }

    public void testConstructorTakesInterval() {
        Intervals x = new Intervals(1, 100);
        TestIntervals.assertEquals((String)"[1, 100]", (String)x.toString());
    }

    public void testCopy() {
        Intervals x = new Intervals(1, 10);
        x.addInterval(20, 30);
        Intervals y = x.copy();
        TestIntervals.assertEquals((String)"[1, 10, 20, 30]", (String)y.toString());
        x.removeInterval(5, 25);
        TestIntervals.assertEquals((String)"[1, 10, 20, 30]", (String)y.toString());
    }

    public void testIsContiguous() {
        Intervals x = new Intervals();
        x.addInterval(5, 10);
        x.addInterval(0, 10);
        TestIntervals.assertTrue((boolean)x.isContiguous());
    }

    public void testIsNotContiguous() {
        Intervals x = new Intervals();
        x.addInterval(5, 10);
        x.addInterval(1, 3);
        TestIntervals.assertFalse((boolean)x.isContiguous());
    }

    public void testEmptyIntervalsIsContiguous() {
        Intervals x = new Intervals();
        TestIntervals.assertTrue((boolean)x.isContiguous());
    }
}

