/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.util.VDBNameValidator;
import junit.framework.TestCase;

public class TestVDBNameValidator
extends TestCase {
    public TestVDBNameValidator(String name) {
        super(name);
    }

    public final void testValidName1() {
        TestVDBNameValidator.assertTrue((boolean)VDBNameValidator.isValid((String)"ValidName"));
    }

    public final void testValidName2() {
        TestVDBNameValidator.assertTrue((boolean)VDBNameValidator.isValid((String)"System_1"));
    }

    public final void testValidName3() {
        TestVDBNameValidator.assertTrue((boolean)VDBNameValidator.isValid((String)"Admin__"));
    }

    public final void testValidNameWithUnderscore() {
        TestVDBNameValidator.assertTrue((boolean)VDBNameValidator.isValid((String)"Valid_Name"));
    }

    public final void testAllValidCharacters() {
        TestVDBNameValidator.assertTrue((boolean)VDBNameValidator.isValid((String)"abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public final void testInvalidName1() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"InvalidName`"));
    }

    public final void testInvalidName2() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"Inalid/Name"));
    }

    public final void testInvalidName3() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"Invalid-Name"));
    }

    public final void testInvalidName4() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"Invalid?Name"));
    }

    public final void testNameThatStartWithDigit() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"1VDBName"));
    }

    public final void testNameThatStartWithUnderscore() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"_VDBName"));
    }

    public final void testEmptyVDBName() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)""));
    }

    public final void testNullName() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid(null));
    }

    public final void testReservedSystemName() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"System"));
    }

    public final void testReservedHelpName() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"System"));
    }

    public final void testReservedAdminName() {
        TestVDBNameValidator.assertFalse((boolean)VDBNameValidator.isValid((String)"System"));
    }
}

