/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.keymanage;

import com.metamatrix.common.util.crypto.keymanage.FilePasswordConverter;
import com.metamatrix.core.util.UnitTestUtil;
import junit.framework.TestCase;

public class TestFilePasswordConverter
extends TestCase {
    private static final String INPUT_PROPERTIES_FILE = UnitTestUtil.getTestDataPath() + "/keymanage/convert.properties";
    private static final String INPUT_XML_FILE = UnitTestUtil.getTestDataPath() + "/keymanage/config.xml";
    private static final String INPUT_VDB_FILE = UnitTestUtil.getTestDataPath() + "/keymanage/ODBCvdb.VDB";
    private static final String KEYSTORE_FILE1 = UnitTestUtil.getTestDataPath() + "/keymanage/cluster.key";
    private static final String KEYSTORE_FILE2 = UnitTestUtil.getTestDataPath() + "/keymanage/other.key";
    private static final String TEMP_PROPERTIES = UnitTestUtil.getTestScratchPath() + "temp.properties";
    private static final String TEMP2_PROPERTIES = UnitTestUtil.getTestScratchPath() + "temp2.properties";
    private static final String TEMP_XML = UnitTestUtil.getTestScratchPath() + "temp.xml";
    private static final String TEMP2_XML = UnitTestUtil.getTestScratchPath() + "temp2.xml";
    private static final String TEMP_VDB = UnitTestUtil.getTestScratchPath() + "temp.vdb";
    private static final String TEMP2_VDB = UnitTestUtil.getTestScratchPath() + "temp2.vdb";

    public void testConvertProperties() throws Exception {
        String inputFile = INPUT_PROPERTIES_FILE;
        String outputFile = TEMP_PROPERTIES;
        String oldKeystoreFile = KEYSTORE_FILE1;
        String newKeystoreFile = KEYSTORE_FILE2;
        FilePasswordConverter converter = new FilePasswordConverter(inputFile, outputFile, 2, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)1, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("metamatrix.common.pooling.jdbc.Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
        inputFile = TEMP_PROPERTIES;
        outputFile = TEMP2_PROPERTIES;
        oldKeystoreFile = KEYSTORE_FILE2;
        newKeystoreFile = KEYSTORE_FILE1;
        converter = new FilePasswordConverter(inputFile, outputFile, 2, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)1, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("metamatrix.common.pooling.jdbc.Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
    }

    public void testConvertXML() throws Exception {
        String inputFile = INPUT_XML_FILE;
        String outputFile = TEMP_XML;
        String oldKeystoreFile = KEYSTORE_FILE1;
        String newKeystoreFile = KEYSTORE_FILE2;
        FilePasswordConverter converter = new FilePasswordConverter(inputFile, outputFile, 1, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)4, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
        inputFile = TEMP_XML;
        outputFile = TEMP2_XML;
        oldKeystoreFile = KEYSTORE_FILE2;
        newKeystoreFile = KEYSTORE_FILE1;
        converter = new FilePasswordConverter(inputFile, outputFile, 1, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)4, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
    }

    public void testConvertVDB() throws Exception {
        String inputFile = INPUT_VDB_FILE;
        String outputFile = TEMP_VDB;
        String oldKeystoreFile = KEYSTORE_FILE1;
        String newKeystoreFile = KEYSTORE_FILE2;
        FilePasswordConverter converter = new FilePasswordConverter(inputFile, outputFile, 3, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)4, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
        inputFile = TEMP_VDB;
        outputFile = TEMP2_VDB;
        oldKeystoreFile = KEYSTORE_FILE2;
        newKeystoreFile = KEYSTORE_FILE1;
        converter = new FilePasswordConverter(inputFile, outputFile, 3, oldKeystoreFile, newKeystoreFile);
        converter.convert();
        TestFilePasswordConverter.assertEquals((int)4, (int)converter.converted.size());
        TestFilePasswordConverter.assertTrue((boolean)converter.converted.contains("Password"));
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedDecrypt.size());
        TestFilePasswordConverter.assertEquals((int)0, (int)converter.failedEncrypt.size());
    }
}

