/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.common.vdb.api.DEFReaderWriter;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import junit.framework.TestCase;

public class TestDEFReaderWriter
extends TestCase {
    public void testReadDEF() throws Exception {
        String defFile = UnitTestUtil.getTestDataPath() + "/example.def";
        DEFReaderWriter reader = new DEFReaderWriter();
        BasicVDBDefn defn = reader.read((InputStream)new FileInputStream(defFile));
        this.checkDEF(defn);
    }

    private void checkDEF(BasicVDBDefn defn) {
        Properties header = defn.getHeaderProperties();
        TestDEFReaderWriter.assertEquals((String)"MetaMatrix Console", (String)header.getProperty("ApplicationCreatedBy"));
        TestDEFReaderWriter.assertEquals((String)"5.5:2849", (String)header.getProperty("ApplicationVersion"));
        TestDEFReaderWriter.assertEquals((String)"2007-10-18T11:01:41.622-06:00", (String)header.getProperty("Time"));
        TestDEFReaderWriter.assertEquals((String)"5.5", (String)header.getProperty("MetaMatrixSystemVersion"));
        TestDEFReaderWriter.assertEquals((String)"metamatrixadmin", (String)header.getProperty("UserCreatedBy"));
        TestDEFReaderWriter.assertEquals((String)"4.1", (String)header.getProperty("VDBExporterVersion"));
        TestDEFReaderWriter.assertEquals((String)"TransactionsRevisited", (String)defn.getName());
        TestDEFReaderWriter.assertEquals((String)"1", (String)defn.getVersion());
        TestDEFReaderWriter.assertEquals((String)"TR Desc", (String)defn.getDescription());
        TestDEFReaderWriter.assertEquals((String)"TransactionsRevisited.vdb", (String)defn.getFileName());
        TestDEFReaderWriter.assertEquals((String)"mmuuid:9f019542-006a-1087-ad13-8ecae4ac6516", (String)defn.getUUID());
        TestDEFReaderWriter.assertEquals((int)3, (int)defn.getModels().size());
        ModelInfo model = defn.getModel("pm2");
        TestDEFReaderWriter.assertEquals((String)"pm2", (String)model.getName());
        TestDEFReaderWriter.assertEquals((short)2, (short)model.getVisibility());
        TestDEFReaderWriter.assertEquals((boolean)Boolean.TRUE, (boolean)model.isMultiSourceBindingEnabled());
        TestDEFReaderWriter.assertEquals((int)1, (int)model.getConnectorBindingNames().size());
        TestDEFReaderWriter.assertEquals((Object)"pm2 Connector", model.getConnectorBindingNames().get(0));
        ModelInfo model2 = defn.getModel("vm");
        TestDEFReaderWriter.assertEquals((String)"vm", (String)model2.getName());
        TestDEFReaderWriter.assertEquals((short)0, (short)model2.getVisibility());
        TestDEFReaderWriter.assertFalse((boolean)model2.isMultiSourceBindingEnabled());
        TestDEFReaderWriter.assertEquals((int)0, (int)model2.getConnectorBindingNames().size());
        TestDEFReaderWriter.assertEquals((int)2, (int)defn.getConnectorTypes().size());
        TestDEFReaderWriter.assertNotNull((Object)defn.getConnectorType("Oracle ANSI JDBC XA Connector"));
        TestDEFReaderWriter.assertNull((Object)defn.getConnectorType("dummy"));
        TestDEFReaderWriter.assertEquals((int)2, (int)defn.getConnectorBindings().size());
        TestDEFReaderWriter.assertNotNull((Object)defn.getConnectorBindingByName("pm2 Connector"));
        TestDEFReaderWriter.assertNull((Object)defn.getConnectorType("dummy"));
    }

    public void testDEFWrite() throws IOException {
        File defFile = new File(UnitTestUtil.getTestDataPath() + "/example.def");
        File exportedFile = new File(UnitTestUtil.getTestDataPath() + "/example.def.exported");
        DEFReaderWriter reader = new DEFReaderWriter();
        BasicVDBDefn defn = reader.read((InputStream)new FileInputStream(defFile));
        Properties header = new Properties();
        header.setProperty("VDBExporterVersion", "4.1");
        header.setProperty("ApplicationCreatedBy", "MetaMatrix Console");
        header.setProperty("ApplicationVersion", "5.5:2849");
        header.setProperty("UserCreatedBy", "metamatrixadmin");
        header.setProperty("MetaMatrixSystemVersion", "5.5");
        header.setProperty("Time", "2007-10-18T11:01:41.622-06:00");
        reader.write((OutputStream)new FileOutputStream(exportedFile), defn, header);
        this.checkDEF(reader.read((InputStream)new FileInputStream(exportedFile)));
        exportedFile.delete();
    }
}

