/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.vdb.api;

import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public class TestVDBArchive
extends TestCase {
    static final String vdbPath = UnitTestUtil.getTestDataPath() + "/Test.vdb";

    public void testFileVDBArchive() throws Exception {
        FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/QT_Ora9DS.vdb"), (String)vdbPath);
        File vdbFile = new File(vdbPath);
        VDBArchive archive = new VDBArchive(vdbFile);
        BasicVDBDefn def = archive.getConfigurationDef();
        TestVDBArchive.assertEquals((String)"QT_Ora9DS", (String)def.getName());
        TestVDBArchive.assertEquals((int)8, (int)def.getModels().size());
        TestVDBArchive.assertEquals((int)0, (int)def.getModel("BQT2").getModelType());
        TestVDBArchive.assertEquals((String)"/BQT/XQTNestedDoc.xmi", (String)def.getModel("XQTNestedDoc").getPath());
        TestVDBArchive.assertNull((Object)archive.getDataRoles());
        String roles = "<data>roles, roles, roles.. any one?</data>";
        archive.updateRoles(roles.toCharArray());
        String anotherDEF = UnitTestUtil.getTestDataPath() + File.separator + "example.def";
        archive.updateConfigurationDef(VDBArchive.readFromDef((InputStream)new FileInputStream(anotherDEF)));
        archive.close();
        archive = new VDBArchive(vdbFile);
        def = archive.getConfigurationDef();
        TestVDBArchive.assertEquals((String)"TransactionsRevisited", (String)def.getName());
        TestVDBArchive.assertEquals((int)3, (int)def.getModels().size());
        TestVDBArchive.assertNotNull((Object)archive.getDataRoles());
        TestVDBArchive.assertEquals((String)roles, (String)new String(archive.getDataRoles()).trim());
        archive.close();
        vdbFile.delete();
    }

    public void testStreamVDBArchive() throws Exception {
        File vdbFile = new File(vdbPath);
        VDBArchive archive = new VDBArchive((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + "/QT_Ora9DS.vdb"));
        BasicVDBDefn def = archive.getConfigurationDef();
        TestVDBArchive.assertEquals((String)"QT_Ora9DS", (String)def.getName());
        TestVDBArchive.assertEquals((int)8, (int)def.getModels().size());
        TestVDBArchive.assertNull((Object)archive.getDataRoles());
        String roles = "<data>roles, roles, roles.. any one?</data>";
        archive.updateRoles(roles.toCharArray());
        String anotherDEF = UnitTestUtil.getTestDataPath() + File.separator + "example.def";
        archive.updateConfigurationDef(VDBArchive.readFromDef((InputStream)new FileInputStream(anotherDEF)));
        FileUtils.write((InputStream)archive.getInputStream(), (File)vdbFile);
        archive.close();
        archive = new VDBArchive(vdbFile);
        def = archive.getConfigurationDef();
        TestVDBArchive.assertEquals((String)"TransactionsRevisited", (String)def.getName());
        TestVDBArchive.assertEquals((int)3, (int)def.getModels().size());
        TestVDBArchive.assertNotNull((Object)archive.getDataRoles());
        TestVDBArchive.assertEquals((String)roles, (String)new String(archive.getDataRoles()).trim());
        archive.close();
        vdbFile.delete();
    }
}

