/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml;

import com.metamatrix.common.xml.XmlUtil;
import junit.framework.TestCase;

public class TestXmlUtil
extends TestCase {
    public static String TEST_STRING_1 = "this is a > test &amp";
    public static String RESULT_STRING_1 = "this is a &gt; test &amp;amp";
    public static String TEST_STRING_2 = "this \" is a > < test &amp";
    public static String RESULT_STRING_2 = "this &quot; is a &gt; &lt; test &amp;amp";

    public TestXmlUtil(String name) {
        super(name);
    }

    public void helpCheckValidCharacters(String str, boolean shouldBeValid) {
        String reason = XmlUtil.containsValidCharacters((String)str);
        if (shouldBeValid) {
            TestXmlUtil.assertNull((String)("Expected the string \"" + str + "\" to contain all valid characters; actual reason: " + reason), (Object)reason);
        } else {
            TestXmlUtil.assertNotNull((Object)("Expected the string \"" + str + "\" to contain some invalid characters; but no invalid characters found"));
        }
    }

    protected boolean isCharacterValid(char c) {
        if (c == '\n') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        if (c == '\t') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        if (c <= '\ufffd') {
            return true;
        }
        if (c < '\u10000') {
            return false;
        }
        return c <= '\u10ffff';
    }

    public void helpTestValidCharacters(long maxLength, boolean validXmlCharsOnly) {
        long maxLengthEachString = Math.max(2L, maxLength);
        if (!validXmlCharsOnly) {
            --maxLengthEachString;
        }
        StringBuffer sb = new StringBuffer();
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            if ((long)sb.length() == maxLengthEachString) {
                if (!validXmlCharsOnly) {
                    sb.append(32);
                }
                this.helpCheckValidCharacters(sb.toString(), validXmlCharsOnly);
                sb = new StringBuffer();
            }
            if (validXmlCharsOnly && !this.isCharacterValid(c)) continue;
            sb.append(c);
        }
        if (!validXmlCharsOnly) {
            sb.append(32);
        }
        this.helpCheckValidCharacters(sb.toString(), validXmlCharsOnly);
    }

    public void testContainsValidCharactersInStrings10CharsLong() {
        this.helpTestValidCharacters(10L, true);
    }

    public void testContainsValidCharactersInStrings100CharsLong() {
        this.helpTestValidCharacters(100L, true);
    }

    public void testContainsValidCharactersInStrings1000CharsLong() {
        this.helpTestValidCharacters(1000L, true);
    }

    public void testContainsInvalidCharactersInStrings10CharsLong() {
        this.helpTestValidCharacters(10L, false);
    }

    public void testContainsInvalidCharactersInStrings100CharsLong() {
        this.helpTestValidCharacters(100L, false);
    }

    public void testContainsInvalidCharactersInStrings1000CharsLong() {
        this.helpTestValidCharacters(1000L, false);
    }

    public void testEscapeCharacterData1() {
        String result = XmlUtil.escapeCharacterData((String)TEST_STRING_1);
        TestXmlUtil.assertEquals((String)RESULT_STRING_1, (String)result);
    }

    public void testEscapeCharacterData2() {
        String result = XmlUtil.escapeCharacterData((String)TEST_STRING_2);
        TestXmlUtil.assertEquals((String)RESULT_STRING_2, (String)result);
    }

    public void testEscapeCharacterDataEmptyString() {
        String result = XmlUtil.escapeCharacterData((String)"");
        TestXmlUtil.assertEquals((String)"", (String)result);
    }

    public void testEscapeCharacterDataNullParam() {
        String result = XmlUtil.escapeCharacterData(null);
        TestXmlUtil.assertEquals(null, (String)result);
    }
}

